/*
 * Decompiled with CFR 0.152.
 */
package cz.ackee.phoneformatter;

import android.telephony.PhoneNumberUtils;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextWatcher;
import com.google.i18n.phonenumbers.AsYouTypeFormatter;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0016J(\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0016J\u0018\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J \u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J(\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u001a\u0010 \u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0016H\u0002J\b\u0010\"\u001a\u00020\u0011H\u0002R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcz/ackee/phoneformatter/PhoneNumberFormatter;", "Landroid/text/TextWatcher;", "countryCode", "", "(Ljava/lang/String;)V", "value", "getCountryCode", "()Ljava/lang/String;", "setCountryCode", "lastEditable", "Landroid/text/Editable;", "mFormatter", "Lcom/google/i18n/phonenumbers/AsYouTypeFormatter;", "mSelfChange", "", "mStopFormatting", "afterTextChanged", "", "s", "beforeTextChanged", "", "start", "", "count", "after", "getFormattedNumber", "lastNonSeparator", "", "hasCursor", "hasSeparator", "onTextChanged", "before", "reformat", "cursor", "stopFormatting", "phoneformatter_release"})
public final class PhoneNumberFormatter
implements TextWatcher {
    private AsYouTypeFormatter mFormatter;
    private Editable lastEditable;
    @NotNull
    private String countryCode;
    private boolean mSelfChange;
    private boolean mStopFormatting;

    @NotNull
    public final String getCountryCode() {
        return this.countryCode;
    }

    public final void setCountryCode(@NotNull String value) {
        block0: {
            Editable editable;
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.countryCode = value;
            AsYouTypeFormatter asYouTypeFormatter = PhoneNumberUtil.getInstance().getAsYouTypeFormatter(this.countryCode);
            Intrinsics.checkExpressionValueIsNotNull((Object)asYouTypeFormatter, (String)"PhoneNumberUtil.getInsta\u2026AsYouTypeFormatter(field)");
            this.mFormatter = asYouTypeFormatter;
            Editable editable2 = this.lastEditable;
            if (editable2 == null) break block0;
            Editable it = editable = editable2;
            this.afterTextChanged(it);
        }
    }

    public void beforeTextChanged(@NotNull CharSequence s, int start, int count, int after) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        if (this.mSelfChange || this.mStopFormatting) {
            return;
        }
        if (count > 0 && this.hasSeparator(s, start, count)) {
            this.stopFormatting();
        }
    }

    public void onTextChanged(@NotNull CharSequence s, int start, int before, int count) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        if (this.mSelfChange || this.mStopFormatting) {
            return;
        }
        if (count > 0 && this.hasSeparator(s, start, count)) {
            this.stopFormatting();
        }
    }

    public synchronized void afterTextChanged(@NotNull Editable s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        if (this.mStopFormatting) {
            boolean bl;
            CharSequence charSequence = (CharSequence)s;
            PhoneNumberFormatter phoneNumberFormatter = this;
            phoneNumberFormatter.mStopFormatting = bl = charSequence.length() > 0;
            return;
        }
        if (this.mSelfChange) {
            return;
        }
        String formatted = this.reformat((CharSequence)s, Selection.getSelectionEnd((CharSequence)((CharSequence)s)));
        if (formatted != null) {
            int rememberedPos = this.mFormatter.getRememberedPosition();
            this.mSelfChange = true;
            s.replace(0, s.length(), (CharSequence)formatted, 0, formatted.length());
            if (Intrinsics.areEqual((Object)formatted, (Object)s.toString())) {
                Selection.setSelection((Spannable)((Spannable)s), (int)rememberedPos);
            }
            this.mSelfChange = false;
        }
        this.lastEditable = s;
    }

    /*
     * WARNING - void declaration
     */
    private final String reformat(CharSequence s, int cursor) {
        int curIndex = cursor - 1;
        String formatted = null;
        this.mFormatter.clear();
        char lastNonSeparator = (char)0;
        boolean hasCursor = false;
        int len = s.length();
        int n = 0;
        int n2 = len;
        while (n < n2) {
            void i;
            char c = s.charAt((int)i);
            if (PhoneNumberUtils.isNonSeparator((char)c)) {
                if (lastNonSeparator != '\u0000') {
                    formatted = this.getFormattedNumber(lastNonSeparator, hasCursor);
                    hasCursor = false;
                }
                lastNonSeparator = c;
            }
            if (i == curIndex) {
                hasCursor = true;
            }
            ++i;
        }
        if (lastNonSeparator != '\u0000') {
            formatted = this.getFormattedNumber(lastNonSeparator, hasCursor);
        }
        return formatted;
    }

    private final String getFormattedNumber(char lastNonSeparator, boolean hasCursor) {
        String string;
        if (hasCursor) {
            String string2 = this.mFormatter.inputDigitAndRememberPosition(lastNonSeparator);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"mFormatter.inputDigitAnd\u2026osition(lastNonSeparator)");
        } else {
            String string3 = this.mFormatter.inputDigit(lastNonSeparator);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"mFormatter.inputDigit(lastNonSeparator)");
        }
        return string;
    }

    private final void stopFormatting() {
        this.mStopFormatting = true;
        this.mFormatter.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasSeparator(CharSequence s, int start, int count) {
        int n = start;
        int n2 = start + count;
        while (n < n2) {
            void i;
            char c = s.charAt((int)i);
            if (!PhoneNumberUtils.isNonSeparator((char)c)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public PhoneNumberFormatter(@NotNull String countryCode) {
        Intrinsics.checkParameterIsNotNull((Object)countryCode, (String)"countryCode");
        AsYouTypeFormatter asYouTypeFormatter = PhoneNumberUtil.getInstance().getAsYouTypeFormatter(countryCode);
        Intrinsics.checkExpressionValueIsNotNull((Object)asYouTypeFormatter, (String)"PhoneNumberUtil.getInsta\u2026ypeFormatter(countryCode)");
        this.mFormatter = asYouTypeFormatter;
        this.countryCode = countryCode;
    }
}

