/*
 * Decompiled with CFR 0.152.
 */
package com.zarinpal.libs.views.utitlity;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.support.annotation.NonNull;
import com.zarinpal.libs.views.utitlity.DateConverter;

public class TextUtility {
    public static String divideBySpecificChar(@NonNull String text, @NonNull String divider, int interval) {
        StringBuilder result = new StringBuilder(text);
        int counter = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (i == 0 || i % interval != 0 || i >= text.length()) continue;
            result.insert(i + counter, divider);
            ++counter;
        }
        return result.toString();
    }

    public static String convertToPan(@NonNull String text) {
        if (text.isEmpty()) {
            return "";
        }
        text = text.replace("-", "");
        return TextUtility.divideBySpecificChar(text, "-", 4);
    }

    public static String convertToCurrency(@NonNull String text) {
        if (text.isEmpty() || text.length() <= 3) {
            return text;
        }
        text = text.replace(",", "");
        String reverse = new StringBuilder(text).reverse().toString();
        reverse = TextUtility.divideBySpecificChar(reverse, ",", 3);
        return new StringBuilder(reverse).reverse().toString();
    }

    public static String convertToJalaliDate(@NonNull String text) {
        if (text.isEmpty()) {
            return "";
        }
        try {
            String[] splitString = text.split("/");
            int year = Integer.parseInt(splitString[0]);
            int month = Integer.parseInt(splitString[1]);
            int day = Integer.parseInt(splitString[2]);
            return new DateConverter().setGregorianDate(year, month, day).getIranianDate();
        }
        catch (Exception e) {
            return text;
        }
    }

    public static String getRawValue(String value, String removeChar) {
        return value.replace(removeChar, "");
    }

    public static void copyTextIntoClipboard(Context context, String value, OnTextCopyListener listener) {
        try {
            ClipboardManager clipboardManager = (ClipboardManager)context.getSystemService("clipboard");
            clipboardManager.setPrimaryClip(ClipData.newPlainText((CharSequence)"copy", (CharSequence)value));
            if (listener != null) {
                listener.onTextCopy();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static long getCurrencyValue(String text) {
        String value = TextUtility.getRawValue(text, ",");
        return Long.parseLong(value.replaceAll("\\D+", ""));
    }

    public static interface OnTextCopyListener {
        public void onTextCopy();
    }
}

