/*
 * Decompiled with CFR 0.152.
 */
package com.zarinpal.libs.views;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatButton;
import android.util.AttributeSet;
import com.zarinpal.libs.views.R;
import com.zarinpal.libs.views.utitlity.ColorUtility;
import com.zarinpal.libs.views.utitlity.FontUtility;
import java.util.Arrays;

public class ZarinButton
extends AppCompatButton {
    private int padding;
    private int fontFace;
    private int rippleColor;
    private int firstColor;
    private int secondColor;
    private int pressColor;
    private int cornerRadius;

    public ZarinButton(Context context) {
        super(context);
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZarinButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.ZarinButton);
        try {
            this.padding = array.getDimensionPixelSize(R.styleable.ZarinButton_android_padding, 20);
            this.fontFace = array.getInt(R.styleable.ZarinButton_zp_fontFace, 0);
            this.rippleColor = array.getColor(R.styleable.ZarinButton_zp_rippleColor, ContextCompat.getColor((Context)context, (int)R.color.button_ripple));
            this.firstColor = array.getColor(R.styleable.ZarinButton_zp_firstColor, ContextCompat.getColor((Context)context, (int)R.color.button_default));
            this.secondColor = array.getColor(R.styleable.ZarinButton_zp_secondColor, ContextCompat.getColor((Context)context, (int)R.color.button_default));
            this.pressColor = array.getColor(R.styleable.ZarinButton_zp_pressColor, 0);
            this.cornerRadius = array.getInt(R.styleable.ZarinButton_zp_cornerRadius, 7);
        }
        finally {
            array.recycle();
        }
        this.initialize();
    }

    public ZarinButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize();
    }

    private void initialize() {
        this.setFontFace();
        this.setPadding(this.padding, this.padding, this.padding, this.padding);
        this.setBackgroundColor();
    }

    public void setBackgroundColors(int ... color2) {
        this.firstColor = color2[0];
        if (color2.length == 2) {
            this.secondColor = color2[1];
        }
        this.setBackgroundColor();
    }

    private void setFontFace() {
        String fontFamily = "sansLight.ttf";
        switch (this.fontFace) {
            case 1: {
                fontFamily = "sansULight.ttf";
                break;
            }
            case 2: {
                fontFamily = "sansBold.ttf";
                break;
            }
            case 3: {
                fontFamily = "ocra.ttf";
            }
        }
        this.setTypeface(FontUtility.getFont(this.getContext(), fontFamily));
    }

    private void setBackgroundColor() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.setRippleBackground();
            return;
        }
        this.setBackground();
    }

    @RequiresApi(api=21)
    private void setRippleBackground() {
        ColorStateList colors = new ColorStateList((int[][])new int[][]{new int[0]}, new int[]{this.rippleColor});
        GradientDrawable defaultBg = new GradientDrawable(GradientDrawable.Orientation.LEFT_RIGHT, new int[]{this.firstColor, this.secondColor == ContextCompat.getColor((Context)this.getContext(), (int)R.color.button_default) ? this.firstColor : this.secondColor});
        defaultBg.setCornerRadius((float)this.cornerRadius);
        float[] outerRadii = new float[8];
        Arrays.fill(outerRadii, (float)this.cornerRadius);
        RoundRectShape roundRectShape = new RoundRectShape(outerRadii, null, null);
        ShapeDrawable mask = new ShapeDrawable((Shape)roundRectShape);
        RippleDrawable rippleDrawable = new RippleDrawable(colors, (Drawable)defaultBg, (Drawable)mask);
        this.setBackground((Drawable)rippleDrawable);
    }

    private void setBackground() {
        this.pressColor = this.pressColor == 0 ? ColorUtility.darker(this.firstColor, 0.9f) : this.pressColor;
        StateListDrawable stateListDrawable = new StateListDrawable();
        GradientDrawable defaultBg = new GradientDrawable(GradientDrawable.Orientation.LEFT_RIGHT, new int[]{this.firstColor, this.secondColor == ContextCompat.getColor((Context)this.getContext(), (int)R.color.button_default) ? this.firstColor : this.secondColor});
        GradientDrawable pressBg = new GradientDrawable(GradientDrawable.Orientation.LEFT_RIGHT, new int[]{this.pressColor, this.pressColor});
        defaultBg.setCornerRadius((float)this.cornerRadius);
        pressBg.setCornerRadius((float)this.cornerRadius);
        stateListDrawable.addState(new int[]{16842919}, (Drawable)pressBg);
        stateListDrawable.addState(new int[0], (Drawable)defaultBg);
        this.setBackground((Drawable)stateListDrawable);
    }
}

