/*
 * Decompiled with CFR 0.152.
 */
package com.zarinpal.libs.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import com.zarinpal.libs.views.R;
import com.zarinpal.libs.views.param.ZarinTextViewFormat;
import com.zarinpal.libs.views.utitlity.FontUtility;
import com.zarinpal.libs.views.utitlity.TextUtility;

public class ZarinTextView
extends AppCompatTextView {
    private boolean useTextFormat = true;
    private boolean activeLongPressCopyText = false;
    private int fontFace;
    private int textFormat;

    public ZarinTextView(Context context) {
        super(context);
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZarinTextView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.ZarinTextView);
        try {
            this.fontFace = array.getInt(R.styleable.ZarinTextView_zp_fontFace, 0);
            this.textFormat = array.getInt(R.styleable.ZarinTextView_zp_textFormat, 0);
            this.activeLongPressCopyText = array.getBoolean(R.styleable.ZarinTextView_zp_longCopy, false);
        }
        finally {
            array.recycle();
        }
        this.initialize();
    }

    public ZarinTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize();
    }

    private void initialize() {
        this.setFontFace();
        this.setActiveLongPressCopyText(this.activeLongPressCopyText, null);
    }

    private void setFontFace() {
        String fontFamily = "sansLight.ttf";
        switch (this.fontFace) {
            case 1: {
                fontFamily = "sansULight.ttf";
                break;
            }
            case 2: {
                fontFamily = "sansBold.ttf";
                break;
            }
            case 3: {
                fontFamily = "ocra.ttf";
            }
        }
        this.setTypeface(FontUtility.getFont(this.getContext(), fontFamily));
    }

    public void setActiveLongPressCopyText(boolean state, final @Nullable TextUtility.OnTextCopyListener listener) {
        if (!state) {
            return;
        }
        if (this.getText().toString().isEmpty()) {
            return;
        }
        this.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                TextUtility.copyTextIntoClipboard(ZarinTextView.this.getContext(), ZarinTextView.this.getText().toString(), listener);
                return true;
            }
        });
    }

    public void addPrefix(String prefix) {
        String result = String.format("%s %s", this.getText().toString(), prefix);
        this.useTextFormat = false;
        this.setText(result);
    }

    public void addSuffix(String suffix) {
        String result = String.format("%s %s", suffix, this.getText().toString());
        this.useTextFormat = false;
        this.setText(result);
    }

    public long getCurrencyValue() {
        return TextUtility.getCurrencyValue(this.getText().toString());
    }

    public void setTextFormat(@ZarinTextViewFormat.TextViewFormat int textFormat) {
        this.textFormat = textFormat;
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        if (this.useTextFormat) {
            if (this.textFormat == 2) {
                text = TextUtility.convertToCurrency(text.toString());
            } else if (this.textFormat == 1) {
                text = TextUtility.convertToPan(text.toString());
            } else if (this.textFormat == 3) {
                text = TextUtility.convertToJalaliDate(text.toString());
            }
        }
        this.useTextFormat = true;
        super.setText(text, type);
    }
}

