/*
 * Decompiled with CFR 0.152.
 */
package com.zarinpal.libs.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.zarinpal.libs.views.R;
import com.zarinpal.libs.views.utitlity.FontUtility;
import com.zarinpal.libs.views.utitlity.UnitUtility;
import java.util.ArrayList;
import java.util.List;

public class SectionEditText
extends LinearLayout {
    private ViewGroup layoutRoot;
    private int itemCount;
    private int maxLen;
    private Integer itemWidth;
    private Integer itemHeight;
    private Integer itemMargin;
    private boolean hasPassword;
    private Drawable backgroundDrawable;
    private Integer textColor;
    private List<EditText> editTextList;

    public SectionEditText(Context context) {
        super(context);
    }

    public SectionEditText(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.SectionEditText);
        this.itemCount = typedArray.getInteger(R.styleable.SectionEditText_zp_pinCount, 4);
        this.itemHeight = typedArray.getDimensionPixelSize(R.styleable.SectionEditText_zp_heightItem, 30);
        this.itemWidth = typedArray.getDimensionPixelSize(R.styleable.SectionEditText_zp_widthItem, 20);
        this.itemMargin = typedArray.getDimensionPixelSize(R.styleable.SectionEditText_zp_marginItem, 2);
        this.maxLen = typedArray.getInt(R.styleable.SectionEditText_android_maxLength, 1);
        this.hasPassword = typedArray.getBoolean(R.styleable.SectionEditText_zp_hasPassword, false);
        this.backgroundDrawable = typedArray.getDrawable(R.styleable.SectionEditText_zp_backgroundDrawable);
        this.textColor = typedArray.getColor(R.styleable.SectionEditText_android_textColor, -16777216);
        typedArray.recycle();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.initializeView();
    }

    private void initializeView() {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.pin_view, (ViewGroup)this, true);
        this.layoutRoot = (ViewGroup)view.findViewById(R.id.layout_root);
        this.editTextList = new ArrayList<EditText>();
        this.addView();
    }

    private void addView() {
        int i = 0;
        while (i < this.itemCount) {
            final int index = i++;
            RelativeLayout relativeLayout = new RelativeLayout(this.getContext());
            final EditText edt = new EditText(this.getContext());
            final ImageView imageView = new ImageView(this.getContext());
            edt.setTypeface(FontUtility.getFont(this.getContext(), "sansBold.ttf"));
            this.setAttrEditText(edt, index);
            this.handledBackground(edt, relativeLayout, imageView);
            relativeLayout.addView((View)edt, (ViewGroup.LayoutParams)this.getParam());
            this.layoutRoot.addView((View)relativeLayout);
            this.editTextList.add(edt);
            edt.setOnFocusChangeListener(new View.OnFocusChangeListener(){

                public void onFocusChange(View view, boolean isFocused) {
                    if (SectionEditText.this.backgroundDrawable != null && isFocused) {
                        imageView.setVisibility(8);
                    } else if (edt.getText().toString().isEmpty()) {
                        imageView.setVisibility(0);
                    }
                }
            });
            edt.addTextChangedListener(new TextWatcher(){

                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                }

                public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                }

                public void afterTextChanged(Editable editable) {
                    SectionEditText.this.handledUserType(editable.toString(), index);
                }
            });
        }
    }

    private void handledUserType(String value, int index) {
        if (value.isEmpty() && index != 0) {
            this.editTextList.get(index - 1).requestFocus();
        }
        if (value.isEmpty() || value.length() < this.maxLen) {
            return;
        }
        if (!value.isEmpty() && this.editTextList.size() > index + 1) {
            this.editTextList.get(index + 1).requestFocus();
        }
    }

    private LinearLayout.LayoutParams getParam() {
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams((int)UnitUtility.dpToPx(this.getContext(), this.itemWidth), (int)UnitUtility.dpToPx(this.getContext(), this.itemHeight));
        params.setMargins(this.itemMargin.intValue(), this.itemMargin.intValue(), this.itemMargin.intValue(), this.itemMargin.intValue());
        return params;
    }

    private void handledBackground(EditText edt, RelativeLayout layout2, ImageView img) {
        if (this.backgroundDrawable != null) {
            img.setBackground(this.backgroundDrawable);
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams((int)UnitUtility.dpToPx(this.getContext(), 30), (int)UnitUtility.dpToPx(this.getContext(), 2));
            params.addRule(13, -1);
            img.setLayoutParams((ViewGroup.LayoutParams)params);
            edt.setBackground(null);
            layout2.addView((View)img);
        }
    }

    private void setAttrEditText(EditText edt, int index) {
        InputFilter[] filters = new InputFilter[]{new InputFilter.LengthFilter(this.maxLen)};
        edt.setFilters(filters);
        edt.setGravity(17);
        edt.setTextColor(this.textColor.intValue());
        if (this.hasPassword) {
            edt.setInputType(129);
        } else {
            edt.setInputType(2);
        }
        if (index == this.itemCount) {
            edt.setImeOptions(6);
        } else {
            edt.setImeOptions(5);
        }
    }

    public String getText() {
        String str = "";
        if (this.editTextList == null || this.editTextList.size() <= 0) {
            return str;
        }
        for (EditText edt : this.editTextList) {
            str = str + edt.getText();
        }
        return str;
    }
}

