/*
 * Decompiled with CFR 0.152.
 */
package com.zarinpal.libs.views;

import android.content.Context;
import android.graphics.Bitmap;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;

class BlurBuilder {
    private static final float BITMAP_SCALE = 0.7f;
    private static final float BLUR_RADIUS = 25.0f;

    BlurBuilder() {
    }

    public static Bitmap blur(Context ctx, Bitmap image) {
        int width = Math.round((float)image.getWidth() * 0.7f);
        int height = Math.round((float)image.getHeight() * 0.7f);
        Bitmap inputBitmap = Bitmap.createScaledBitmap((Bitmap)image, (int)width, (int)height, (boolean)false);
        Bitmap outputBitmap = Bitmap.createBitmap((Bitmap)inputBitmap);
        RenderScript rs = RenderScript.create((Context)ctx);
        ScriptIntrinsicBlur theIntrinsic = ScriptIntrinsicBlur.create((RenderScript)rs, (Element)Element.U8_4((RenderScript)rs));
        Allocation tmpIn = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)inputBitmap);
        Allocation tmpOut = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)outputBitmap);
        theIntrinsic.setRadius(25.0f);
        theIntrinsic.setInput(tmpIn);
        theIntrinsic.forEach(tmpOut);
        tmpOut.copyTo(outputBitmap);
        return outputBitmap;
    }
}

