/*
 * Decompiled with CFR 0.152.
 */
package com.zarinpal.libs.httpRequest;

import android.content.Context;
import com.android.volley.AuthFailureError;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.NoConnectionError;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.TimeoutError;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.toolbox.StringRequest;
import com.zarinpal.libs.httpRequest.HttpQueue;
import com.zarinpal.libs.httpRequest.OnCallbackRequestListener;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpRequest
implements Response.Listener,
Response.ErrorListener {
    private Request request;
    private Context context;
    private String url;
    private int timeOut;
    private int requestMethod;
    private byte requestType;
    private JSONObject jsonObject;
    private OnCallbackRequestListener listener;
    private SSLSocketFactory setSSLSocketFactory;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> params = new HashMap<String, String>();
    public static final int GET = 0;
    public static final int POST = 1;
    public static final int PUT = 2;
    public static final int DELETE = 3;
    public static final byte RAW = 0;
    public static final byte FROM_DATA = 1;
    private static final int TIMEOUT_DEFAULT_VALUE = 20000;
    public static final int INTERNET_CONNECTION_ERROR = -100;
    public static final int TIMEOUT_ERROR = -101;
    public static final int UNKNOWN_ERROR = -102;
    private static final String DEFAULT_ERROR = "Http error incorrect.";

    public HttpRequest(Context context) {
        this.context = context;
    }

    public HttpRequest setURL(String url) {
        this.url = url;
        return this;
    }

    public HttpRequest setParams(Map<String, String> params) {
        this.params = params;
        return this;
    }

    public HttpRequest setJson(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
        return this;
    }

    public HttpRequest setHeaders(HashMap<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public HttpRequest setRequestType(byte RequestType) {
        this.requestType = RequestType;
        return this;
    }

    public HttpRequest setRequestMethod(int method) {
        this.requestMethod = method;
        return this;
    }

    public HttpRequest setTimeOut(int timeOut) {
        this.timeOut = timeOut * 1000;
        return this;
    }

    public HttpRequest setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.setSSLSocketFactory = sslSocketFactory;
        return this;
    }

    public void onResponse(Object response) {
        if (!this.isJsonValid(response)) {
            this.listener.onSuccessResponse(null, response.toString());
            return;
        }
        try {
            this.listener.onSuccessResponse(new JSONObject(response.toString()), response.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void onErrorResponse(VolleyError error) {
        if (error instanceof NoConnectionError) {
            this.listener.onFailureResponse(-100, DEFAULT_ERROR);
            this.listener.onFailureConnection();
            return;
        }
        if (error instanceof TimeoutError) {
            this.listener.onFailureResponse(-101, DEFAULT_ERROR);
            this.listener.onTimeout();
            return;
        }
        if (error.networkResponse == null) {
            this.listener.onFailureResponse(-102, DEFAULT_ERROR);
            this.listener.onUnknownError();
            return;
        }
        this.listener.onFailureResponse(error.networkResponse.statusCode, new String(error.networkResponse.data));
    }

    public void get(OnCallbackRequestListener listener) {
        this.listener = listener;
        this.request = this.requestType == 1 ? new StringRequest(this.requestMethod, this.url, this, this){

            protected Map<String, String> getParams() throws AuthFailureError {
                return HttpRequest.this.params;
            }

            public Map<String, String> getHeaders() throws AuthFailureError {
                return HttpRequest.this.headers;
            }
        } : new JsonObjectRequest(this.requestMethod, this.url, this.jsonObject == null ? new JSONObject(this.params) : this.jsonObject, this, this){

            public Map<String, String> getHeaders() throws AuthFailureError {
                return HttpRequest.this.headers;
            }
        };
        this.request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(this.timeOut == 0 ? 20000 : this.timeOut, 0, 1.0f));
        HttpQueue.getInstance(this.context, this.setSSLSocketFactory).addToRequest(this.request);
    }

    private boolean isJsonValid(Object object) {
        try {
            new JSONObject(object.toString());
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

