/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yubico.internal.util.CollectionUtil;
import com.yubico.webauthn.attestation.Attestation;
import com.yubico.webauthn.data.AttestationType;
import com.yubico.webauthn.data.AuthenticatorRegistrationExtensionOutputs;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.ClientRegistrationExtensionOutputs;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public final class RegistrationResult {
    @NonNull
    private final PublicKeyCredentialDescriptor keyId;
    private final boolean attestationTrusted;
    @NonNull
    private final AttestationType attestationType;
    @NonNull
    private final ByteArray publicKeyCose;
    private final long signatureCount;
    @NonNull
    private final List<String> warnings;
    private final Attestation attestationMetadata;
    private final ClientRegistrationExtensionOutputs clientExtensionOutputs;
    private final AuthenticatorRegistrationExtensionOutputs authenticatorExtensionOutputs;

    @JsonCreator
    private RegistrationResult(@JsonProperty(value="keyId") @NonNull PublicKeyCredentialDescriptor keyId, @JsonProperty(value="attestationTrusted") boolean attestationTrusted, @JsonProperty(value="attestationType") @NonNull AttestationType attestationType, @JsonProperty(value="publicKeyCose") @NonNull ByteArray publicKeyCose, @JsonProperty(value="signatureCount") Long signatureCount, @JsonProperty(value="warnings") @NonNull List<String> warnings, @JsonProperty(value="attestationMetadata") Attestation attestationMetadata, @JsonProperty(value="clientExtensionOutputs") ClientRegistrationExtensionOutputs clientExtensionOutputs, @JsonProperty(value="authenticatorExtensionOutputs") AuthenticatorRegistrationExtensionOutputs authenticatorExtensionOutputs) {
        if (keyId == null) {
            throw new NullPointerException("keyId is marked non-null but is null");
        }
        if (attestationType == null) {
            throw new NullPointerException("attestationType is marked non-null but is null");
        }
        if (publicKeyCose == null) {
            throw new NullPointerException("publicKeyCose is marked non-null but is null");
        }
        if (warnings == null) {
            throw new NullPointerException("warnings is marked non-null but is null");
        }
        this.keyId = keyId;
        this.attestationTrusted = attestationTrusted;
        this.attestationType = attestationType;
        this.publicKeyCose = publicKeyCose;
        this.signatureCount = signatureCount == null ? 0L : signatureCount;
        this.warnings = CollectionUtil.immutableList(warnings);
        this.attestationMetadata = attestationMetadata;
        this.clientExtensionOutputs = clientExtensionOutputs == null || clientExtensionOutputs.getExtensionIds().isEmpty() ? null : clientExtensionOutputs;
        this.authenticatorExtensionOutputs = authenticatorExtensionOutputs;
    }

    public Optional<Attestation> getAttestationMetadata() {
        return Optional.ofNullable(this.attestationMetadata);
    }

    public Optional<ClientRegistrationExtensionOutputs> getClientExtensionOutputs() {
        return Optional.ofNullable(this.clientExtensionOutputs);
    }

    public Optional<AuthenticatorRegistrationExtensionOutputs> getAuthenticatorExtensionOutputs() {
        return Optional.ofNullable(this.authenticatorExtensionOutputs);
    }

    public Optional<Boolean> isDiscoverable() {
        return this.getClientExtensionOutputs().flatMap(outputs -> outputs.getCredProps()).flatMap(credProps -> credProps.getRk());
    }

    static RegistrationResultBuilder.MandatoryStages builder() {
        return new RegistrationResultBuilder.MandatoryStages();
    }

    @Generated
    private static List<String> $default$warnings() {
        return Collections.emptyList();
    }

    @Generated
    public RegistrationResultBuilder toBuilder() {
        return new RegistrationResultBuilder().keyId(this.keyId).attestationTrusted(this.attestationTrusted).attestationType(this.attestationType).publicKeyCose(this.publicKeyCose).signatureCount(this.signatureCount).warnings(this.warnings).attestationMetadata(this.attestationMetadata).clientExtensionOutputs(this.clientExtensionOutputs).authenticatorExtensionOutputs(this.authenticatorExtensionOutputs);
    }

    @NonNull
    @Generated
    public PublicKeyCredentialDescriptor getKeyId() {
        return this.keyId;
    }

    @Generated
    public boolean isAttestationTrusted() {
        return this.attestationTrusted;
    }

    @NonNull
    @Generated
    public AttestationType getAttestationType() {
        return this.attestationType;
    }

    @NonNull
    @Generated
    public ByteArray getPublicKeyCose() {
        return this.publicKeyCose;
    }

    @Generated
    public long getSignatureCount() {
        return this.signatureCount;
    }

    @NonNull
    @Generated
    public List<String> getWarnings() {
        return this.warnings;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegistrationResult)) {
            return false;
        }
        RegistrationResult other = (RegistrationResult)o;
        if (this.isAttestationTrusted() != other.isAttestationTrusted()) {
            return false;
        }
        if (this.getSignatureCount() != other.getSignatureCount()) {
            return false;
        }
        PublicKeyCredentialDescriptor this$keyId = this.getKeyId();
        PublicKeyCredentialDescriptor other$keyId = other.getKeyId();
        if (this$keyId == null ? other$keyId != null : !((Object)this$keyId).equals(other$keyId)) {
            return false;
        }
        AttestationType this$attestationType = this.getAttestationType();
        AttestationType other$attestationType = other.getAttestationType();
        if (this$attestationType == null ? other$attestationType != null : !((Object)((Object)this$attestationType)).equals((Object)other$attestationType)) {
            return false;
        }
        ByteArray this$publicKeyCose = this.getPublicKeyCose();
        ByteArray other$publicKeyCose = other.getPublicKeyCose();
        if (this$publicKeyCose == null ? other$publicKeyCose != null : !((Object)this$publicKeyCose).equals(other$publicKeyCose)) {
            return false;
        }
        List<String> this$warnings = this.getWarnings();
        List<String> other$warnings = other.getWarnings();
        if (this$warnings == null ? other$warnings != null : !((Object)this$warnings).equals(other$warnings)) {
            return false;
        }
        Optional<Attestation> this$attestationMetadata = this.getAttestationMetadata();
        Optional<Attestation> other$attestationMetadata = other.getAttestationMetadata();
        if (this$attestationMetadata == null ? other$attestationMetadata != null : !((Object)this$attestationMetadata).equals(other$attestationMetadata)) {
            return false;
        }
        Optional<ClientRegistrationExtensionOutputs> this$clientExtensionOutputs = this.getClientExtensionOutputs();
        Optional<ClientRegistrationExtensionOutputs> other$clientExtensionOutputs = other.getClientExtensionOutputs();
        if (this$clientExtensionOutputs == null ? other$clientExtensionOutputs != null : !((Object)this$clientExtensionOutputs).equals(other$clientExtensionOutputs)) {
            return false;
        }
        Optional<AuthenticatorRegistrationExtensionOutputs> this$authenticatorExtensionOutputs = this.getAuthenticatorExtensionOutputs();
        Optional<AuthenticatorRegistrationExtensionOutputs> other$authenticatorExtensionOutputs = other.getAuthenticatorExtensionOutputs();
        return !(this$authenticatorExtensionOutputs == null ? other$authenticatorExtensionOutputs != null : !((Object)this$authenticatorExtensionOutputs).equals(other$authenticatorExtensionOutputs));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAttestationTrusted() ? 79 : 97);
        long $signatureCount = this.getSignatureCount();
        result = result * 59 + (int)($signatureCount >>> 32 ^ $signatureCount);
        PublicKeyCredentialDescriptor $keyId = this.getKeyId();
        result = result * 59 + ($keyId == null ? 43 : ((Object)$keyId).hashCode());
        AttestationType $attestationType = this.getAttestationType();
        result = result * 59 + ($attestationType == null ? 43 : ((Object)((Object)$attestationType)).hashCode());
        ByteArray $publicKeyCose = this.getPublicKeyCose();
        result = result * 59 + ($publicKeyCose == null ? 43 : ((Object)$publicKeyCose).hashCode());
        List<String> $warnings = this.getWarnings();
        result = result * 59 + ($warnings == null ? 43 : ((Object)$warnings).hashCode());
        Optional<Attestation> $attestationMetadata = this.getAttestationMetadata();
        result = result * 59 + ($attestationMetadata == null ? 43 : ((Object)$attestationMetadata).hashCode());
        Optional<ClientRegistrationExtensionOutputs> $clientExtensionOutputs = this.getClientExtensionOutputs();
        result = result * 59 + ($clientExtensionOutputs == null ? 43 : ((Object)$clientExtensionOutputs).hashCode());
        Optional<AuthenticatorRegistrationExtensionOutputs> $authenticatorExtensionOutputs = this.getAuthenticatorExtensionOutputs();
        result = result * 59 + ($authenticatorExtensionOutputs == null ? 43 : ((Object)$authenticatorExtensionOutputs).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RegistrationResult(keyId=" + this.getKeyId() + ", attestationTrusted=" + this.isAttestationTrusted() + ", attestationType=" + (Object)((Object)this.getAttestationType()) + ", publicKeyCose=" + this.getPublicKeyCose() + ", signatureCount=" + this.getSignatureCount() + ", warnings=" + this.getWarnings() + ", attestationMetadata=" + this.getAttestationMetadata() + ", clientExtensionOutputs=" + this.getClientExtensionOutputs() + ", authenticatorExtensionOutputs=" + this.getAuthenticatorExtensionOutputs() + ")";
    }

    static class RegistrationResultBuilder {
        @Generated
        private PublicKeyCredentialDescriptor keyId;
        @Generated
        private boolean attestationTrusted;
        @Generated
        private AttestationType attestationType;
        @Generated
        private ByteArray publicKeyCose;
        @Generated
        private long signatureCount;
        @Generated
        private boolean warnings$set;
        @Generated
        private List<String> warnings$value;
        @Generated
        private Attestation attestationMetadata;
        @Generated
        private ClientRegistrationExtensionOutputs clientExtensionOutputs;
        @Generated
        private AuthenticatorRegistrationExtensionOutputs authenticatorExtensionOutputs;

        RegistrationResultBuilder attestationMetadata(@NonNull Optional<Attestation> attestationMetadata) {
            if (attestationMetadata == null) {
                throw new NullPointerException("attestationMetadata is marked non-null but is null");
            }
            this.attestationMetadata = attestationMetadata.orElse(null);
            return this;
        }

        private RegistrationResultBuilder attestationMetadata(Attestation attestationMetadata) {
            return this.attestationMetadata(Optional.ofNullable(attestationMetadata));
        }

        @Generated
        RegistrationResultBuilder() {
        }

        @Generated
        public RegistrationResultBuilder keyId(@NonNull PublicKeyCredentialDescriptor keyId) {
            if (keyId == null) {
                throw new NullPointerException("keyId is marked non-null but is null");
            }
            this.keyId = keyId;
            return this;
        }

        @Generated
        public RegistrationResultBuilder attestationTrusted(boolean attestationTrusted) {
            this.attestationTrusted = attestationTrusted;
            return this;
        }

        @Generated
        public RegistrationResultBuilder attestationType(@NonNull AttestationType attestationType) {
            if (attestationType == null) {
                throw new NullPointerException("attestationType is marked non-null but is null");
            }
            this.attestationType = attestationType;
            return this;
        }

        @Generated
        public RegistrationResultBuilder publicKeyCose(@NonNull ByteArray publicKeyCose) {
            if (publicKeyCose == null) {
                throw new NullPointerException("publicKeyCose is marked non-null but is null");
            }
            this.publicKeyCose = publicKeyCose;
            return this;
        }

        @Generated
        public RegistrationResultBuilder signatureCount(long signatureCount) {
            this.signatureCount = signatureCount;
            return this;
        }

        @Generated
        public RegistrationResultBuilder warnings(@NonNull List<String> warnings) {
            if (warnings == null) {
                throw new NullPointerException("warnings is marked non-null but is null");
            }
            this.warnings$value = warnings;
            this.warnings$set = true;
            return this;
        }

        @Generated
        public RegistrationResultBuilder clientExtensionOutputs(ClientRegistrationExtensionOutputs clientExtensionOutputs) {
            this.clientExtensionOutputs = clientExtensionOutputs;
            return this;
        }

        @Generated
        public RegistrationResultBuilder authenticatorExtensionOutputs(AuthenticatorRegistrationExtensionOutputs authenticatorExtensionOutputs) {
            this.authenticatorExtensionOutputs = authenticatorExtensionOutputs;
            return this;
        }

        @Generated
        public RegistrationResult build() {
            List warnings$value = this.warnings$value;
            if (!this.warnings$set) {
                warnings$value = RegistrationResult.$default$warnings();
            }
            return new RegistrationResult(this.keyId, this.attestationTrusted, this.attestationType, this.publicKeyCose, this.signatureCount, warnings$value, this.attestationMetadata, this.clientExtensionOutputs, this.authenticatorExtensionOutputs);
        }

        @Generated
        public String toString() {
            return "RegistrationResult.RegistrationResultBuilder(keyId=" + this.keyId + ", attestationTrusted=" + this.attestationTrusted + ", attestationType=" + (Object)((Object)this.attestationType) + ", publicKeyCose=" + this.publicKeyCose + ", signatureCount=" + this.signatureCount + ", warnings$value=" + this.warnings$value + ", attestationMetadata=" + this.attestationMetadata + ", clientExtensionOutputs=" + this.clientExtensionOutputs + ", authenticatorExtensionOutputs=" + this.authenticatorExtensionOutputs + ")";
        }

        static class MandatoryStages {
            private RegistrationResultBuilder builder = new RegistrationResultBuilder();

            MandatoryStages() {
            }

            Step2 keyId(PublicKeyCredentialDescriptor keyId) {
                this.builder.keyId(keyId);
                return new Step2();
            }

            class Step7 {
                Step7() {
                }

                RegistrationResultBuilder authenticatorExtensionOutputs(AuthenticatorRegistrationExtensionOutputs authenticatorExtensionOutputs) {
                    return MandatoryStages.this.builder.authenticatorExtensionOutputs(authenticatorExtensionOutputs);
                }
            }

            class Step6 {
                Step6() {
                }

                Step7 clientExtensionOutputs(ClientRegistrationExtensionOutputs clientExtensionOutputs) {
                    MandatoryStages.this.builder.clientExtensionOutputs(clientExtensionOutputs);
                    return new Step7();
                }
            }

            class Step5 {
                Step5() {
                }

                Step6 signatureCount(long signatureCount) {
                    MandatoryStages.this.builder.signatureCount(signatureCount);
                    return new Step6();
                }
            }

            class Step4 {
                Step4() {
                }

                Step5 publicKeyCose(ByteArray publicKeyCose) {
                    MandatoryStages.this.builder.publicKeyCose(publicKeyCose);
                    return new Step5();
                }
            }

            class Step3 {
                Step3() {
                }

                Step4 attestationType(AttestationType attestationType) {
                    MandatoryStages.this.builder.attestationType(attestationType);
                    return new Step4();
                }
            }

            class Step2 {
                Step2() {
                }

                Step3 attestationTrusted(boolean attestationTrusted) {
                    MandatoryStages.this.builder.attestationTrusted(attestationTrusted);
                    return new Step3();
                }
            }
        }
    }
}

