package com.yodo1ads.adapter.interstitial;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;

import com.mintegral.msdk.out.MTGRewardVideoHandler;
import com.mintegral.msdk.out.RewardVideoListener;
import com.yodo1.advert.interstitial.AdInterstitialAdapterBase;
import com.yodo1.advert.interstitial.Yodo1InterstitialCallback;
import com.yodo1.advert.interstitial.Yodo1InterstitialReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1ads.plugin.mobvista.AdConfigMobvista;
import com.yodo1ads.plugin.mobvista.AdvertCoreMobVista;


/**
 * Created by yodo1 on 2017/9/27.
 */
public class AdvertAdaptermintegral extends AdInterstitialAdapterBase {
    private boolean isLoded = false;
    private Yodo1InterstitialCallback intersititalCallback; //插屏回调
    private Yodo1InterstitialReloadCallback callback;
    private MTGRewardVideoHandler mMvRewardVideoHandler;

    @Override
    public void showIntersititalAdvert(Activity activity, Yodo1InterstitialCallback callback) {
        this.intersititalCallback = callback;
        YLog.i("Mobvista showIntersititalAdvert");
        if (mMvRewardVideoHandler !=null && mMvRewardVideoHandler.isReady()) {
            mMvRewardVideoHandler.show(AdConfigMobvista.InterstitialId);
        } else {
            callback.onAdError(Yodo1InterstitialCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }
        isLoded = false;
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1InterstitialReloadCallback callback) {
        YLog.i("Mobvista reloadInterstitialAdvert");
        this.callback = callback;
        if (mMvRewardVideoHandler != null){
            mMvRewardVideoHandler.load();
        }
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return isLoded;
    }

    public void validateAdsAdapter(Activity activity) {
        AdvertCoreMobVista.getInstance().validateAdsAdapter(activity);

    }

    @Override
    public String getAdvertCode() {
        return AdConfigMobvista.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {
        AdvertCoreMobVista.getInstance().init(activity);

        AdConfigMobvista.InterstitialUnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd,
                AdConfigMobvista.CHANNEL_CODE, AdConfigMobvista.KEY_MOBVISTA_InterstitialUnitId);
        AdConfigMobvista.InterstitialId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd,
                AdConfigMobvista.CHANNEL_CODE, AdConfigMobvista.KEY_MOBVISTA_InterstitialId);

        if (TextUtils.isEmpty(AdConfigMobvista.InterstitialUnitId) && TextUtils.isEmpty(AdConfigMobvista.InterstitialId)){
            YLog.e("Mobvista  RewardUnitId未获取到");
            return;
        }
        mMvRewardVideoHandler = new MTGRewardVideoHandler(activity, AdConfigMobvista.InterstitialUnitId);
        mMvRewardVideoHandler.setRewardVideoListener(new RewardVideoListener() {

            @Override
            public void onVideoLoadSuccess(String s) {
                YLog.d("Mobvista  onVideoLoadSuccess");
                isLoded = true;
                if(callback != null){
                    callback.onResult(Yodo1InterstitialReloadCallback.ADVERT_INTERSTITIAL_RELOAD_FINISH, getAdvertCode());
                }
            }

            @Override
            public void onVideoLoadFail(String s) {
                YLog.d("Mobvista  onVideoLoadFail ： " + s);
                if(callback != null){
                    callback.onResult(Yodo1InterstitialReloadCallback.ADVERT_INTERSTITIAL_RELOAD_FAILED, getAdvertCode());
                }
            }

            @Override
            public void onShowFail(String errorMsg) {
                YLog.d("Mobvista  onShowFail=" + errorMsg);
                if(intersititalCallback != null){
                    intersititalCallback.onAdError(Yodo1InterstitialCallback.ADVERT_EVENT_CLOSE, errorMsg, getAdvertCode());
                }
            }

            @Override
            public void onAdShow() {
                YLog.d("Mobvista  onAdShow");
                if(intersititalCallback != null){
                    intersititalCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
                }
            }

            @Override
            public void onAdClose(boolean isCompleteView, String RewardName, float RewardAmout) {
                YLog.d("Mobvista  reward info :" + "RewardName:  " + RewardName + "  RewardAmout: " + RewardAmout  + "  isCompleteView:   " + isCompleteView);

                if(intersititalCallback != null){
                    intersititalCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
                }
            }

            @Override
            public void onVideoAdClicked(String unitId) {
                YLog.d("Mobvista  onVideoAdClicked");
                if(intersititalCallback != null){
                    intersititalCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_CLICK, getAdvertCode());
                }
            }

        });
    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }
}
