package com.yodo1ads.adapter.banner;


import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;

import com.qq.e.ads.banner.ADSize;
import com.qq.e.ads.banner.AbstractBannerADListener;
import com.qq.e.ads.banner.BannerView;
import com.qq.e.comm.util.AdError;
import com.yodo1.advert.banner.AdBannerAdapterBase;
import com.yodo1.advert.banner.Yodo1BannerAlign;
import com.yodo1.advert.banner.Yodo1BannerCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1ads.plugin.gdt.AdConfigGdt;
import com.yodo1ads.plugin.gdt.AdvertCoreGdt;
import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.sdk.kit.YLog;


/**
 * Created by yodo1 on 2016/4/7.
 */
public class AdvertAdaptergdt extends AdBannerAdapterBase {
    private int align = Yodo1BannerAlign.BannerAlignHorizontalCenter | Yodo1BannerAlign.BannerAlignBottom;
    private Yodo1BannerCallback callback;
    private int refreshTime = 15;
    private boolean isLoaded = false;
    private BannerView bv;
    @Override
    public String getAdvertCode() {
        return AdConfigGdt.CHANNEL_CODE;
    }

    @Override
    public void validateAdsAdapter(Activity activity) {
        AdvertCoreGdt.getInstance().validateAdsAdapter(activity);
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {
        AdConfigGdt.BANNERL_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd, AdConfigGdt.CHANNEL_CODE
                , AdConfigGdt.KEY_Gdt_BANNER_ID);
        AdConfigGdt.APP_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd, AdConfigGdt.CHANNEL_CODE
                , AdConfigGdt.KEY_Gdt_APP_ID);
        refreshTime = Integer.valueOf(Yodo1OnlineConfig.getInstance().getConfigParam("Platform_AdsRefreshInterval","15"));

        if (TextUtils.isEmpty(AdConfigGdt.APP_ID) && TextUtils.isEmpty(AdConfigGdt.BANNERL_ID)){
            YLog.i("Gdt  SDKKey  is null");
            return;
        }

        initBanner(activity);
    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }



    @Override
    public void showBanner(Activity activity,final Yodo1BannerCallback callback) {
        this.callback = callback;

        if (TextUtils.isEmpty(AdConfigGdt.APP_ID) && TextUtils.isEmpty(AdConfigGdt.BANNERL_ID)){
            YLog.e("Gdt  SDKKey  is null");
            callback.onAdError(Yodo1BannerCallback.ADVERT_ERROR_COMMON, "SDK_KEY null",getAdvertCode());
            return;
        }

        if (isLoaded){
            YLog.d("Gdt showBanner ");
            Yodo1BannerAlign.setYodo1BannerLayout(activity,bv,align);
            callback.onEvent(Yodo1BannerCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
        } else {
            callback.onAdError(Yodo1BannerCallback.ADVERT_ERROR_COMMON, "onAdFailedToLoad",getAdvertCode());
        }

    }

    @Override
    public void removeBanner(Activity activity) {
        isLoaded = false;


        if (bv != null) {
            Yodo1BannerAlign.removeYodo1BannerLayout(activity,bv);
            bv.destroy();
            bv = null;
        }
    }

    @Override
    public void hideBanner(Activity activity) {
        YLog.d("Gdt hideBanner ");
        if (bv !=null){
            Yodo1BannerAlign.removeYodo1BannerLayout(activity,bv);
        }
    }

    @Override
    public void setBannerAlign(Activity activity, int align) {
        this.align = align;

        YLog.d("Gdt setBannerAlign");
    }

    @Override
    public boolean hasLoadBanner() {
        return isLoaded;
    }


    private void initBanner(Activity activity){
        //初始化banner(传入的参数依次为 context，sdkKey，广告尺寸,常量false)

        if (bv == null){
            bv = new BannerView(activity, ADSize.BANNER, AdConfigGdt.APP_ID, AdConfigGdt.BANNERL_ID);
            // 注意：如果开发者的banner不是始终展示在屏幕中的话，请关闭自动刷新，否则将导致曝光率过低。
            // 并且应该自行处理：当banner广告区域出现在屏幕后，再手动loadAD。
            bv.setRefresh(refreshTime);
            bv.setADListener(new AbstractBannerADListener() {

                @Override
                public void onNoAD(AdError error) {
                    YLog.d("Gdt onNoAD ");
                    isLoaded = false;
                }

                @Override
                public void onADReceiv() {
                    YLog.d("Gdt onADReceiv ");
                    isLoaded = true;
                }
            });

            bv.loadAD();
        }

    }
}
