package com.yodo1.plugin.dmp.yodo1.utils;

import android.content.Context;
import android.content.pm.PackageManager;

/**
 * 权限检查及动态权限申请
 * Created by zhuxc on 2017/8/9.
 */
public class Yodo1PermissonUtils {
    public static final String READ_PHONE_STATE = "android.permission.READ_PHONE_STATE";

    /**
     * 判断应用是否有某个权限
     * @param ctx
     * @param permission
     * @return 是否含有此权限
     */
    public static boolean hasPermission(Context ctx, String permission){

        PackageManager pm = ctx.getPackageManager();
        boolean bl = (PackageManager.PERMISSION_GRANTED ==
                pm.checkPermission(permission, Yodo1CommonUtil.getPageInfo(ctx)));

        return bl;
    }
}
