/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.legacy;

import java.io.IOException;
import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.reficio.ws.SoapBuilderException;
import org.reficio.ws.common.ResourceUtils;
import org.reficio.ws.legacy.AbstractSoapVersion;
import org.reficio.ws.legacy.XmlUtils;
import org.w3.x2003.x05.soapEnvelope.EnvelopeDocument;
import org.w3.x2003.x05.soapEnvelope.FaultDocument;

class SoapVersion12
extends AbstractSoapVersion {
    private static final QName envelopeQName = new QName("http://www.w3.org/2003/05/soap-envelope", "Envelope");
    private static final QName bodyQName = new QName("http://www.w3.org/2003/05/soap-envelope", "Body");
    private static final QName faultQName = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
    private static final QName headerQName = new QName("http://www.w3.org/2003/05/soap-envelope", "Header");
    public static final SoapVersion12 instance = new SoapVersion12();
    private SchemaTypeLoader soapSchema;
    private XmlObject soapSchemaXml;
    private XmlObject soapEncodingXml;

    private SoapVersion12() {
        try {
            URL soapSchemaXmlResource = ResourceUtils.getResourceWithAbsolutePackagePath(this.getClass(), (String)"/xsds/", (String)"soapEnvelope12.xsd");
            this.soapSchemaXml = XmlUtils.createXmlObject(soapSchemaXmlResource);
            this.soapSchema = XmlBeans.loadXsd((XmlObject[])new XmlObject[]{this.soapSchemaXml});
            URL soapEncodingXmlResource = ResourceUtils.getResourceWithAbsolutePackagePath(this.getClass(), (String)"/xsds/", (String)"soapEncoding12.xsd");
            this.soapEncodingXml = XmlUtils.createXmlObject(soapEncodingXmlResource);
        }
        catch (XmlException e) {
            throw new SoapBuilderException((Throwable)e);
        }
    }

    @Override
    public String getEncodingNamespace() {
        return "http://www.w3.org/2003/05/soap-encoding";
    }

    @Override
    public XmlObject getSoapEncodingSchema() throws XmlException, IOException {
        return this.soapEncodingXml;
    }

    @Override
    public XmlObject getSoapEnvelopeSchema() throws XmlException, IOException {
        return this.soapSchemaXml;
    }

    @Override
    public String getEnvelopeNamespace() {
        return "http://www.w3.org/2003/05/soap-envelope";
    }

    @Override
    public SchemaType getEnvelopeType() {
        return EnvelopeDocument.type;
    }

    public String toString() {
        return "SOAP 1.2";
    }

    public static String quote(String str) {
        if (str == null) {
            return str;
        }
        if (str.length() < 2 || !str.startsWith("\"") || !str.endsWith("\"")) {
            str = "\"" + str + "\"";
        }
        return str;
    }

    @Override
    public String getContentTypeHttpHeader(String encoding, String soapAction) {
        String result = this.getContentType();
        if (encoding != null && encoding.trim().length() > 0) {
            result = result + ";charset=" + encoding;
        }
        if (StringUtils.isNotBlank((CharSequence)soapAction)) {
            result = result + ";action=" + SoapVersion12.quote(soapAction);
        }
        return result;
    }

    @Override
    public String getSoapActionHeader(String soapAction) {
        return null;
    }

    @Override
    public String getContentType() {
        return "application/soap+xml";
    }

    @Override
    public QName getBodyQName() {
        return bodyQName;
    }

    @Override
    public QName getEnvelopeQName() {
        return envelopeQName;
    }

    @Override
    public QName getHeaderQName() {
        return headerQName;
    }

    @Override
    protected SchemaTypeLoader getSoapEnvelopeSchemaLoader() {
        return this.soapSchema;
    }

    public static QName getFaultQName() {
        return faultQName;
    }

    @Override
    public SchemaType getFaultType() {
        return FaultDocument.type;
    }

    @Override
    public String getName() {
        return "SOAP 1.2";
    }

    @Override
    public String getFaultDetailNamespace() {
        return this.getEnvelopeNamespace();
    }
}

