/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.legacy;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.SimpleValue;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.reficio.ws.SoapBuilderException;
import org.reficio.ws.common.ResourceUtils;
import org.reficio.ws.legacy.SchemaLoader;
import org.reficio.ws.legacy.XmlUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class SchemaUtils {
    private static final Logger log = Logger.getLogger(SchemaUtils.class);
    private static Map<String, XmlObject> defaultSchemas = new HashMap<String, XmlObject>();
    public static final boolean STRICT_SCHEMA_TYPES = false;

    SchemaUtils() {
    }

    public static URL loadResoruce(String resourceName) {
        return ResourceUtils.getResourceWithAbsolutePackagePath(SchemaUtils.class, (String)"/xsds/", (String)resourceName);
    }

    public static void initDefaultSchemas() {
        try {
            defaultSchemas.clear();
            SchemaUtils.loadDefaultSchema(SchemaUtils.loadResoruce("xop.xsd"));
            SchemaUtils.loadDefaultSchema(SchemaUtils.loadResoruce("XMLSchema.xsd"));
            SchemaUtils.loadDefaultSchema(SchemaUtils.loadResoruce("xml.xsd"));
            SchemaUtils.loadDefaultSchema(SchemaUtils.loadResoruce("swaref.xsd"));
            SchemaUtils.loadDefaultSchema(SchemaUtils.loadResoruce("xmime200505.xsd"));
            SchemaUtils.loadDefaultSchema(SchemaUtils.loadResoruce("xmime200411.xsd"));
            SchemaUtils.loadDefaultSchema(SchemaUtils.loadResoruce("soapEnvelope.xsd"));
            SchemaUtils.loadDefaultSchema(SchemaUtils.loadResoruce("soapEncoding.xsd"));
            SchemaUtils.loadDefaultSchema(SchemaUtils.loadResoruce("soapEnvelope12.xsd"));
            SchemaUtils.loadDefaultSchema(SchemaUtils.loadResoruce("soapEncoding12.xsd"));
        }
        catch (Exception e) {
            throw new SoapBuilderException((Throwable)e);
        }
    }

    private static void loadDefaultSchema(URL url) throws Exception {
        XmlObject xmlObject = XmlUtils.createXmlObject(url);
        if (!((Document)xmlObject.getDomNode()).getDocumentElement().getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
            return;
        }
        String targetNamespace = SchemaUtils.getTargetNamespace(xmlObject);
        if (defaultSchemas.containsKey(targetNamespace)) {
            log.warn((Object)("Overriding schema for targetNamespace " + targetNamespace));
        }
        defaultSchemas.put(targetNamespace, xmlObject);
        log.debug((Object)("Added default schema from " + url.getPath() + " with targetNamespace " + targetNamespace));
    }

    public static SchemaTypeSystem loadSchemaTypes(String wsdlUrl, SchemaLoader loader) {
        try {
            log.debug((Object)("Loading schema types from [" + wsdlUrl + "]"));
            ArrayList<XmlObject> schemas = new ArrayList<XmlObject>(SchemaUtils.getSchemas(wsdlUrl, loader).values());
            return SchemaUtils.buildSchemaTypes(schemas);
        }
        catch (Exception e) {
            throw new SoapBuilderException((Throwable)e);
        }
    }

    public static SchemaTypeSystem buildSchemaTypes(List<XmlObject> schemas) {
        XmlOptions options = new XmlOptions();
        options.setCompileNoValidation();
        options.setCompileNoPvrRule();
        options.setCompileDownloadUrls();
        options.setCompileNoUpaRule();
        options.setValidateTreatLaxAsSkip();
        for (int c = 0; c < schemas.size(); ++c) {
            XmlObject xmlObject = schemas.get(c);
            if (xmlObject != null && ((Document)xmlObject.getDomNode()).getDocumentElement().getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) continue;
            schemas.remove(c);
            --c;
        }
        boolean strictSchemaTypes = false;
        if (!strictSchemaTypes) {
            HashSet<String> mdefNamespaces = new HashSet<String>();
            for (XmlObject xObj : schemas) {
                mdefNamespaces.add(SchemaUtils.getTargetNamespace(xObj));
            }
            options.setCompileMdefNamespaces(mdefNamespaces);
        }
        ArrayList errorList = new ArrayList();
        options.setErrorListener(errorList);
        XmlCursor cursor = null;
        try {
            SchemaTypeSystem sts;
            for (int c = 0; c < schemas.size(); ++c) {
                XmlObject s = schemas.get(c);
                HashMap map = new HashMap();
                cursor = s.newCursor();
                cursor.toStartDoc();
                if (SchemaUtils.toNextContainer(cursor)) {
                    cursor.getAllNamespaces(map);
                } else {
                    log.warn((Object)("Can not get namespaces for " + s));
                }
                String tns = SchemaUtils.getTargetNamespace(s);
                if (strictSchemaTypes && defaultSchemas.containsKey(tns)) {
                    schemas.remove(c);
                    --c;
                } else {
                    SchemaUtils.removeImports(s);
                }
                cursor.dispose();
                cursor = null;
            }
            schemas.addAll(defaultSchemas.values());
            SchemaTypeSystem schemaTypeSystem = sts = XmlBeans.compileXsd((XmlObject[])schemas.toArray(new XmlObject[schemas.size()]), (SchemaTypeLoader)XmlBeans.getBuiltinTypeSystem(), (XmlOptions)options);
            return schemaTypeSystem;
        }
        catch (Exception e) {
            throw new SoapBuilderException((Throwable)e);
        }
        finally {
            for (int c = 0; c < errorList.size(); ++c) {
                log.warn((Object)("Error: " + errorList.get(c)));
            }
            if (cursor != null) {
                cursor.dispose();
            }
        }
    }

    public static boolean toNextContainer(XmlCursor cursor) {
        while (!cursor.isContainer() && !cursor.isEnddoc()) {
            cursor.toNextToken();
        }
        return cursor.isContainer();
    }

    public static String getTargetNamespace(XmlObject s) {
        return ((Document)s.getDomNode()).getDocumentElement().getAttribute("targetNamespace");
    }

    public static Map<String, XmlObject> getSchemas(String wsdlUrl, SchemaLoader loader) {
        HashMap<String, XmlObject> result = new HashMap<String, XmlObject>();
        SchemaUtils.getSchemas(wsdlUrl, result, loader, null);
        return result;
    }

    public static void getSchemas(String wsdlUrl, Map<String, XmlObject> existing, SchemaLoader loader, String tns) {
        if (existing.containsKey(wsdlUrl)) {
            return;
        }
        log.debug((Object)("Getting schema " + wsdlUrl));
        ArrayList errorList = new ArrayList();
        HashMap<String, XmlObject> result = new HashMap<String, XmlObject>();
        boolean common = false;
        try {
            String location;
            int i;
            XmlObject[] schemas;
            XmlOptions options = new XmlOptions();
            options.setCompileNoValidation();
            options.setSaveUseOpenFrag();
            options.setErrorListener(errorList);
            options.setSaveSyntheticDocumentElement(new QName("http://www.w3.org/2001/XMLSchema", "schema"));
            XmlObject xmlObject = loader.loadXmlObject(wsdlUrl, options);
            if (xmlObject == null) {
                throw new Exception("Failed to load schema from [" + wsdlUrl + "]");
            }
            Document dom = (Document)xmlObject.getDomNode();
            Element domNode = dom.getDocumentElement();
            if (domNode.getLocalName().equals("schema") && "http://www.w3.org/2001/XMLSchema".equals(domNode.getNamespaceURI())) {
                if (tns != null) {
                    Node item;
                    int c;
                    Element elm = domNode;
                    if (!elm.hasAttribute("targetNamespace")) {
                        common = true;
                        elm.setAttribute("targetNamespace", tns);
                    }
                    NamedNodeMap attributes = elm.getAttributes();
                    for (c = 0; !(c >= attributes.getLength() || (item = attributes.item(c)).getNodeName().equals("xmlns") || item.getNodeValue().equals(tns) && item.getNodeName().startsWith("xmlns")); ++c) {
                    }
                    if (c == attributes.getLength()) {
                        elm.setAttribute("xmlns", tns);
                    }
                }
                if (common && !existing.containsKey(wsdlUrl + "@" + tns)) {
                    result.put(wsdlUrl + "@" + tns, xmlObject);
                } else {
                    result.put(wsdlUrl, xmlObject);
                }
            } else {
                existing.put(wsdlUrl, null);
                schemas = xmlObject.selectPath("declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:schema");
                for (int i2 = 0; i2 < schemas.length; ++i2) {
                    XmlCursor xmlCursor = schemas[i2].newCursor();
                    String xmlText = xmlCursor.getObject().xmlText(options);
                    schemas[i2] = XmlUtils.createXmlObject(xmlText, options);
                    schemas[i2].documentProperties().setSourceName(wsdlUrl);
                    result.put(wsdlUrl + "@" + (i2 + 1), schemas[i2]);
                }
                XmlObject[] wsdlImports = xmlObject.selectPath("declare namespace s='http://schemas.xmlsoap.org/wsdl/' .//s:import/@location");
                for (int i3 = 0; i3 < wsdlImports.length; ++i3) {
                    String location2 = ((SimpleValue)wsdlImports[i3]).getStringValue();
                    if (location2 == null) continue;
                    if (!location2.startsWith("file:") && location2.indexOf("://") == -1) {
                        location2 = SchemaUtils.joinRelativeUrl(wsdlUrl, location2);
                    }
                    SchemaUtils.getSchemas(location2, existing, loader, null);
                }
                XmlObject[] wadl10Imports = xmlObject.selectPath("declare namespace s='http://research.sun.com/wadl/2006/10' .//s:grammars/s:include/@href");
                for (int i4 = 0; i4 < wadl10Imports.length; ++i4) {
                    String location3 = ((SimpleValue)wadl10Imports[i4]).getStringValue();
                    if (location3 == null) continue;
                    if (!location3.startsWith("file:") && location3.indexOf("://") == -1) {
                        location3 = SchemaUtils.joinRelativeUrl(wsdlUrl, location3);
                    }
                    SchemaUtils.getSchemas(location3, existing, loader, null);
                }
                XmlObject[] wadlImports = xmlObject.selectPath("declare namespace s='http://wadl.dev.java.net/2009/02' .//s:grammars/s:include/@href");
                for (i = 0; i < wadlImports.length; ++i) {
                    location = ((SimpleValue)wadlImports[i]).getStringValue();
                    if (location == null) continue;
                    if (!location.startsWith("file:") && location.indexOf("://") == -1) {
                        location = SchemaUtils.joinRelativeUrl(wsdlUrl, location);
                    }
                    SchemaUtils.getSchemas(location, existing, loader, null);
                }
            }
            existing.putAll(result);
            schemas = result.values().toArray(new XmlObject[result.size()]);
            for (int c = 0; c < schemas.length; ++c) {
                xmlObject = schemas[c];
                XmlObject[] schemaImports = xmlObject.selectPath("declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:import/@schemaLocation");
                for (int i5 = 0; i5 < schemaImports.length; ++i5) {
                    String location4 = ((SimpleValue)schemaImports[i5]).getStringValue();
                    Element elm = ((Attr)schemaImports[i5].getDomNode()).getOwnerElement();
                    if (location4 == null || defaultSchemas.containsKey(elm.getAttribute("namespace"))) continue;
                    if (!location4.startsWith("file:") && location4.indexOf("://") == -1) {
                        location4 = SchemaUtils.joinRelativeUrl(wsdlUrl, location4);
                    }
                    SchemaUtils.getSchemas(location4, existing, loader, null);
                }
                XmlObject[] schemaIncludes = xmlObject.selectPath("declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:include/@schemaLocation");
                for (i = 0; i < schemaIncludes.length; ++i) {
                    location = ((SimpleValue)schemaIncludes[i]).getStringValue();
                    if (location == null) continue;
                    String targetNS = SchemaUtils.getTargetNamespace(xmlObject);
                    if (!location.startsWith("file:") && location.indexOf("://") == -1) {
                        location = SchemaUtils.joinRelativeUrl(wsdlUrl, location);
                    }
                    SchemaUtils.getSchemas(location, existing, loader, targetNS);
                }
            }
        }
        catch (Exception e) {
            throw new SoapBuilderException((Throwable)e);
        }
    }

    public static void getDefinitionParts(String origWsdlUrl, Map<String, XmlObject> existing, SchemaLoader loader) throws Exception {
        String wsdlUrl = origWsdlUrl;
        if (existing.containsKey(wsdlUrl)) {
            return;
        }
        XmlObject xmlObject = loader.loadXmlObject(wsdlUrl, null);
        existing.put(wsdlUrl, xmlObject);
        SchemaUtils.selectDefinitionParts(wsdlUrl, existing, loader, xmlObject, "declare namespace s='http://schemas.xmlsoap.org/wsdl/' .//s:import/@location");
        SchemaUtils.selectDefinitionParts(wsdlUrl, existing, loader, xmlObject, "declare namespace s='http://research.sun.com/wadl/2006/10' .//s:grammars/s:include/@href");
        SchemaUtils.selectDefinitionParts(wsdlUrl, existing, loader, xmlObject, "declare namespace s='http://wadl.dev.java.net/2009/02' .//s:grammars/s:include/@href");
        SchemaUtils.selectDefinitionParts(wsdlUrl, existing, loader, xmlObject, "declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:import/@schemaLocation");
        SchemaUtils.selectDefinitionParts(wsdlUrl, existing, loader, xmlObject, "declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:include/@schemaLocation");
    }

    public static String joinRelativeUrl(String baseUrl, String url) {
        int ix2;
        boolean isUsedInUnix;
        if (baseUrl.indexOf(63) > 0) {
            baseUrl = baseUrl.substring(0, baseUrl.indexOf(63));
        }
        boolean isWindowsUrl = baseUrl.indexOf(92) >= 0;
        boolean bl = isUsedInUnix = File.separatorChar == '/';
        if (isUsedInUnix && isWindowsUrl) {
            baseUrl = baseUrl.replace('\\', '/');
            url = url.replace('\\', '/');
        }
        boolean isFile = baseUrl.startsWith("file:");
        int ix = baseUrl.lastIndexOf(92);
        if (ix == -1) {
            ix = baseUrl.lastIndexOf(47);
        }
        if (url.startsWith("/") && !isFile) {
            ix = baseUrl.indexOf("/", baseUrl.indexOf("//") + 2);
            return baseUrl.substring(0, ix) + url;
        }
        while (url.startsWith(".\\") || url.startsWith("./")) {
            url = url.substring(2);
        }
        while (url.startsWith("../") || url.startsWith("..\\")) {
            ix2 = baseUrl.lastIndexOf(92, ix - 1);
            if (ix2 == -1) {
                ix2 = baseUrl.lastIndexOf(47, ix - 1);
            }
            if (ix2 == -1) break;
            baseUrl = baseUrl.substring(0, ix2 + 1);
            ix = ix2;
            url = url.substring(3);
        }
        while (url.indexOf("/./") != -1 || url.indexOf("\\.\\") != -1) {
            ix2 = url.indexOf("/./");
            if (ix2 == -1) {
                ix2 = url.indexOf("\\.\\");
            }
            url = url.substring(0, ix2) + url.substring(ix2 + 2);
        }
        while (url.indexOf("/../") != -1 || url.indexOf("\\..\\") != -1) {
            ix2 = -1;
            int ix3 = url.indexOf("/../");
            if (ix3 == -1) {
                ix3 = url.indexOf("\\..\\");
                ix2 = url.lastIndexOf(92, ix3 - 1);
            } else {
                ix2 = url.lastIndexOf(47, ix3 - 1);
            }
            if (ix2 == -1) break;
            url = url.substring(0, ix2) + url.substring(ix3 + 3);
        }
        String result = baseUrl.substring(0, ix + 1) + url;
        if (isFile) {
            result = result.replace('/', File.separatorChar);
        }
        return result;
    }

    private static void selectDefinitionParts(String wsdlUrl, Map<String, XmlObject> existing, SchemaLoader loader, XmlObject xmlObject, String path) throws Exception {
        XmlObject[] wsdlImports = xmlObject.selectPath(path);
        for (int i = 0; i < wsdlImports.length; ++i) {
            String location = ((SimpleValue)wsdlImports[i]).getStringValue();
            if (location == null) continue;
            if (StringUtils.isNotBlank((CharSequence)location)) {
                if (!location.startsWith("file:") && location.indexOf("://") == -1) {
                    location = SchemaUtils.joinRelativeUrl(wsdlUrl, location);
                }
                SchemaUtils.getDefinitionParts(location, existing, loader);
                continue;
            }
            Element domNode = ((Attr)wsdlImports[i].getDomNode()).getOwnerElement();
            domNode.getParentNode().removeChild(domNode);
        }
    }

    public static Collection<String> extractNamespaces(SchemaTypeSystem schemaTypes, boolean removeDefault) {
        HashSet<String> namespaces = new HashSet<String>();
        SchemaType[] globalTypes = schemaTypes.globalTypes();
        for (int c = 0; c < globalTypes.length; ++c) {
            namespaces.add(globalTypes[c].getName().getNamespaceURI());
        }
        if (removeDefault) {
            namespaces.removeAll(defaultSchemas.keySet());
            namespaces.remove("http://schemas.xmlsoap.org/soap/envelope/");
            namespaces.remove("http://schemas.xmlsoap.org/soap/encoding/");
        }
        return namespaces;
    }

    public static void removeImports(XmlObject xmlObject) throws XmlException {
        XmlObject[] imports = xmlObject.selectPath("declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:import");
        for (int c = 0; c < imports.length; ++c) {
            XmlCursor cursor = imports[c].newCursor();
            cursor.removeXml();
            cursor.dispose();
        }
        XmlObject[] includes = xmlObject.selectPath("declare namespace s='http://www.w3.org/2001/XMLSchema' .//s:include");
        for (int c = 0; c < includes.length; ++c) {
            XmlCursor cursor = includes[c].newCursor();
            cursor.removeXml();
            cursor.dispose();
        }
    }

    static {
        SchemaUtils.initDefaultSchemas();
    }
}

