/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.legacy;

import java.util.Collection;
import java.util.HashSet;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.reficio.ws.legacy.DefinitionLoader;
import org.reficio.ws.legacy.SchemaUtils;
import org.reficio.ws.legacy.UrlSchemaLoader;
import org.reficio.ws.legacy.WsdlUtils;

class SchemaDefinitionWrapper {
    private SchemaTypeSystem schemaTypes;
    private SchemaTypeLoader schemaTypeLoader;
    private Definition definition;

    public SchemaDefinitionWrapper(Definition definition, String schemaURL) {
        this.definition = definition;
        this.loadSchemaTypes(new UrlSchemaLoader(schemaURL));
    }

    public SchemaTypeLoader getSchemaTypeLoader() {
        return this.schemaTypeLoader;
    }

    public SchemaTypeSystem getSchemaTypeSystem() {
        return this.schemaTypes;
    }

    public boolean hasSchemaTypes() {
        return this.schemaTypes != null;
    }

    public Collection<String> getDefinedNamespaces() throws Exception {
        HashSet<String> namespaces = new HashSet<String>();
        SchemaTypeSystem schemaTypes = this.getSchemaTypeSystem();
        if (schemaTypes != null) {
            namespaces.addAll(SchemaUtils.extractNamespaces(this.getSchemaTypeSystem(), true));
        }
        namespaces.add(this.getTargetNamespace());
        return namespaces;
    }

    public String getTargetNamespace() {
        return WsdlUtils.getTargetNamespace(this.definition);
    }

    public SchemaType findType(QName typeName) {
        return this.getSchemaTypeLoader().findType(typeName);
    }

    public void loadSchemaTypes(DefinitionLoader loader) {
        this.schemaTypes = SchemaUtils.loadSchemaTypes(loader.getBaseURI(), loader);
        this.schemaTypeLoader = XmlBeans.typeLoaderUnion((SchemaTypeLoader[])new SchemaTypeLoader[]{this.schemaTypes, XmlBeans.getBuiltinTypeSystem()});
    }
}

