/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.xpath;

import com.ximpleware.NavException;
import com.ximpleware.NodeTest;
import com.ximpleware.VTDNav;
import com.ximpleware.xpath.Predicate;

public class Step {
    public int axis_type;
    public NodeTest nt;
    public Predicate p;
    public Predicate pt;
    public Step nextS;
    public Step prevS;
    public Object o;
    public boolean ft;
    public boolean hasPredicate;
    public boolean nt_eval;
    public boolean out_of_range;

    public Step() {
        this.nextS = this.prevS = (Step)null;
        this.pt = null;
        this.p = null;
        this.nt = null;
        this.ft = true;
        this.hasPredicate = false;
        this.nt_eval = false;
        this.out_of_range = false;
    }

    public final void reset(VTDNav vTDNav) {
        this.ft = true;
        if (this.hasPredicate) {
            this.resetP(vTDNav);
        }
    }

    public final void resetP(VTDNav vTDNav) {
        Predicate predicate = this.p;
        while (predicate != null) {
            predicate.reset(vTDNav);
            predicate = predicate.nextP;
        }
    }

    public final void setStep4Predicates() {
        Predicate predicate = this.p;
        while (predicate != null) {
            predicate.s = this;
            predicate = predicate.nextP;
        }
    }

    public final void resetP(VTDNav vTDNav, Predicate predicate) {
        Predicate predicate2 = this.p;
        while (predicate2 != predicate) {
            predicate2.reset(vTDNav);
            predicate2 = predicate2.nextP;
        }
    }

    public final void adjust(int n) {
        Predicate predicate = this.p;
        while (predicate != null) {
            predicate.adjust(n);
            predicate = predicate.nextP;
        }
    }

    public final NodeTest getNodeTest() {
        return this.nt;
    }

    public final Step getNextStep() {
        return this.nextS;
    }

    public final void setNextStep(Step step) {
        this.nextS = step;
    }

    public final boolean get_ft() {
        return this.ft;
    }

    public final void set_ft(boolean bl) {
        this.ft = bl;
    }

    public final Step getPrevStep() {
        return this.prevS;
    }

    public final void setPrevStep(Step step) {
        this.prevS = step;
    }

    public final void setNodeTest(NodeTest nodeTest) {
        this.nt = nodeTest;
        if (this.axis_type == 1 && nodeTest.testType == 0) {
            this.axis_type = 0;
        } else if (this.axis_type == 7 && nodeTest.testType == 0) {
            this.axis_type = 3;
        } else if (this.axis_type == 6 && nodeTest.testType == 0) {
            this.axis_type = 2;
        } else if (this.axis_type == 9 && nodeTest.testType == 0) {
            this.axis_type = 5;
        } else if (this.axis_type == 8 && nodeTest.testType == 0) {
            this.axis_type = 4;
        } else if (this.axis_type == 14 && nodeTest.testType == 0) {
            this.axis_type = 15;
        } else if (this.axis_type == 16 && nodeTest.testType == 0) {
            this.axis_type = 17;
        }
        if (nodeTest.testType == 1 || nodeTest.testType == 0 && nodeTest.nodeName.equals("*")) {
            this.nt_eval = true;
        }
    }

    public final void setPredicate(Predicate predicate) {
        if (this.p == null) {
            this.p = this.pt = predicate;
        } else {
            this.pt = this.pt.nextP = predicate;
        }
        this.setStep4Predicates();
        if (predicate != null) {
            this.hasPredicate = true;
        }
    }

    public final boolean eval(VTDNav vTDNav) throws NavException {
        return this.nt.eval(vTDNav) && (!this.hasPredicate || this.evalPredicates(vTDNav));
    }

    public final boolean eval2(VTDNav vTDNav) throws NavException {
        return this.nt.eval2(vTDNav) && (!this.hasPredicate || this.evalPredicates(vTDNav));
    }

    public final boolean eval(VTDNav vTDNav, Predicate predicate) throws NavException {
        return this.nt.eval(vTDNav) && this.evalPredicates(vTDNav, predicate);
    }

    public final boolean eval2(VTDNav vTDNav, Predicate predicate) throws NavException {
        return this.nt.eval2(vTDNav) && this.evalPredicates(vTDNav, predicate);
    }

    public final boolean evalPredicates(VTDNav vTDNav) throws NavException {
        Predicate predicate = this.p;
        while (predicate != null) {
            if (!predicate.eval(vTDNav)) {
                return false;
            }
            predicate = predicate.nextP;
        }
        return true;
    }

    public final boolean evalPredicates(VTDNav vTDNav, Predicate predicate) throws NavException {
        Predicate predicate2 = this.p;
        while (predicate2 != predicate) {
            if (!predicate2.eval(vTDNav)) {
                return false;
            }
            predicate2 = predicate2.nextP;
        }
        return true;
    }

    public final void setAxisType(int n) {
        this.axis_type = n;
    }

    public final String toString() {
        String string = this.p == null ? this.axisName(this.axis_type) + this.nt : this.axisName(this.axis_type) + this.nt + " " + this.p;
        if (this.nextS == null) {
            return string;
        }
        return string + "/" + this.nextS.toString();
    }

    public final String axisName(int n) {
        switch (n) {
            case 0: {
                return "child0::";
            }
            case 1: {
                return "child::";
            }
            case 2: {
                return "descendant-or-self0::";
            }
            case 3: {
                return "descendant0::";
            }
            case 4: {
                return "preceding0::";
            }
            case 5: {
                return "following0::";
            }
            case 6: {
                return "descendant-or-self::";
            }
            case 7: {
                return "descendant::";
            }
            case 8: {
                return "preceding::";
            }
            case 9: {
                return "following::";
            }
            case 10: {
                return "parent::";
            }
            case 11: {
                return "ancestor::";
            }
            case 12: {
                return "ancestor-or-self::";
            }
            case 13: {
                return "self::";
            }
            case 14: {
                return "following-sibling::";
            }
            case 15: {
                return "following-sibling0::";
            }
            case 16: {
                return "preceding-sibling::";
            }
            case 17: {
                return "preceding-sibling0::";
            }
            case 18: {
                return "attribute::";
            }
        }
        return "namespace::";
    }
}

