/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware;

import com.ximpleware.FastIntBuffer;
import com.ximpleware.FastLongBuffer;
import com.ximpleware.FixedIntBuffer;
import com.ximpleware.FixedLongBuffer;
import com.ximpleware.IndexReadException;
import com.ximpleware.IndexWriteException;
import com.ximpleware.VTDGen;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

class IndexHandler {
    public static final int OFFSET_ADJUSTMENT = 32;

    IndexHandler() {
    }

    public static void writeIndex_L3(byte by, int n, boolean bl, boolean bl2, int n2, int n3, int n4, byte[] byArray, int n5, int n6, FastLongBuffer fastLongBuffer, FastLongBuffer fastLongBuffer2, FastLongBuffer fastLongBuffer3, FastIntBuffer fastIntBuffer, OutputStream outputStream) throws IndexWriteException, IOException {
        int n7;
        if (byArray == null || n6 <= 0 || fastLongBuffer == null || fastLongBuffer2 == null || fastLongBuffer3 == null || fastIntBuffer == null || n3 != 3) {
            throw new IndexWriteException("Invalid VTD index ");
        }
        if (fastLongBuffer.size() == 0) {
            throw new IndexWriteException("VTDBuffer can't be zero length");
        }
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        byte[] byArray2 = new byte[]{by, (byte)n, (byte)(bl ? 224 : 160), (byte)n2};
        dataOutputStream.write(byArray2);
        byArray2[0] = 0;
        byArray2[1] = 4;
        byArray2[2] = (byte)((n4 & 0xFF00) >> 8);
        byArray2[3] = (byte)(n4 & 0xFF);
        dataOutputStream.write(byArray2);
        byArray2[3] = 0;
        byArray2[2] = 0;
        byArray2[1] = 0;
        dataOutputStream.write(byArray2);
        dataOutputStream.write(byArray2);
        dataOutputStream.write(byArray2);
        dataOutputStream.write(byArray2);
        dataOutputStream.writeLong(n6);
        dataOutputStream.write(byArray, n5, n6);
        if ((n6 & 7) != 0) {
            for (int i = ((n6 >> 3) + 1 << 3) - n6; i > 0; --i) {
                dataOutputStream.write(0);
            }
        }
        dataOutputStream.writeLong(fastLongBuffer.size);
        if (n5 == 0) {
            for (n7 = 0; n7 < fastLongBuffer.size; ++n7) {
                dataOutputStream.writeLong(fastLongBuffer.longAt(n7));
            }
        } else {
            for (n7 = 0; n7 < fastLongBuffer.size; ++n7) {
                dataOutputStream.writeLong(IndexHandler.adjust(fastLongBuffer.longAt(n7), -n5));
            }
        }
        dataOutputStream.writeLong(fastLongBuffer2.size);
        for (n7 = 0; n7 < fastLongBuffer2.size; ++n7) {
            dataOutputStream.writeLong(fastLongBuffer2.longAt(n7));
        }
        dataOutputStream.writeLong(fastLongBuffer3.size);
        for (n7 = 0; n7 < fastLongBuffer3.size; ++n7) {
            dataOutputStream.writeLong(fastLongBuffer3.longAt(n7));
        }
        dataOutputStream.writeLong(fastIntBuffer.size);
        for (n7 = 0; n7 < fastIntBuffer.size; ++n7) {
            dataOutputStream.writeInt(fastIntBuffer.intAt(n7));
        }
        if ((fastIntBuffer.size & 1) != 0) {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.close();
    }

    public static void writeIndex_L5(byte by, int n, boolean bl, boolean bl2, int n2, int n3, int n4, byte[] byArray, int n5, int n6, FastLongBuffer fastLongBuffer, FastLongBuffer fastLongBuffer2, FastLongBuffer fastLongBuffer3, FastLongBuffer fastLongBuffer4, FastLongBuffer fastLongBuffer5, FastIntBuffer fastIntBuffer, OutputStream outputStream) throws IndexWriteException, IOException {
        int n7;
        if (byArray == null || n6 <= 0 || fastLongBuffer == null || fastLongBuffer2 == null || fastLongBuffer3 == null || fastLongBuffer4 == null || fastLongBuffer5 == null || fastIntBuffer == null || n3 != 5) {
            throw new IndexWriteException("Invalid VTD index ");
        }
        if (fastLongBuffer.size == 0) {
            throw new IndexWriteException("VTDBuffer can't be zero length");
        }
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        byte[] byArray2 = new byte[]{by, (byte)n, (byte)(bl ? 224 : 160), (byte)n2};
        dataOutputStream.write(byArray2);
        byArray2[0] = 0;
        byArray2[1] = 6;
        byArray2[2] = (byte)((n4 & 0xFF00) >> 8);
        byArray2[3] = (byte)(n4 & 0xFF);
        dataOutputStream.write(byArray2);
        byArray2[3] = 0;
        byArray2[2] = 0;
        byArray2[1] = 0;
        dataOutputStream.write(byArray2);
        dataOutputStream.write(byArray2);
        dataOutputStream.write(byArray2);
        dataOutputStream.write(byArray2);
        dataOutputStream.writeLong(n6);
        dataOutputStream.write(byArray, n5, n6);
        if ((n6 & 7) != 0) {
            for (int i = ((n6 >> 3) + 1 << 3) - n6; i > 0; --i) {
                dataOutputStream.write(0);
            }
        }
        dataOutputStream.writeLong(fastLongBuffer.size);
        if (n5 == 0) {
            for (n7 = 0; n7 < fastLongBuffer.size; ++n7) {
                dataOutputStream.writeLong(fastLongBuffer.longAt(n7));
            }
        } else {
            for (n7 = 0; n7 < fastLongBuffer.size; ++n7) {
                dataOutputStream.writeLong(IndexHandler.adjust(fastLongBuffer.longAt(n7), -n5));
            }
        }
        dataOutputStream.writeLong(fastLongBuffer2.size);
        for (n7 = 0; n7 < fastLongBuffer2.size; ++n7) {
            dataOutputStream.writeLong(fastLongBuffer2.longAt(n7));
        }
        dataOutputStream.writeLong(fastLongBuffer3.size);
        for (n7 = 0; n7 < fastLongBuffer3.size; ++n7) {
            dataOutputStream.writeLong(fastLongBuffer3.longAt(n7));
        }
        dataOutputStream.writeLong(fastLongBuffer4.size);
        for (n7 = 0; n7 < fastLongBuffer4.size; ++n7) {
            dataOutputStream.writeLong(fastLongBuffer4.longAt(n7));
        }
        dataOutputStream.writeLong(fastLongBuffer5.size);
        for (n7 = 0; n7 < fastLongBuffer5.size; ++n7) {
            dataOutputStream.writeLong(fastLongBuffer5.longAt(n7));
        }
        dataOutputStream.writeLong(fastIntBuffer.size);
        for (n7 = 0; n7 < fastIntBuffer.size; ++n7) {
            dataOutputStream.writeInt(fastIntBuffer.intAt(n7));
        }
        if ((fastIntBuffer.size & 1) != 0) {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.close();
    }

    public static void writeSeparateIndex_L3(byte by, int n, boolean bl, boolean bl2, int n2, int n3, int n4, int n5, int n6, FastLongBuffer fastLongBuffer, FastLongBuffer fastLongBuffer2, FastLongBuffer fastLongBuffer3, FastIntBuffer fastIntBuffer, OutputStream outputStream) throws IndexWriteException, IOException {
        int n7;
        if (n6 <= 0 || fastLongBuffer == null || fastLongBuffer2 == null || fastLongBuffer3 == null || fastIntBuffer == null || n3 != 3) {
            throw new IndexWriteException("Invalid VTD index ");
        }
        if (fastLongBuffer.size == 0) {
            throw new IndexWriteException("VTDBuffer can't be zero length");
        }
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        byte[] byArray = new byte[]{by, (byte)n, (byte)(bl ? 224 : 160), (byte)n2};
        dataOutputStream.write(byArray);
        byArray[0] = 0;
        byArray[1] = 4;
        byArray[2] = (byte)((n4 & 0xFF00) >> 8);
        byArray[3] = (byte)(n4 & 0xFF);
        dataOutputStream.write(byArray);
        byArray[3] = 0;
        byArray[2] = 0;
        byArray[1] = 0;
        dataOutputStream.write(byArray);
        dataOutputStream.write(byArray);
        dataOutputStream.write(byArray);
        dataOutputStream.write(byArray);
        dataOutputStream.writeLong(n6);
        dataOutputStream.write(byArray);
        dataOutputStream.write(byArray);
        dataOutputStream.write(byArray);
        dataOutputStream.write(byArray);
        dataOutputStream.writeLong(fastLongBuffer.size);
        if (n5 == 0) {
            for (n7 = 0; n7 < fastLongBuffer.size; ++n7) {
                dataOutputStream.writeLong(fastLongBuffer.longAt(n7));
            }
        } else {
            for (n7 = 0; n7 < fastLongBuffer.size; ++n7) {
                dataOutputStream.writeLong(IndexHandler.adjust(fastLongBuffer.longAt(n7), -n5));
            }
        }
        dataOutputStream.writeLong(fastLongBuffer2.size);
        for (n7 = 0; n7 < fastLongBuffer2.size; ++n7) {
            dataOutputStream.writeLong(fastLongBuffer2.longAt(n7));
        }
        dataOutputStream.writeLong(fastLongBuffer3.size);
        for (n7 = 0; n7 < fastLongBuffer3.size(); ++n7) {
            dataOutputStream.writeLong(fastLongBuffer3.longAt(n7));
        }
        dataOutputStream.writeLong(fastIntBuffer.size);
        for (n7 = 0; n7 < fastIntBuffer.size; ++n7) {
            dataOutputStream.writeInt(fastIntBuffer.intAt(n7));
        }
        if ((fastIntBuffer.size & 1) != 0) {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.close();
    }

    public static void writeSeparateIndex_L5(byte by, int n, boolean bl, boolean bl2, int n2, int n3, int n4, int n5, int n6, FastLongBuffer fastLongBuffer, FastLongBuffer fastLongBuffer2, FastLongBuffer fastLongBuffer3, FastLongBuffer fastLongBuffer4, FastLongBuffer fastLongBuffer5, FastIntBuffer fastIntBuffer, OutputStream outputStream) throws IndexWriteException, IOException {
        int n7;
        if (n6 <= 0 || fastLongBuffer == null || fastLongBuffer2 == null || fastLongBuffer3 == null || fastLongBuffer4 == null || fastLongBuffer5 == null || fastIntBuffer == null || n3 != 5) {
            throw new IndexWriteException("Invalid VTD index ");
        }
        if (fastLongBuffer.size == 0) {
            throw new IndexWriteException("VTDBuffer can't be zero length");
        }
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        byte[] byArray = new byte[]{by, (byte)n, (byte)(bl ? 224 : 160), (byte)n2};
        dataOutputStream.write(byArray);
        byArray[0] = 0;
        byArray[1] = 6;
        byArray[2] = (byte)((n4 & 0xFF00) >> 8);
        byArray[3] = (byte)(n4 & 0xFF);
        dataOutputStream.write(byArray);
        byArray[3] = 0;
        byArray[2] = 0;
        byArray[1] = 0;
        dataOutputStream.write(byArray);
        dataOutputStream.write(byArray);
        dataOutputStream.write(byArray);
        dataOutputStream.write(byArray);
        dataOutputStream.writeLong(n6);
        dataOutputStream.write(byArray);
        dataOutputStream.write(byArray);
        dataOutputStream.write(byArray);
        dataOutputStream.write(byArray);
        dataOutputStream.writeLong(fastLongBuffer.size);
        if (n5 == 0) {
            for (n7 = 0; n7 < fastLongBuffer.size; ++n7) {
                dataOutputStream.writeLong(fastLongBuffer.longAt(n7));
            }
        } else {
            for (n7 = 0; n7 < fastLongBuffer.size; ++n7) {
                dataOutputStream.writeLong(IndexHandler.adjust(fastLongBuffer.longAt(n7), -n5));
            }
        }
        dataOutputStream.writeLong(fastLongBuffer2.size);
        for (n7 = 0; n7 < fastLongBuffer2.size; ++n7) {
            dataOutputStream.writeLong(fastLongBuffer2.longAt(n7));
        }
        dataOutputStream.writeLong(fastLongBuffer3.size);
        for (n7 = 0; n7 < fastLongBuffer3.size(); ++n7) {
            dataOutputStream.writeLong(fastLongBuffer3.longAt(n7));
        }
        dataOutputStream.writeLong(fastLongBuffer4.size);
        for (n7 = 0; n7 < fastLongBuffer4.size; ++n7) {
            dataOutputStream.writeLong(fastLongBuffer4.longAt(n7));
        }
        dataOutputStream.writeLong(fastLongBuffer5.size);
        for (n7 = 0; n7 < fastLongBuffer5.size; ++n7) {
            dataOutputStream.writeLong(fastLongBuffer5.longAt(n7));
        }
        dataOutputStream.writeLong(fastIntBuffer.size);
        for (n7 = 0; n7 < fastIntBuffer.size; ++n7) {
            dataOutputStream.writeInt(fastIntBuffer.intAt(n7));
        }
        if ((fastIntBuffer.size & 1) != 0) {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.close();
    }

    public static void readIndex(byte[] byArray, VTDGen vTDGen) throws IndexReadException {
        if (byArray == null || vTDGen == null) {
            throw new IllegalArgumentException("Invalid argument(s) for readIndex()");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byte by = byteBuffer.get();
        if (by != 1) {
            throw new IndexReadException("Invalid version number for readIndex()");
        }
        vTDGen.encoding = byteBuffer.get();
        int n = 32;
        if (vTDGen.encoding >= 63) {
            n = 16;
        }
        boolean bl = ((by = byteBuffer.get()) & 0x80) != 0;
        vTDGen.ns = (by & 0x40) != 0;
        boolean bl2 = (by & 0x20) != 0;
        if ((by & 0x1F) != 0) {
            throw new IndexReadException("Last 5 bits of the third byte should be zero");
        }
        vTDGen.VTDDepth = byteBuffer.get();
        int n2 = byteBuffer.get() << 8 | byteBuffer.get();
        if (n2 != 4 && n2 != 6) {
            throw new IndexReadException("LC levels must be at least 3");
        }
        vTDGen.shallowDepth = n2 == 4;
        vTDGen.rootIndex = byteBuffer.get() << 8 | byteBuffer.get();
        byteBuffer.getLong();
        byteBuffer.getLong();
        int n3 = 0;
        n3 = bl2 ? (int)byteBuffer.getLong() : (int)IndexHandler.reverseLong(byteBuffer.getLong());
        int n4 = 0;
        if ((n3 & 7) != 0) {
            n4 = ((n3 >> 3) + 1 << 3) - n3;
        }
        vTDGen.setDoc_BR(byArray, 32, n3);
        byteBuffer = ByteBuffer.wrap(byArray, 32 + n3 + n4, byArray.length - 32 - n3 - n4);
        if (bl2) {
            int n5;
            for (int i = (int)byteBuffer.getLong(); i > 0; --i) {
                vTDGen.VTDBuffer.append(IndexHandler.adjust(byteBuffer.getLong(), n));
            }
            for (int i = (int)byteBuffer.getLong(); i > 0; --i) {
                long l = byteBuffer.getLong();
                vTDGen.l1Buffer.append(l);
            }
            for (int i = (int)byteBuffer.getLong(); i > 0; --i) {
                vTDGen.l2Buffer.append(byteBuffer.getLong());
            }
            if (vTDGen.shallowDepth) {
                if (bl) {
                    for (n5 = (int)byteBuffer.getLong(); n5 > 0; --n5) {
                        vTDGen.l3Buffer.append(byteBuffer.getInt());
                    }
                } else {
                    while (n5 > 0) {
                        vTDGen.l3Buffer.append((int)(byteBuffer.getLong() >> 32));
                        --n5;
                    }
                }
            } else {
                int n6;
                while (n5 > 0) {
                    vTDGen._l3Buffer.append(byteBuffer.getLong());
                    --n5;
                }
                for (int i = (int)byteBuffer.getLong(); i > 0; --i) {
                    vTDGen._l4Buffer.append(byteBuffer.getLong());
                }
                if (bl) {
                    for (n6 = (int)byteBuffer.getLong(); n6 > 0; --n6) {
                        vTDGen._l5Buffer.append(byteBuffer.getInt());
                    }
                } else {
                    while (n6 > 0) {
                        vTDGen._l5Buffer.append((int)(byteBuffer.getLong() >> 32));
                        --n6;
                    }
                }
            }
        } else {
            int n7;
            for (int i = (int)IndexHandler.reverseLong(byteBuffer.getLong()); i > 0; --i) {
                vTDGen.VTDBuffer.append(IndexHandler.adjust(IndexHandler.reverseLong(byteBuffer.getLong()), n));
            }
            for (int i = (int)IndexHandler.reverseLong(byteBuffer.getLong()); i > 0; --i) {
                long l = IndexHandler.reverseLong(byteBuffer.getLong());
                vTDGen.l1Buffer.append(l);
            }
            for (int i = (int)IndexHandler.reverseLong(byteBuffer.getLong()); i > 0; --i) {
                long l = IndexHandler.reverseLong(byteBuffer.getLong());
                vTDGen.l2Buffer.append(l);
            }
            if (vTDGen.shallowDepth) {
                if (bl) {
                    for (n7 = (int)IndexHandler.reverseLong(byteBuffer.getLong()); n7 > 0; --n7) {
                        vTDGen.l3Buffer.append(IndexHandler.reverseInt(byteBuffer.getInt()));
                    }
                } else {
                    while (n7 > 0) {
                        vTDGen.l3Buffer.append(IndexHandler.reverseInt((int)(byteBuffer.getLong() >> 32)));
                        --n7;
                    }
                }
            } else {
                int n8;
                while (n7 > 0) {
                    vTDGen._l3Buffer.append(IndexHandler.reverseLong(byteBuffer.getLong()));
                    --n7;
                }
                for (int i = (int)IndexHandler.reverseLong(byteBuffer.getLong()); i > 0; --i) {
                    vTDGen._l4Buffer.append(IndexHandler.reverseLong(byteBuffer.getLong()));
                }
                if (bl) {
                    for (n8 = (int)IndexHandler.reverseLong(byteBuffer.getLong()); n8 > 0; --n8) {
                        vTDGen._l5Buffer.append(IndexHandler.reverseInt(byteBuffer.getInt()));
                    }
                } else {
                    while (n8 > 0) {
                        vTDGen._l5Buffer.append(IndexHandler.reverseInt((int)(byteBuffer.getLong() >> 32)));
                        --n8;
                    }
                }
            }
        }
    }

    public static void readIndex(InputStream inputStream, VTDGen vTDGen) throws IndexReadException, IOException {
        int n;
        if (inputStream == null || vTDGen == null) {
            throw new IndexReadException("Invalid argument(s) for readIndex()");
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte by = dataInputStream.readByte();
        if (by != 1) {
            throw new IndexReadException("Invalid version number for readIndex()");
        }
        vTDGen.encoding = dataInputStream.readByte();
        by = dataInputStream.readByte();
        boolean bl = (by & 0x80) != 0;
        vTDGen.ns = (by & 0x40) != 0;
        boolean bl2 = (by & 0x20) != 0;
        if ((by & 0x1F) != 0) {
            throw new IndexReadException("Last 5 bits of the third byte should be zero");
        }
        vTDGen.VTDDepth = dataInputStream.readByte();
        int n2 = dataInputStream.readByte() << 8 | dataInputStream.readByte();
        if (n2 != 4 && n2 != 6) {
            throw new IndexReadException("LC levels must be at least 3");
        }
        vTDGen.shallowDepth = n2 == 4;
        vTDGen.rootIndex = dataInputStream.readByte() << 8 | dataInputStream.readByte();
        dataInputStream.readLong();
        dataInputStream.readLong();
        int n3 = 0;
        n3 = bl2 ? (int)dataInputStream.readLong() : (int)IndexHandler.reverseLong(dataInputStream.readLong());
        byte[] byArray = new byte[n3];
        dataInputStream.readFully(byArray);
        if ((n3 & 7) != 0) {
            for (n = ((n3 >> 3) + 1 << 3) - n3; n > 0; --n) {
                dataInputStream.readByte();
            }
        }
        vTDGen.setDoc_loadIndex(byArray);
        if (bl2) {
            int n4;
            int n5;
            int n6;
            FixedLongBuffer fixedLongBuffer = new FixedLongBuffer(n);
            for (n = (int)dataInputStream.readLong(); n > 0; --n) {
                fixedLongBuffer.append(dataInputStream.readLong());
            }
            vTDGen.VTDBuffer = fixedLongBuffer;
            FixedLongBuffer fixedLongBuffer2 = new FixedLongBuffer(n6);
            for (n6 = (int)dataInputStream.readLong(); n6 > 0; --n6) {
                long l = dataInputStream.readLong();
                fixedLongBuffer2.append(l);
            }
            vTDGen.l1Buffer = fixedLongBuffer2;
            FixedLongBuffer fixedLongBuffer3 = new FixedLongBuffer(n5);
            for (n5 = (int)dataInputStream.readLong(); n5 > 0; --n5) {
                fixedLongBuffer3.append(dataInputStream.readLong());
            }
            vTDGen.l2Buffer = fixedLongBuffer3;
            if (vTDGen.shallowDepth) {
                FixedIntBuffer fixedIntBuffer = new FixedIntBuffer(n4);
                if (bl) {
                    for (n4 = (int)dataInputStream.readLong(); n4 > 0; --n4) {
                        fixedIntBuffer.append(dataInputStream.readInt());
                    }
                } else {
                    while (n4 > 0) {
                        fixedIntBuffer.append((int)(dataInputStream.readLong() >> 32));
                        --n4;
                    }
                }
                vTDGen.l3Buffer = fixedIntBuffer;
            } else {
                int n7;
                int n8;
                FixedLongBuffer fixedLongBuffer4 = new FixedLongBuffer(n4);
                while (n4 > 0) {
                    fixedLongBuffer4.append(dataInputStream.readLong());
                    --n4;
                }
                vTDGen._l3Buffer = fixedLongBuffer4;
                FixedLongBuffer fixedLongBuffer5 = new FixedLongBuffer(n8);
                for (n8 = (int)dataInputStream.readLong(); n8 > 0; --n8) {
                    fixedLongBuffer5.append(dataInputStream.readLong());
                }
                vTDGen._l4Buffer = fixedLongBuffer5;
                FixedIntBuffer fixedIntBuffer = new FixedIntBuffer(n7);
                if (bl) {
                    for (n7 = (int)dataInputStream.readLong(); n7 > 0; --n7) {
                        fixedIntBuffer.append(dataInputStream.readInt());
                    }
                } else {
                    while (n7 > 0) {
                        fixedIntBuffer.append((int)(dataInputStream.readLong() >> 32));
                        --n7;
                    }
                }
                vTDGen._l5Buffer = fixedIntBuffer;
            }
        } else {
            int n9;
            for (n = (int)IndexHandler.reverseLong(dataInputStream.readLong()); n > 0; --n) {
                vTDGen.VTDBuffer.append(IndexHandler.reverseLong(dataInputStream.readLong()));
            }
            for (int i = (int)IndexHandler.reverseLong(dataInputStream.readLong()); i > 0; --i) {
                long l = IndexHandler.reverseLong(dataInputStream.readLong());
                vTDGen.l1Buffer.append(l);
            }
            for (int i = (int)IndexHandler.reverseLong(dataInputStream.readLong()); i > 0; --i) {
                long l = IndexHandler.reverseLong(dataInputStream.readLong());
                vTDGen.l2Buffer.append(l);
            }
            if (vTDGen.shallowDepth) {
                if (bl) {
                    for (n9 = (int)IndexHandler.reverseLong(dataInputStream.readLong()); n9 > 0; --n9) {
                        vTDGen.l3Buffer.append(IndexHandler.reverseInt(dataInputStream.readInt()));
                    }
                } else {
                    while (n9 > 0) {
                        vTDGen.l3Buffer.append(IndexHandler.reverseInt((int)(dataInputStream.readLong() >> 32)));
                        --n9;
                    }
                }
            } else {
                int n10;
                while (n9 > 0) {
                    vTDGen._l3Buffer.append(IndexHandler.reverseLong(dataInputStream.readLong()));
                    --n9;
                }
                for (int i = (int)IndexHandler.reverseLong(dataInputStream.readLong()); i > 0; --i) {
                    long l = IndexHandler.reverseLong(dataInputStream.readLong());
                    vTDGen._l4Buffer.append(l);
                }
                if (bl) {
                    for (n10 = (int)IndexHandler.reverseLong(dataInputStream.readLong()); n10 > 0; --n10) {
                        vTDGen._l5Buffer.append(IndexHandler.reverseInt(dataInputStream.readInt()));
                    }
                } else {
                    while (n10 > 0) {
                        vTDGen._l5Buffer.append(IndexHandler.reverseInt((int)(dataInputStream.readLong() >> 32)));
                        --n10;
                    }
                }
            }
        }
    }

    public static void readSeparateIndex(InputStream inputStream, InputStream inputStream2, int n, VTDGen vTDGen) throws IndexReadException, IOException {
        if (inputStream == null || vTDGen == null || inputStream2 == null) {
            throw new IndexReadException("Invalid argument(s) for readSeparateIndex()");
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte by = dataInputStream.readByte();
        if (by != 2) {
            throw new IndexReadException("Invalid version number for readIndex()");
        }
        vTDGen.encoding = dataInputStream.readByte();
        by = dataInputStream.readByte();
        boolean bl = (by & 0x80) != 0;
        vTDGen.ns = (by & 0x40) != 0;
        boolean bl2 = (by & 0x20) != 0;
        if ((by & 0x1F) != 0) {
            throw new IndexReadException("Last 5 bits of the third byte should be zero");
        }
        vTDGen.VTDDepth = dataInputStream.readByte();
        int n2 = dataInputStream.readByte() << 8 | dataInputStream.readByte();
        if (n2 != 4 && n2 != 6) {
            throw new IndexReadException("LC levels must be at least 3");
        }
        vTDGen.shallowDepth = n2 == 4;
        vTDGen.rootIndex = dataInputStream.readByte() << 8 | dataInputStream.readByte();
        dataInputStream.readLong();
        dataInputStream.readLong();
        int n3 = 0;
        n3 = bl2 ? (int)dataInputStream.readLong() : (int)IndexHandler.reverseLong(dataInputStream.readLong());
        if (n3 != n) {
            throw new IndexReadException("XML size mismatch");
        }
        byte[] byArray = new byte[n3];
        inputStream2.read(byArray);
        vTDGen.setDoc(byArray);
        dataInputStream.readLong();
        dataInputStream.readLong();
        if (bl2) {
            int n4;
            int n5;
            for (int i = (int)dataInputStream.readLong(); i > 0; --i) {
                vTDGen.VTDBuffer.append(dataInputStream.readLong());
            }
            for (int i = (int)dataInputStream.readLong(); i > 0; --i) {
                long l = dataInputStream.readLong();
                vTDGen.l1Buffer.append(l);
            }
            for (n5 = (int)dataInputStream.readLong(); n5 > 0; --n5) {
                vTDGen.l2Buffer.append(dataInputStream.readLong());
            }
            if (vTDGen.shallowDepth) {
                if (bl) {
                    for (n4 = (int)dataInputStream.readLong(); n4 > 0; --n4) {
                        vTDGen.l3Buffer.append(dataInputStream.readInt());
                    }
                } else {
                    while (n4 > 0) {
                        vTDGen.l3Buffer.append((int)(dataInputStream.readLong() >> 32));
                        --n4;
                    }
                }
            } else {
                int n6;
                while (n4 > 0) {
                    vTDGen._l3Buffer.append(dataInputStream.readLong());
                    --n4;
                }
                int n7 = (int)dataInputStream.readLong();
                while (n5 > 0) {
                    vTDGen._l4Buffer.append(dataInputStream.readLong());
                    --n7;
                }
                if (bl) {
                    while (n5 > 0) {
                        vTDGen._l5Buffer.append(dataInputStream.readInt());
                        --n6;
                    }
                } else {
                    for (n6 = (int)dataInputStream.readLong(); n6 > 0; --n6) {
                        vTDGen._l5Buffer.append((int)(dataInputStream.readLong() >> 32));
                    }
                }
            }
        } else {
            int n8;
            for (int i = (int)IndexHandler.reverseLong(dataInputStream.readLong()); i > 0; --i) {
                vTDGen.VTDBuffer.append(IndexHandler.reverseLong(dataInputStream.readLong()));
            }
            for (int i = (int)IndexHandler.reverseLong(dataInputStream.readLong()); i > 0; --i) {
                long l = IndexHandler.reverseLong(dataInputStream.readLong());
                vTDGen.l1Buffer.append(l);
            }
            for (int i = (int)IndexHandler.reverseLong(dataInputStream.readLong()); i > 0; --i) {
                long l = IndexHandler.reverseLong(dataInputStream.readLong());
                vTDGen.l2Buffer.append(l);
            }
            if (vTDGen.shallowDepth) {
                if (bl) {
                    for (n8 = (int)IndexHandler.reverseLong(dataInputStream.readLong()); n8 > 0; --n8) {
                        vTDGen.l3Buffer.append(IndexHandler.reverseInt(dataInputStream.readInt()));
                    }
                } else {
                    while (n8 > 0) {
                        vTDGen.l3Buffer.append(IndexHandler.reverseInt((int)(dataInputStream.readLong() >> 32)));
                        --n8;
                    }
                }
            } else {
                int n9;
                while (n8 > 0) {
                    vTDGen._l3Buffer.append(IndexHandler.reverseLong(dataInputStream.readLong()));
                    --n8;
                }
                for (int i = (int)IndexHandler.reverseLong(dataInputStream.readLong()); i > 0; --i) {
                    long l = IndexHandler.reverseLong(dataInputStream.readLong());
                    vTDGen._l4Buffer.append(l);
                }
                if (bl) {
                    for (n9 = (int)IndexHandler.reverseLong(dataInputStream.readLong()); n9 > 0; --n9) {
                        vTDGen._l5Buffer.append(IndexHandler.reverseInt(dataInputStream.readInt()));
                    }
                } else {
                    while (n9 > 0) {
                        vTDGen._l5Buffer.append(IndexHandler.reverseInt((int)(dataInputStream.readLong() >> 32)));
                        --n9;
                    }
                }
            }
        }
    }

    private static long reverseLong(long l) {
        return Long.reverseBytes(l);
    }

    private static int reverseInt(int n) {
        return Integer.reverseBytes(n);
    }

    private static long adjust(long l, int n) {
        long l2 = (l & 0xFFFFFFFFL) + (long)n;
        long l3 = l & 0xFFFFFFFF00000000L;
        return l2 | l3;
    }
}

