/*
 * Decompiled with CFR 0.152.
 */
package com.xgc1986.ripplebutton.utils;

import android.content.res.ColorStateList;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.view.View;

public class RippleDrawableHelper {
    public static Drawable createRippleDrawable(View v, int color) {
        return RippleDrawableHelper.createRippleDrawable(v, color, null);
    }

    public static Drawable createRippleDrawable(View v, int color, int drawableResource) {
        return RippleDrawableHelper.createRippleDrawable(v, color, v.getContext().getResources().getDrawable(drawableResource));
    }

    public static Drawable createRippleDrawable(View v, int color, Drawable pressed) {
        Drawable drawable = v.getBackground();
        if (Build.VERSION.SDK_INT >= 21) {
            if (drawable instanceof RippleDrawable) {
                drawable = ((RippleDrawable)drawable).getDrawable(0);
                RippleDrawable rippleDrawable = new RippleDrawable(new ColorStateList((int[][])new int[][]{{16842919}, {0}}, new int[]{color, 0}), drawable, null);
                return rippleDrawable;
            }
            if (drawable == null) {
                drawable = new ColorDrawable(0);
                v.setBackground(drawable);
                RippleDrawable rippleDrawable = new RippleDrawable(new ColorStateList((int[][])new int[][]{{16842919}, {0}}, new int[]{color, 0}), drawable, (Drawable)new ColorDrawable(-1));
                return rippleDrawable;
            }
            RippleDrawable rippleDrawable = new RippleDrawable(new ColorStateList((int[][])new int[][]{{16842919}, {0}}, new int[]{color, 0}), drawable, null);
            return rippleDrawable;
        }
        if (drawable == null) {
            drawable = new ColorDrawable(color);
        }
        if (pressed == null) {
            pressed = drawable;
        }
        StateListDrawable sld = new StateListDrawable();
        sld.addState(new int[]{16842919}, pressed);
        if (v.getBackground() != null) {
            sld.addState(new int[]{0}, drawable);
        }
        return sld;
    }
}

