/*
 * Decompiled with CFR 0.152.
 */
package com.xgc1986.parallaxPagerTransformer;

import android.annotation.TargetApi;
import android.os.Build;
import android.support.v4.view.ViewPager;
import android.view.View;

public class ParallaxPagerTransformer
implements ViewPager.PageTransformer {
    private int id;
    private int border = 0;
    private float speed = 0.2f;

    public ParallaxPagerTransformer(int id) {
        this.id = id;
    }

    @TargetApi(value=11)
    public void transformPage(View view, float position) {
        View parallaxView = view.findViewById(this.id);
        if (parallaxView != null && Build.VERSION.SDK_INT > 11 && position > -1.0f && position < 1.0f) {
            float width = parallaxView.getWidth();
            parallaxView.setTranslationX(-(position * width * this.speed));
            float sc = ((float)view.getWidth() - (float)this.border) / (float)view.getWidth();
            if (position == 0.0f) {
                view.setScaleX(1.0f);
                view.setScaleY(1.0f);
            } else {
                view.setScaleX(sc);
                view.setScaleY(sc);
            }
        }
    }

    public void setBorder(int px) {
        this.border = px;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }
}

