/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.util.sha1;

import com.xenoterracide.gradle.semver.jgit.lib.Constants;
import com.xenoterracide.gradle.semver.jgit.lib.MutableObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectId;
import com.xenoterracide.gradle.semver.jgit.util.sha1.SHA1;
import com.xenoterracide.gradle.semver.jgit.util.sha1.Sha1CollisionException;
import java.security.MessageDigest;

class SHA1Native
extends SHA1 {
    private final MessageDigest md = Constants.newMessageDigest();

    SHA1Native() {
    }

    @Override
    public void update(byte b) {
        this.md.update(b);
    }

    @Override
    public void update(byte[] in) {
        this.md.update(in);
    }

    @Override
    public void update(byte[] in, int p, int len) {
        this.md.update(in, p, len);
    }

    @Override
    public byte[] digest() throws Sha1CollisionException {
        return this.md.digest();
    }

    @Override
    public ObjectId toObjectId() throws Sha1CollisionException {
        return ObjectId.fromRaw(this.md.digest());
    }

    @Override
    public void digest(MutableObjectId id) throws Sha1CollisionException {
        id.fromRaw(this.md.digest());
    }

    @Override
    public SHA1 reset() {
        this.md.reset();
        return this;
    }

    @Override
    public SHA1 setDetectCollision(boolean detect) {
        return this;
    }

    @Override
    public boolean hasCollision() {
        return false;
    }
}

