/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.transport;

import com.xenoterracide.gradle.semver.jgit.errors.NotSupportedException;
import com.xenoterracide.gradle.semver.jgit.errors.TransportException;
import com.xenoterracide.gradle.semver.jgit.internal.JGitText;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import com.xenoterracide.gradle.semver.jgit.transport.BundleFetchConnection;
import com.xenoterracide.gradle.semver.jgit.transport.FetchConnection;
import com.xenoterracide.gradle.semver.jgit.transport.PushConnection;
import com.xenoterracide.gradle.semver.jgit.transport.Transport;
import com.xenoterracide.gradle.semver.jgit.transport.TransportBundle;
import com.xenoterracide.gradle.semver.jgit.transport.URIish;
import java.io.IOException;
import java.io.InputStream;

public class TransportBundleStream
extends Transport
implements TransportBundle {
    private InputStream src;

    public TransportBundleStream(Repository db, URIish uri, InputStream in) {
        super(db, uri);
        this.src = in;
    }

    @Override
    public FetchConnection openFetch() throws TransportException {
        if (this.src == null) {
            throw new TransportException(this.uri, JGitText.get().onlyOneFetchSupported);
        }
        try {
            BundleFetchConnection bundleFetchConnection = new BundleFetchConnection(this, this.src);
            return bundleFetchConnection;
        }
        finally {
            this.src = null;
        }
    }

    @Override
    public PushConnection openPush() throws NotSupportedException {
        throw new NotSupportedException(JGitText.get().pushIsNotSupportedForBundleTransport);
    }

    @Override
    public void close() {
        if (this.src != null) {
            try {
                try {
                    this.src.close();
                }
                catch (IOException iOException) {
                    this.src = null;
                }
            }
            finally {
                this.src = null;
            }
        }
    }
}

