/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.transport;

import com.xenoterracide.gradle.semver.jgit.transport.AdvertiseRefsHook;
import com.xenoterracide.gradle.semver.jgit.transport.ReceivePack;
import com.xenoterracide.gradle.semver.jgit.transport.ServiceMayNotContinueException;
import com.xenoterracide.gradle.semver.jgit.transport.UploadPack;
import java.io.IOException;
import java.util.List;

public class AdvertiseRefsHookChain
implements AdvertiseRefsHook {
    private final AdvertiseRefsHook[] hooks;
    private final int count;

    public static AdvertiseRefsHook newChain(List<? extends AdvertiseRefsHook> hooks) {
        AdvertiseRefsHook[] newHooks = new AdvertiseRefsHook[hooks.size()];
        int i = 0;
        for (AdvertiseRefsHook advertiseRefsHook : hooks) {
            if (advertiseRefsHook == AdvertiseRefsHook.DEFAULT) continue;
            newHooks[i++] = advertiseRefsHook;
        }
        switch (i) {
            case 0: {
                return AdvertiseRefsHook.DEFAULT;
            }
            case 1: {
                return newHooks[0];
            }
        }
        return new AdvertiseRefsHookChain(newHooks, i);
    }

    @Override
    public void advertiseRefs(ReceivePack rp) throws IOException {
        int i = 0;
        while (i < this.count) {
            this.hooks[i].advertiseRefs(rp);
            ++i;
        }
    }

    @Override
    public void advertiseRefs(UploadPack rp) throws ServiceMayNotContinueException {
        int i = 0;
        while (i < this.count) {
            this.hooks[i].advertiseRefs(rp);
            ++i;
        }
    }

    private AdvertiseRefsHookChain(AdvertiseRefsHook[] hooks, int count) {
        this.hooks = hooks;
        this.count = count;
    }
}

