/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.revwalk;

import com.xenoterracide.gradle.semver.jgit.errors.IncorrectObjectTypeException;
import com.xenoterracide.gradle.semver.jgit.errors.MissingObjectException;
import com.xenoterracide.gradle.semver.jgit.internal.storage.commitgraph.ChangedPathFilter;
import com.xenoterracide.gradle.semver.jgit.internal.storage.commitgraph.CommitGraph;
import com.xenoterracide.gradle.semver.jgit.lib.AnyObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectId;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevCommit;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevWalk;
import java.io.IOException;

class RevCommitCG
extends RevCommit {
    private final int graphPosition;
    private int generation = Integer.MAX_VALUE;

    protected RevCommitCG(AnyObjectId id, int graphPosition) {
        super(id);
        this.graphPosition = graphPosition;
    }

    @Override
    void parseCanonical(RevWalk walk, byte[] raw) throws IOException {
        if (walk.isRetainBody()) {
            this.buffer = raw;
        }
        this.parseInGraph(walk);
    }

    @Override
    void parseHeaders(RevWalk walk) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (walk.isRetainBody()) {
            super.parseBody(walk);
            return;
        }
        this.parseInGraph(walk);
    }

    private void parseInGraph(RevWalk walk) throws IOException {
        CommitGraph graph = walk.commitGraph();
        CommitGraph.CommitData data = graph.getCommitData(this.graphPosition);
        if (data == null) {
            throw new IllegalStateException();
        }
        if (!walk.shallowCommitsInitialized) {
            walk.initializeShallowCommits(this);
        }
        this.tree = walk.lookupTree(data.getTree());
        this.commitTime = (int)data.getCommitTime();
        this.generation = data.getGeneration();
        if (this.getParents() == null) {
            int[] pGraphList = data.getParents();
            if (pGraphList.length == 0) {
                this.parents = RevCommit.NO_PARENTS;
            } else {
                RevCommit[] pList = new RevCommit[pGraphList.length];
                int i = 0;
                while (i < pList.length) {
                    int graphPos = pGraphList[i];
                    ObjectId objId = graph.getObjectId(graphPos);
                    pList[i] = walk.lookupCommit(objId, graphPos);
                    ++i;
                }
                this.parents = pList;
            }
        }
        this.flags |= 1;
    }

    @Override
    int getGeneration() {
        return this.generation;
    }

    @Override
    public ChangedPathFilter getChangedPathFilter(RevWalk rw) {
        return rw.commitGraph().getChangedPathFilter(this.graphPosition);
    }
}

