/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.revwalk;

import com.xenoterracide.gradle.semver.jgit.errors.CorruptObjectException;
import com.xenoterracide.gradle.semver.jgit.errors.IncorrectObjectTypeException;
import com.xenoterracide.gradle.semver.jgit.errors.LargeObjectException;
import com.xenoterracide.gradle.semver.jgit.errors.MissingObjectException;
import com.xenoterracide.gradle.semver.jgit.internal.JGitText;
import com.xenoterracide.gradle.semver.jgit.lib.AnyObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectReader;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import com.xenoterracide.gradle.semver.jgit.revwalk.BlockObjQueue;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevBlob;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevCommit;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevObject;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevSort;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevTag;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevTree;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevWalk;
import com.xenoterracide.gradle.semver.jgit.revwalk.filter.ObjectFilter;
import com.xenoterracide.gradle.semver.jgit.util.RawParseUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ObjectWalk
extends RevWalk {
    private static final int ID_SZ = 20;
    private static final int TYPE_SHIFT = 12;
    private static final int TYPE_TREE = 4;
    private static final int TYPE_SYMLINK = 10;
    private static final int TYPE_FILE = 8;
    private static final int TYPE_GITLINK = 14;
    private static final int IN_PENDING = 8;
    public static final VisitationPolicy SIMPLE_VISITATION_POLICY = new VisitationPolicy(){

        @Override
        public boolean shouldVisit(RevObject o) {
            return (o.flags & 2) == 0;
        }

        @Override
        public void visited(RevObject o) {
            o.flags |= 2;
        }
    };
    private List<RevObject> rootObjects;
    private BlockObjQueue pendingObjects;
    private ObjectFilter objectFilter;
    private TreeVisit freeVisit;
    private TreeVisit currVisit;
    private byte[] pathBuf;
    private int pathLen;
    private boolean boundary;
    private VisitationPolicy visitationPolicy = SIMPLE_VISITATION_POLICY;

    public ObjectWalk(Repository repo) {
        this(repo.newObjectReader(), true);
    }

    public ObjectWalk(ObjectReader or) {
        this(or, false);
    }

    private ObjectWalk(ObjectReader or, boolean closeReader) {
        super(or, closeReader);
        this.setRetainBody(false);
        this.rootObjects = new ArrayList<RevObject>();
        this.pendingObjects = new BlockObjQueue();
        this.objectFilter = ObjectFilter.ALL;
        this.pathBuf = new byte[256];
    }

    public void markStart(RevObject o) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        while (o instanceof RevTag) {
            this.addObject(o);
            o = ((RevTag)o).getObject();
            this.parseHeaders(o);
        }
        if (o instanceof RevCommit) {
            super.markStart((RevCommit)o);
        } else {
            this.addObject(o);
        }
    }

    public void markUninteresting(RevObject o) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        while (o instanceof RevTag) {
            o.flags |= 4;
            if (this.boundary) {
                this.addObject(o);
            }
            o = ((RevTag)o).getObject();
            this.parseHeaders(o);
        }
        if (o instanceof RevCommit) {
            super.markUninteresting((RevCommit)o);
        } else if (o instanceof RevTree) {
            this.markTreeUninteresting((RevTree)o);
        } else {
            o.flags |= 4;
        }
        if (o.getType() != 1 && this.boundary) {
            this.addObject(o);
        }
    }

    @Override
    public void sort(RevSort s) {
        super.sort(s);
        this.boundary = this.hasRevSort(RevSort.BOUNDARY);
    }

    @Override
    public void sort(RevSort s, boolean use) {
        super.sort(s, use);
        this.boundary = this.hasRevSort(RevSort.BOUNDARY);
    }

    public ObjectFilter getObjectFilter() {
        return this.objectFilter;
    }

    public void setObjectFilter(ObjectFilter newFilter) {
        this.assertNotStarted();
        this.objectFilter = newFilter != null ? newFilter : ObjectFilter.ALL;
    }

    public void setVisitationPolicy(VisitationPolicy policy) {
        this.assertNotStarted();
        this.visitationPolicy = Objects.requireNonNull(policy);
    }

    @Override
    public RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevTree t;
        RevCommit r;
        block3: {
            do {
                if ((r = super.next()) == null) {
                    return null;
                }
                t = r.getTree();
                if ((r.flags & 4) == 0) break block3;
                if (!this.objectFilter.include(this, t)) continue;
                this.markTreeUninteresting(t);
            } while (!this.boundary);
            return r;
        }
        if (this.objectFilter.include(this, t)) {
            this.pendingObjects.add(t);
        }
        return r;
    }

    public void skipTree() {
        if (this.currVisit != null) {
            this.currVisit.ptr = this.currVisit.buf.length;
        }
    }

    public RevObject nextObject() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevObject o;
        this.pathLen = 0;
        TreeVisit tv = this.currVisit;
        while (tv != null) {
            byte[] buf = tv.buf;
            int ptr = tv.ptr;
            block6: while (ptr < buf.length) {
                RevObject obj;
                int startPtr = ptr;
                ptr = ObjectWalk.findObjectId(buf, ptr);
                this.idBuffer.fromRaw(buf, ptr);
                ptr += 20;
                if (!this.objectFilter.include(this, this.idBuffer) || (obj = (RevObject)this.objects.get(this.idBuffer)) != null && !this.visitationPolicy.shouldVisit(obj)) continue;
                int mode = ObjectWalk.parseMode(buf, startPtr, ptr, tv);
                switch (mode >>> 12) {
                    case 8: 
                    case 10: {
                        if (obj == null) {
                            obj = new RevBlob(this.idBuffer);
                            this.visitationPolicy.visited(obj);
                            this.objects.add(obj);
                            return obj;
                        }
                        if (!(obj instanceof RevBlob)) {
                            throw new IncorrectObjectTypeException((ObjectId)obj, 3);
                        }
                        this.visitationPolicy.visited(obj);
                        if ((obj.flags & 4) == 0) {
                            return obj;
                        }
                        if (!this.boundary) continue block6;
                        return obj;
                    }
                    case 4: {
                        if (obj == null) {
                            obj = new RevTree(this.idBuffer);
                            this.visitationPolicy.visited(obj);
                            this.objects.add(obj);
                            return this.pushTree(obj);
                        }
                        if (!(obj instanceof RevTree)) {
                            throw new IncorrectObjectTypeException((ObjectId)obj, 2);
                        }
                        this.visitationPolicy.visited(obj);
                        if ((obj.flags & 4) == 0) {
                            return this.pushTree(obj);
                        }
                        if (!this.boundary) continue block6;
                        return this.pushTree(obj);
                    }
                    case 14: {
                        break;
                    }
                    default: {
                        throw new CorruptObjectException(MessageFormat.format(JGitText.get().corruptObjectInvalidMode3, String.format("%o", mode), this.idBuffer.name(), RawParseUtils.decode(buf, tv.namePtr, tv.nameEnd), tv.obj));
                    }
                }
            }
            this.currVisit = tv.parent;
            this.releaseTreeVisit(tv);
            tv = this.currVisit;
        }
        while (true) {
            if ((o = this.pendingObjects.next()) == null) {
                return null;
            }
            if (!this.visitationPolicy.shouldVisit(o)) continue;
            this.visitationPolicy.visited(o);
            if ((o.flags & 4) == 0 || this.boundary) break;
        }
        if (o instanceof RevTree) {
            assert (this.currVisit == null);
            this.pushTree(o);
        }
        return o;
    }

    private static int findObjectId(byte[] buf, int ptr) {
        do {
            if (buf[++ptr] == 0) {
                return ++ptr;
            }
            if (buf[++ptr] == 0) {
                return ++ptr;
            }
            if (buf[++ptr] == 0) {
                return ++ptr;
            }
            if (buf[++ptr] == 0) {
                return ++ptr;
            }
            if (buf[++ptr] == 0) {
                return ++ptr;
            }
            if (buf[++ptr] == 0) {
                return ++ptr;
            }
            if (buf[++ptr] == 0) {
                return ++ptr;
            }
            if (buf[++ptr] == 0) {
                return ++ptr;
            }
            if (buf[++ptr] == 0) {
                return ++ptr;
            }
            if (buf[++ptr] == 0) {
                return ++ptr;
            }
            if (buf[++ptr] == 0) {
                return ++ptr;
            }
            if (buf[++ptr] == 0) {
                return ++ptr;
            }
            if (buf[++ptr] == 0) {
                return ++ptr;
            }
            if (buf[++ptr] == 0) {
                return ++ptr;
            }
            if (buf[++ptr] != 0) continue;
            return ++ptr;
        } while (buf[++ptr] != 0);
        return ++ptr;
    }

    private static int parseMode(byte[] buf, int startPtr, int recEndPtr, TreeVisit tv) {
        byte c;
        int mode = buf[startPtr] - 48;
        while (32 != (c = buf[++startPtr])) {
            mode <<= 3;
            mode += c - 48;
            if (32 == (c = buf[++startPtr])) break;
            mode <<= 3;
            mode += c - 48;
            if (32 == (c = buf[++startPtr])) break;
            mode <<= 3;
            mode += c - 48;
            if (32 == (c = buf[++startPtr])) break;
            mode <<= 3;
            mode += c - 48;
            if (32 == (c = buf[++startPtr])) break;
            mode <<= 3;
            mode += c - 48;
            if (32 == (c = buf[++startPtr])) break;
            mode <<= 3;
            mode += c - 48;
            if (32 == (c = buf[++startPtr])) break;
            mode <<= 3;
            mode += c - 48;
        }
        tv.ptr = recEndPtr;
        tv.namePtr = startPtr + 1;
        tv.nameEnd = recEndPtr - 21;
        return mode;
    }

    public void checkConnectivity() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevObject o;
        RevCommit c;
        while ((c = this.next()) != null) {
        }
        while ((o = this.nextObject()) != null) {
            if (!(o instanceof RevBlob) || this.reader.has(o)) continue;
            throw new MissingObjectException((ObjectId)o, 3);
        }
    }

    public String getPathString() {
        if (this.pathLen == 0) {
            this.pathLen = this.updatePathBuf(this.currVisit);
            if (this.pathLen == 0) {
                return null;
            }
        }
        return RawParseUtils.decode(this.pathBuf, 0, this.pathLen);
    }

    public int getTreeDepth() {
        if (this.currVisit == null) {
            return 0;
        }
        return this.currVisit.depth;
    }

    public int getPathHashCode() {
        int ptr;
        byte[] buf;
        TreeVisit tv = this.currVisit;
        if (tv == null) {
            return 0;
        }
        int nameEnd = tv.nameEnd;
        if (nameEnd == 0) {
            tv = tv.parent;
            if (tv == null) {
                return 0;
            }
            nameEnd = tv.nameEnd;
        }
        if (16 <= nameEnd - tv.namePtr) {
            buf = tv.buf;
            ptr = nameEnd - 16;
        } else {
            nameEnd = this.pathLen;
            if (nameEnd == 0) {
                this.pathLen = nameEnd = this.updatePathBuf(this.currVisit);
            }
            buf = this.pathBuf;
            ptr = Math.max(0, nameEnd - 16);
        }
        int hash = 0;
        while (ptr < nameEnd) {
            byte c = buf[ptr];
            if (c != 32) {
                hash = (hash >>> 2) + (c << 24);
            }
            ++ptr;
        }
        return hash;
    }

    public byte[] getPathBuffer() {
        if (this.pathLen == 0) {
            this.pathLen = this.updatePathBuf(this.currVisit);
        }
        return this.pathBuf;
    }

    public int getPathLength() {
        if (this.pathLen == 0) {
            this.pathLen = this.updatePathBuf(this.currVisit);
        }
        return this.pathLen;
    }

    private int updatePathBuf(TreeVisit tv) {
        if (tv == null) {
            return 0;
        }
        int nameEnd = tv.nameEnd;
        if (nameEnd == 0) {
            return this.updatePathBuf(tv.parent);
        }
        int ptr = tv.pathLen;
        if (ptr == 0) {
            ptr = this.updatePathBuf(tv.parent);
            if (ptr == this.pathBuf.length) {
                this.growPathBuf(ptr);
            }
            if (ptr != 0) {
                this.pathBuf[ptr++] = 47;
            }
            tv.pathLen = ptr;
        }
        int namePtr = tv.namePtr;
        int nameLen = nameEnd - namePtr;
        int end = ptr + nameLen;
        while (this.pathBuf.length < end) {
            this.growPathBuf(ptr);
        }
        System.arraycopy(tv.buf, namePtr, this.pathBuf, ptr, nameLen);
        return end;
    }

    private void growPathBuf(int ptr) {
        byte[] newBuf = new byte[this.pathBuf.length << 1];
        System.arraycopy(this.pathBuf, 0, newBuf, 0, ptr);
        this.pathBuf = newBuf;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.pendingObjects = new BlockObjQueue();
        this.currVisit = null;
        this.freeVisit = null;
    }

    @Override
    protected void reset(int retainFlags) {
        super.reset(retainFlags);
        for (RevObject obj : this.rootObjects) {
            obj.flags &= 0xFFFFFFF7;
        }
        this.rootObjects = new ArrayList<RevObject>();
        this.pendingObjects = new BlockObjQueue();
        this.currVisit = null;
        this.freeVisit = null;
    }

    private void addObject(RevObject o) {
        if ((o.flags & 8) == 0) {
            o.flags |= 8;
            this.rootObjects.add(o);
            this.pendingObjects.add(o);
        }
    }

    private void markTreeUninteresting(RevTree tree) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if ((tree.flags & 4) != 0) {
            return;
        }
        tree.flags |= 4;
        byte[] raw = this.reader.open(tree, 2).getCachedBytes();
        int ptr = 0;
        while (ptr < raw.length) {
            byte c = raw[ptr];
            int mode = c - 48;
            while (32 != (c = raw[++ptr])) {
                mode <<= 3;
                mode += c - 48;
            }
            while (raw[++ptr] != 0) {
            }
            ++ptr;
            switch (mode >>> 12) {
                case 8: 
                case 10: {
                    this.idBuffer.fromRaw(raw, ptr);
                    this.lookupBlob((AnyObjectId)this.idBuffer).flags |= 4;
                    break;
                }
                case 4: {
                    this.idBuffer.fromRaw(raw, ptr);
                    this.markTreeUninteresting(this.lookupTree(this.idBuffer));
                    break;
                }
                case 14: {
                    break;
                }
                default: {
                    this.idBuffer.fromRaw(raw, ptr);
                    throw new CorruptObjectException(MessageFormat.format(JGitText.get().corruptObjectInvalidMode3, String.format("%o", mode), this.idBuffer.name(), "", tree));
                }
            }
            ptr += 20;
        }
    }

    private RevObject pushTree(RevObject obj) throws LargeObjectException, MissingObjectException, IncorrectObjectTypeException, IOException {
        TreeVisit tv = this.freeVisit;
        if (tv != null) {
            this.freeVisit = tv.parent;
            tv.ptr = 0;
            tv.namePtr = 0;
            tv.nameEnd = 0;
            tv.pathLen = 0;
        } else {
            tv = new TreeVisit();
        }
        tv.obj = obj;
        tv.buf = this.reader.open(obj, 2).getCachedBytes();
        tv.parent = this.currVisit;
        this.currVisit = tv;
        tv.depth = tv.parent == null ? 1 : tv.parent.depth + 1;
        return obj;
    }

    private void releaseTreeVisit(TreeVisit tv) {
        tv.buf = null;
        tv.parent = this.freeVisit;
        this.freeVisit = tv;
    }

    private static class TreeVisit {
        TreeVisit parent;
        RevObject obj;
        byte[] buf;
        int ptr;
        int namePtr;
        int nameEnd;
        int pathLen;
        int depth;

        private TreeVisit() {
        }
    }

    public static interface VisitationPolicy {
        public boolean shouldVisit(RevObject var1);

        public void visited(RevObject var1);
    }
}

