/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.lib;

import com.xenoterracide.gradle.semver.jgit.lib.Config;
import com.xenoterracide.gradle.semver.jgit.util.SystemReader;

public class UserConfig {
    public static final Config.SectionParser<UserConfig> KEY = UserConfig::new;
    private String authorName;
    private String authorEmail;
    private String committerName;
    private String committerEmail;
    private boolean isAuthorNameImplicit;
    private boolean isAuthorEmailImplicit;
    private boolean isCommitterNameImplicit;
    private boolean isCommitterEmailImplicit;

    private UserConfig(Config rc) {
        this.authorName = UserConfig.getNameInternal(rc, "GIT_AUTHOR_NAME");
        if (this.authorName == null) {
            this.authorName = UserConfig.getDefaultUserName();
            this.isAuthorNameImplicit = true;
        }
        this.authorEmail = UserConfig.getEmailInternal(rc, "GIT_AUTHOR_EMAIL");
        if (this.authorEmail == null) {
            this.authorEmail = UserConfig.getDefaultEmail();
            this.isAuthorEmailImplicit = true;
        }
        this.committerName = UserConfig.getNameInternal(rc, "GIT_COMMITTER_NAME");
        if (this.committerName == null) {
            this.committerName = UserConfig.getDefaultUserName();
            this.isCommitterNameImplicit = true;
        }
        this.committerEmail = UserConfig.getEmailInternal(rc, "GIT_COMMITTER_EMAIL");
        if (this.committerEmail == null) {
            this.committerEmail = UserConfig.getDefaultEmail();
            this.isCommitterEmailImplicit = true;
        }
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public String getCommitterName() {
        return this.committerName;
    }

    public String getAuthorEmail() {
        return this.authorEmail;
    }

    public String getCommitterEmail() {
        return this.committerEmail;
    }

    public boolean isAuthorNameImplicit() {
        return this.isAuthorNameImplicit;
    }

    public boolean isAuthorEmailImplicit() {
        return this.isAuthorEmailImplicit;
    }

    public boolean isCommitterNameImplicit() {
        return this.isCommitterNameImplicit;
    }

    public boolean isCommitterEmailImplicit() {
        return this.isCommitterEmailImplicit;
    }

    private static String getNameInternal(Config rc, String envKey) {
        String username = UserConfig.system().getenv(envKey);
        if (username == null) {
            username = rc.getString("user", null, "name");
        }
        return UserConfig.stripInvalidCharacters(username);
    }

    private static String getDefaultUserName() {
        String username = UserConfig.system().getProperty("user.name");
        if (username == null) {
            username = "unknown-user";
        }
        return username;
    }

    private static String getEmailInternal(Config rc, String envKey) {
        String email = UserConfig.system().getenv(envKey);
        if (email == null) {
            email = rc.getString("user", null, "email");
        }
        return UserConfig.stripInvalidCharacters(email);
    }

    private static String stripInvalidCharacters(String s) {
        return s == null ? null : s.replaceAll("<|>|\n", "");
    }

    private static String getDefaultEmail() {
        String username = UserConfig.getDefaultUserName();
        return username + "@" + UserConfig.system().getHostname();
    }

    private static SystemReader system() {
        return SystemReader.getInstance();
    }
}

