/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.lib;

import com.xenoterracide.gradle.semver.jgit.annotations.NonNull;
import com.xenoterracide.gradle.semver.jgit.internal.JGitText;
import com.xenoterracide.gradle.semver.jgit.lib.GpgConfig;
import com.xenoterracide.gradle.semver.jgit.lib.Signer;
import com.xenoterracide.gradle.semver.jgit.lib.SignerFactory;
import java.text.MessageFormat;
import java.util.EnumMap;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Signers {
    private static final Logger LOG = LoggerFactory.getLogger(Signers.class);
    private static final Map<GpgConfig.GpgFormat, SignerFactory> SIGNER_FACTORIES = Signers.loadSigners();
    private static final Map<GpgConfig.GpgFormat, Signer> SIGNERS = new ConcurrentHashMap<GpgConfig.GpgFormat, Signer>();

    private static Map<GpgConfig.GpgFormat, SignerFactory> loadSigners() {
        EnumMap<GpgConfig.GpgFormat, SignerFactory> result = new EnumMap<GpgConfig.GpgFormat, SignerFactory>(GpgConfig.GpgFormat.class);
        try {
            for (SignerFactory factory : ServiceLoader.load(SignerFactory.class)) {
                GpgConfig.GpgFormat format = factory.getType();
                SignerFactory existing = (SignerFactory)result.get(format);
                if (existing != null) {
                    LOG.warn("{}", (Object)MessageFormat.format(JGitText.get().signatureServiceConflict, "SignerFactory", format, existing.getClass().getCanonicalName(), factory.getClass().getCanonicalName()));
                    continue;
                }
                result.put(format, factory);
            }
        }
        catch (ServiceConfigurationError e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private Signers() {
    }

    public static Signer get(@NonNull GpgConfig.GpgFormat format) {
        return SIGNERS.computeIfAbsent(format, f -> {
            SignerFactory factory = SIGNER_FACTORIES.get(format);
            if (factory == null) {
                return null;
            }
            return factory.create();
        });
    }

    public static void set(@NonNull GpgConfig.GpgFormat format, Signer signer) {
        if (signer == null) {
            SIGNERS.remove(format);
        } else {
            SIGNERS.put(format, signer);
        }
    }
}

