/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.internal.storage.file;

import com.xenoterracide.gradle.semver.jgit.internal.JGitText;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.CheckoutEntryImpl;
import com.xenoterracide.gradle.semver.jgit.lib.CheckoutEntry;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.PersonIdent;
import com.xenoterracide.gradle.semver.jgit.lib.ReflogEntry;
import com.xenoterracide.gradle.semver.jgit.util.RawParseUtils;
import java.io.Serializable;

public class ReflogEntryImpl
implements Serializable,
ReflogEntry {
    private static final long serialVersionUID = 1L;
    private ObjectId oldId;
    private ObjectId newId;
    private PersonIdent who;
    private String comment;

    ReflogEntryImpl(byte[] raw, int pos) {
        int p1;
        this.oldId = ObjectId.fromString(raw, pos);
        pos += 40;
        if (raw[pos++] != 32) {
            throw new IllegalArgumentException(JGitText.get().rawLogMessageDoesNotParseAsLogEntry);
        }
        this.newId = ObjectId.fromString(raw, pos);
        pos += 40;
        if (raw[pos++] != 32) {
            throw new IllegalArgumentException(JGitText.get().rawLogMessageDoesNotParseAsLogEntry);
        }
        this.who = RawParseUtils.parsePersonIdentOnly(raw, pos);
        int p0 = RawParseUtils.next(raw, pos, '\t');
        this.comment = p0 >= raw.length ? "" : ((p1 = RawParseUtils.nextLF(raw, p0)) > p0 ? RawParseUtils.decode(raw, p0, p1 - 1) : "");
    }

    @Override
    public ObjectId getOldId() {
        return this.oldId;
    }

    @Override
    public ObjectId getNewId() {
        return this.newId;
    }

    @Override
    public PersonIdent getWho() {
        return this.who;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public String toString() {
        return "Entry[" + this.oldId.name() + ", " + this.newId.name() + ", " + String.valueOf(this.getWho()) + ", " + this.getComment() + "]";
    }

    @Override
    public CheckoutEntry parseCheckout() {
        if (this.getComment().startsWith("checkout: moving from ")) {
            return new CheckoutEntryImpl(this);
        }
        return null;
    }
}

