/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.internal.storage.file;

import com.xenoterracide.gradle.semver.jgit.annotations.NonNull;
import com.xenoterracide.gradle.semver.jgit.annotations.Nullable;
import com.xenoterracide.gradle.semver.jgit.api.PackRefsCommand;
import com.xenoterracide.gradle.semver.jgit.errors.InvalidObjectIdException;
import com.xenoterracide.gradle.semver.jgit.errors.LockFailedException;
import com.xenoterracide.gradle.semver.jgit.errors.MissingObjectException;
import com.xenoterracide.gradle.semver.jgit.errors.ObjectWritingException;
import com.xenoterracide.gradle.semver.jgit.events.RefsChangedEvent;
import com.xenoterracide.gradle.semver.jgit.internal.JGitText;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.FileRepository;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.FileSnapshot;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.LockFile;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.PackedBatchRefUpdate;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.RefDirectoryRename;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.RefDirectoryUpdate;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.ReflogReaderImpl;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.ReflogWriter;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.SnapshottingRefDirectory;
import com.xenoterracide.gradle.semver.jgit.lib.Constants;
import com.xenoterracide.gradle.semver.jgit.lib.CoreConfig;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectIdRef;
import com.xenoterracide.gradle.semver.jgit.lib.ProgressMonitor;
import com.xenoterracide.gradle.semver.jgit.lib.Ref;
import com.xenoterracide.gradle.semver.jgit.lib.RefComparator;
import com.xenoterracide.gradle.semver.jgit.lib.RefDatabase;
import com.xenoterracide.gradle.semver.jgit.lib.RefUpdate;
import com.xenoterracide.gradle.semver.jgit.lib.RefWriter;
import com.xenoterracide.gradle.semver.jgit.lib.ReflogReader;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import com.xenoterracide.gradle.semver.jgit.lib.SymbolicRef;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevObject;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevTag;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevWalk;
import com.xenoterracide.gradle.semver.jgit.util.FS;
import com.xenoterracide.gradle.semver.jgit.util.FileUtils;
import com.xenoterracide.gradle.semver.jgit.util.IO;
import com.xenoterracide.gradle.semver.jgit.util.RawParseUtils;
import com.xenoterracide.gradle.semver.jgit.util.RefList;
import com.xenoterracide.gradle.semver.jgit.util.RefMap;
import com.xenoterracide.gradle.semver.jgit.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefDirectory
extends RefDatabase {
    private static final Logger LOG = LoggerFactory.getLogger(RefDirectory.class);
    public static final String SYMREF = "ref: ";
    public static final String PACKED_REFS_HEADER = "# pack-refs with:";
    public static final String PACKED_REFS_PEELED = " peeled";
    private static final List<Integer> RETRY_SLEEP_MS = Collections.unmodifiableList(Arrays.asList(0, 100, 200, 400, 800, 1600));
    private final FileRepository parent;
    private final File gitDir;
    private final File gitCommonDir;
    final File refsDir;
    final File packedRefsFile;
    final File logsDir;
    final File logsRefsDir;
    private final AtomicReference<RefList<LooseRef>> looseRefs = new AtomicReference();
    final AtomicReference<PackedRefList> packedRefs = new AtomicReference();
    final ReentrantLock inProcessPackedRefsLock;
    private final AtomicInteger modCnt = new AtomicInteger();
    private final AtomicInteger lastNotifiedModCnt = new AtomicInteger();
    private List<Integer> retrySleepMs = RETRY_SLEEP_MS;
    private final CoreConfig coreConfig;
    private static final PackedRefList NO_PACKED_REFS = new PackedRefList(RefList.emptyList(), FileSnapshot.MISSING_FILE, ObjectId.zeroId());

    RefDirectory(RefDirectory refDb) {
        this.parent = refDb.parent;
        this.gitDir = refDb.gitDir;
        this.gitCommonDir = refDb.gitCommonDir;
        this.refsDir = refDb.refsDir;
        this.logsDir = refDb.logsDir;
        this.logsRefsDir = refDb.logsRefsDir;
        this.packedRefsFile = refDb.packedRefsFile;
        this.looseRefs.set(refDb.looseRefs.get());
        this.packedRefs.set(refDb.packedRefs.get());
        this.coreConfig = refDb.coreConfig;
        this.inProcessPackedRefsLock = refDb.inProcessPackedRefsLock;
    }

    RefDirectory(FileRepository db) {
        FS fs = db.getFS();
        this.parent = db;
        this.gitDir = db.getDirectory();
        this.gitCommonDir = db.getCommonDirectory();
        this.refsDir = fs.resolve(this.gitCommonDir, "refs/");
        this.logsDir = fs.resolve(this.gitCommonDir, "logs");
        this.logsRefsDir = fs.resolve(this.gitCommonDir, "logs/refs/");
        this.packedRefsFile = fs.resolve(this.gitCommonDir, "packed-refs");
        this.looseRefs.set(RefList.emptyList());
        this.packedRefs.set(NO_PACKED_REFS);
        this.coreConfig = db.getConfig().get(CoreConfig.KEY);
        this.inProcessPackedRefsLock = new ReentrantLock(true);
    }

    Repository getRepository() {
        return this.parent;
    }

    ReflogWriter newLogWriter(boolean force) {
        return new ReflogWriter(this, force);
    }

    public File logFor(String name) {
        if (name.startsWith("refs/")) {
            name = name.substring("refs/".length());
            return new File(this.logsRefsDir, name);
        }
        return new File(this.logsDir, name);
    }

    public SnapshottingRefDirectory createSnapshottingRefDirectory() {
        return new SnapshottingRefDirectory(this);
    }

    @Override
    public void create() throws IOException {
        FileUtils.mkdir(this.refsDir);
        FileUtils.mkdir(new File(this.refsDir, "refs/heads/".substring("refs/".length())));
        FileUtils.mkdir(new File(this.refsDir, "refs/tags/".substring("refs/".length())));
        this.newLogWriter(false).create();
    }

    @Override
    public void close() {
        this.clearReferences();
    }

    private void clearReferences() {
        this.looseRefs.set(RefList.emptyList());
        this.packedRefs.set(NO_PACKED_REFS);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.clearReferences();
    }

    @Override
    public void packRefs(ProgressMonitor pm, PackRefsCommand packRefs) throws IOException {
        String prefix = packRefs.isAll() ? "refs/" : "refs/tags/";
        List<Ref> refs = this.getRefsByPrefix(prefix);
        ArrayList<String> refsToBePacked = new ArrayList<String>(refs.size());
        pm.beginTask(JGitText.get().packRefs, refs.size());
        try {
            for (Ref ref : refs) {
                if (!ref.isSymbolic() && ref.getStorage().isLoose()) {
                    refsToBePacked.add(ref.getName());
                }
                pm.update(1);
            }
            this.pack(refsToBePacked);
        }
        finally {
            pm.endTask();
        }
    }

    @Override
    public boolean isNameConflicting(String name) throws IOException {
        int lastSlash = name.lastIndexOf(47);
        while (lastSlash > 0) {
            String needle = name.substring(0, lastSlash);
            if (this.exactRef(needle) != null) {
                return true;
            }
            lastSlash = name.lastIndexOf(47, lastSlash - 1);
        }
        return !this.getRefsByPrefix(name + "/").isEmpty();
    }

    @Nullable
    private Ref readAndResolve(String name, RefList<Ref> packed) throws IOException {
        try {
            Ref ref = this.readRef(name, packed);
            if (ref != null) {
                ref = this.resolve(ref, 0, null, null, packed);
            }
            return ref;
        }
        catch (IOException e) {
            if (name.contains("/") || !(e.getCause() instanceof InvalidObjectIdException)) {
                throw e;
            }
            return null;
        }
    }

    @Override
    public Ref exactRef(String name) throws IOException {
        try {
            Ref ref = this.readAndResolve(name, this.getPackedRefs());
            return ref;
        }
        finally {
            this.fireRefsChanged();
        }
    }

    @Override
    @NonNull
    public Map<String, Ref> exactRef(String ... refs) throws IOException {
        try {
            PackedRefList packed = this.getPackedRefs();
            HashMap<String, Ref> result = new HashMap<String, Ref>(refs.length);
            String[] stringArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                Ref ref = this.readAndResolve(name, packed);
                if (ref != null) {
                    result.put(name, ref);
                }
                ++n2;
            }
            HashMap<String, Ref> hashMap = result;
            return hashMap;
        }
        finally {
            this.fireRefsChanged();
        }
    }

    @Override
    @Nullable
    public Ref firstExactRef(String ... refs) throws IOException {
        try {
            PackedRefList packed = this.getPackedRefs();
            String[] stringArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                Ref ref = this.readAndResolve(name, packed);
                if (ref != null) {
                    Ref ref2 = ref;
                    return ref2;
                }
                ++n2;
            }
            return null;
        }
        finally {
            this.fireRefsChanged();
        }
    }

    @Override
    public Map<String, Ref> getRefs(String prefix) throws IOException {
        RefList<LooseRef> loose;
        RefList<LooseRef> oldLoose = this.looseRefs.get();
        LooseScanner scan = new LooseScanner(oldLoose);
        scan.scan(prefix);
        PackedRefList packed = this.getPackedRefs();
        if (scan.newLoose != null) {
            scan.newLoose.sort();
            loose = scan.newLoose.toRefList();
            if (this.looseRefs.compareAndSet(oldLoose, loose)) {
                this.modCnt.incrementAndGet();
            }
        } else {
            loose = oldLoose;
        }
        this.fireRefsChanged();
        RefList.Builder<Ref> symbolic = scan.symbolic;
        int idx = 0;
        while (idx < symbolic.size()) {
            Ref symbolicRef = symbolic.get(idx);
            Ref resolvedRef = this.resolve(symbolicRef, 0, prefix, loose, packed);
            if (resolvedRef != null && resolvedRef.getObjectId() != null) {
                symbolic.set(idx, resolvedRef);
                ++idx;
                continue;
            }
            symbolic.remove(idx);
            int toRemove = loose.find(symbolicRef.getName());
            if (toRemove < 0) continue;
            loose = loose.remove(toRemove);
        }
        symbolic.sort();
        return new RefMap(prefix, packed, this.upcast(loose), symbolic.toRefList());
    }

    @Override
    public List<Ref> getRefsByPrefix(String ... prefixes) throws IOException {
        return this.getRefsByPrefix(StringUtils.commonPrefix(prefixes)).parallelStream().filter(ref -> Stream.of(prefixes).anyMatch(ref.getName()::startsWith)).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public List<Ref> getAdditionalRefs() throws IOException {
        ArrayList<Ref> ret = new ArrayList<Ref>();
        String[] stringArray = additionalRefsNames;
        int n = additionalRefsNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Ref r = this.exactRef(name);
            if (r != null) {
                ret.add(r);
            }
            ++n2;
        }
        return ret;
    }

    @Override
    public ReflogReader getReflogReader(Ref ref) throws IOException {
        return new ReflogReaderImpl(this.getRepository(), ref.getName());
    }

    private RefList<Ref> upcast(RefList<? extends Ref> loose) {
        return loose;
    }

    @Override
    public Ref peel(Ref ref) throws IOException {
        RefList<LooseRef> curList;
        int idx;
        Ref leaf = ref.getLeaf();
        if (leaf.isPeeled() || leaf.getObjectId() == null) {
            return ref;
        }
        ObjectIdRef newLeaf = this.doPeel(leaf);
        if (leaf.getStorage().isLoose() && (idx = (curList = this.looseRefs.get()).find(leaf.getName())) >= 0 && curList.get(idx) == leaf) {
            LooseRef asPeeled = ((LooseRef)leaf).peel(newLeaf);
            RefList<LooseRef> newList = curList.set(idx, asPeeled);
            this.looseRefs.compareAndSet(curList, newList);
        }
        return RefDirectory.recreate(ref, newLeaf);
    }

    private ObjectIdRef doPeel(Ref leaf) throws MissingObjectException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (RevWalk rw = new RevWalk(this.getRepository());){
            RevObject obj = rw.parseAny(leaf.getObjectId());
            if (obj instanceof RevTag) {
                return new ObjectIdRef.PeeledTag(leaf.getStorage(), leaf.getName(), leaf.getObjectId(), rw.peel(obj).copy());
            }
            return new ObjectIdRef.PeeledNonTag(leaf.getStorage(), leaf.getName(), leaf.getObjectId());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static Ref recreate(Ref old, ObjectIdRef leaf) {
        if (old.isSymbolic()) {
            Ref dst = RefDirectory.recreate(old.getTarget(), leaf);
            return new SymbolicRef(old.getName(), dst);
        }
        return leaf;
    }

    void storedSymbolicRef(RefDirectoryUpdate u, FileSnapshot snapshot, String target) {
        this.putLooseRef(RefDirectory.newSymbolicRef(snapshot, u.getRef().getName(), target));
        this.fireRefsChanged();
    }

    @Override
    public RefDirectoryUpdate newUpdate(String name, boolean detach) throws IOException {
        boolean detachingSymbolicRef = false;
        PackedRefList packed = this.getPackedRefs();
        Ref ref = this.readRef(name, packed);
        if (ref != null) {
            ref = this.resolve(ref, 0, null, null, packed);
        }
        if (ref == null) {
            ref = new ObjectIdRef.Unpeeled(Ref.Storage.NEW, name, null);
        } else {
            detachingSymbolicRef = detach && ref.isSymbolic();
        }
        RefDirectoryUpdate refDirUpdate = this.createRefDirectoryUpdate(ref);
        if (detachingSymbolicRef) {
            refDirUpdate.setDetachingSymbolicRef();
        }
        return refDirUpdate;
    }

    RefDirectoryUpdate createRefDirectoryUpdate(Ref ref) {
        return new RefDirectoryUpdate(this, ref);
    }

    @Override
    public RefDirectoryRename newRename(String fromName, String toName) throws IOException {
        RefDirectoryUpdate from = this.newUpdate(fromName, false);
        RefDirectoryUpdate to = this.newUpdate(toName, false);
        return this.createRefDirectoryRename(from, to);
    }

    RefDirectoryRename createRefDirectoryRename(RefDirectoryUpdate from, RefDirectoryUpdate to) {
        return new RefDirectoryRename(from, to);
    }

    @Override
    public PackedBatchRefUpdate newBatchUpdate() {
        return new PackedBatchRefUpdate(this);
    }

    public PackedBatchRefUpdate newBatchUpdate(boolean shouldLockLooseRefs) {
        return new PackedBatchRefUpdate(this, shouldLockLooseRefs);
    }

    @Override
    public boolean performsAtomicTransactions() {
        return true;
    }

    void stored(RefDirectoryUpdate update, FileSnapshot snapshot) {
        ObjectId target = update.getNewObjectId().copy();
        Ref leaf = update.getRef().getLeaf();
        this.putLooseRef(new LooseUnpeeled(snapshot, leaf.getName(), target));
    }

    private void putLooseRef(LooseRef ref) {
        RefList<LooseRef> nList;
        RefList<LooseRef> cList;
        while (!this.looseRefs.compareAndSet(cList = this.looseRefs.get(), nList = cList.put(ref))) {
        }
        this.modCnt.incrementAndGet();
        this.fireRefsChanged();
    }

    void delete(RefDirectoryUpdate update) throws IOException {
        Ref dst = update.getRef();
        if (!update.isDetachingSymbolicRef()) {
            dst = dst.getLeaf();
        }
        String name = dst.getName();
        this.inProcessPackedRefsLock.lock();
        try {
            LockFile lck = this.lockPackedRefsOrThrow();
            try {
                RefList<LooseRef> newLoose;
                RefList<LooseRef> curLoose;
                int idx;
                int idx2;
                PackedRefList packed = this.getPackedRefs();
                if (packed.contains(name) && (idx2 = (packed = this.refreshPackedRefs()).find(name)) >= 0) {
                    this.commitPackedRefs(lck, packed.remove(idx2), packed, true);
                }
                while ((idx = (curLoose = this.looseRefs.get()).find(name)) >= 0 && !this.looseRefs.compareAndSet(curLoose, newLoose = curLoose.remove(idx))) {
                }
                int levels = RefDirectory.levelsIn(name) - 2;
                RefDirectory.delete(this.logFor(name), levels);
                if (dst.getStorage().isLoose()) {
                    RefDirectory.deleteAndUnlock(this.fileFor(name), levels, update);
                }
            }
            finally {
                lck.unlock();
            }
        }
        finally {
            this.inProcessPackedRefsLock.unlock();
        }
        this.modCnt.incrementAndGet();
        this.fireRefsChanged();
    }

    public void pack(List<String> refs) throws IOException {
        this.pack(refs, Collections.emptyMap());
    }

    void pack(Map<String, LockFile> heldLocks) throws IOException {
        this.pack(heldLocks.keySet(), heldLocks);
    }

    private void pack(Collection<String> refs, Map<String, LockFile> heldLocks) throws IOException {
        for (LockFile ol : heldLocks.values()) {
            ol.requireLock();
        }
        if (refs.isEmpty()) {
            return;
        }
        FS fs = this.parent.getFS();
        this.inProcessPackedRefsLock.lock();
        try {
            LockFile lck = this.lockPackedRefsOrThrow();
            try {
                PackedRefList oldPacked = this.refreshPackedRefs();
                RefList newPacked = oldPacked;
                boolean dirty = false;
                for (String refName : refs) {
                    Ref newRef;
                    Ref oldRef = this.readRef(refName, newPacked);
                    if (oldRef == null || oldRef.isSymbolic() || (newRef = this.peeledPackedRef(oldRef)) == oldRef) continue;
                    dirty = true;
                    int idx = newPacked.find(refName);
                    newPacked = idx >= 0 ? newPacked.set(idx, newRef) : newPacked.add(idx, newRef);
                }
                if (!dirty) {
                    return;
                }
                this.commitPackedRefs(lck, newPacked, oldPacked, false);
                for (String refName : refs) {
                    boolean shouldUnlock;
                    File refFile = this.fileFor(refName);
                    if (!fs.exists(refFile)) continue;
                    LockFile rLck = heldLocks.get(refName);
                    if (rLck == null) {
                        rLck = new LockFile(refFile);
                        if (!rLck.lock()) continue;
                        shouldUnlock = true;
                    } else {
                        shouldUnlock = false;
                    }
                    try {
                        RefList<LooseRef> newLoose;
                        RefList<LooseRef> curLoose;
                        int idx;
                        LooseRef currentLooseRef = this.scanRef(null, refName);
                        if (currentLooseRef == null || currentLooseRef.isSymbolic()) continue;
                        Object packedRef = newPacked.get(refName);
                        ObjectId clr_oid = currentLooseRef.getObjectId();
                        if (clr_oid == null || packedRef == null || !clr_oid.equals(packedRef.getObjectId())) continue;
                        while ((idx = (curLoose = this.looseRefs.get()).find(refName)) >= 0 && !this.looseRefs.compareAndSet(curLoose, newLoose = curLoose.remove(idx))) {
                        }
                        int levels = RefDirectory.levelsIn(refName) - 2;
                        RefDirectory.deleteAndUnlock(refFile, levels, rLck);
                    }
                    finally {
                        if (shouldUnlock) {
                            rLck.unlock();
                        }
                    }
                }
            }
            finally {
                lck.unlock();
            }
        }
        finally {
            this.inProcessPackedRefsLock.unlock();
        }
    }

    @Nullable
    LockFile lockPackedRefs() throws IOException {
        LockFile lck = new LockFile(this.packedRefsFile);
        for (int ms : this.getRetrySleepMs()) {
            RefDirectory.sleep(ms);
            if (!lck.lock()) continue;
            return lck;
        }
        return null;
    }

    LockFile lockPackedRefsOrThrow() throws IOException {
        LockFile lck = this.lockPackedRefs();
        if (lck == null) {
            throw new LockFailedException(this.packedRefsFile);
        }
        return lck;
    }

    private Ref peeledPackedRef(Ref ref) throws MissingObjectException, IOException {
        ObjectId peeledObjectId;
        if (ref.getStorage().isPacked() && ref.isPeeled()) {
            return ref;
        }
        if (!ref.isPeeled()) {
            ref = this.peel(ref);
        }
        if ((peeledObjectId = ref.getPeeledObjectId()) != null) {
            return new ObjectIdRef.PeeledTag(Ref.Storage.PACKED, ref.getName(), ref.getObjectId(), peeledObjectId);
        }
        return new ObjectIdRef.PeeledNonTag(Ref.Storage.PACKED, ref.getName(), ref.getObjectId());
    }

    void log(boolean force, RefUpdate update, String msg, boolean deref) throws IOException {
        this.newLogWriter(force).log(update, msg, deref);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Ref resolve(Ref ref, int depth, String prefix, RefList<LooseRef> loose, RefList<Ref> packed) throws IOException {
        if (!ref.isSymbolic()) return ref;
        Ref dst = ref.getTarget();
        if (5 <= depth) {
            return null;
        }
        if (loose != null && dst.getName().startsWith(prefix)) {
            int idx = loose.find(dst.getName());
            if (idx >= 0) {
                dst = loose.get(idx);
            } else {
                idx = packed.find(dst.getName());
                if (idx < 0) return ref;
                dst = packed.get(idx);
            }
        } else if ((dst = this.readRef(dst.getName(), packed)) == null) {
            return ref;
        }
        dst = this.resolve(dst, depth + 1, prefix, loose, packed);
        if (dst != null) return new SymbolicRef(ref.getName(), dst);
        return null;
    }

    PackedRefList getPackedRefs() throws IOException {
        PackedRefList curList = this.packedRefs.get();
        switch (this.coreConfig.getTrustPackedRefsStat()) {
            case NEVER: {
                break;
            }
            case AFTER_OPEN: {
                try {
                    Throwable throwable = null;
                    Object var3_4 = null;
                    try {
                        InputStream stream = Files.newInputStream(this.packedRefsFile.toPath(), new OpenOption[0]);
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (FileNotFoundException | NoSuchFileException iOException) {
                    // empty catch block
                }
            }
            case ALWAYS: {
                if (curList.snapshot.isModified(this.packedRefsFile)) break;
                return curList;
            }
        }
        return this.refreshPackedRefs(curList);
    }

    PackedRefList refreshPackedRefs() throws IOException {
        return this.refreshPackedRefs(this.packedRefs.get());
    }

    private PackedRefList refreshPackedRefs(PackedRefList curList) throws IOException {
        PackedRefList newList = this.readPackedRefs();
        if (this.packedRefs.compareAndSet(curList, newList) && !curList.id.equals(newList.id)) {
            this.modCnt.incrementAndGet();
        }
        return newList;
    }

    private PackedRefList readPackedRefs() throws IOException {
        try {
            PackedRefList result = FileUtils.readWithRetries(this.packedRefsFile, f -> {
                FileSnapshot snapshot = FileSnapshot.save(f);
                MessageDigest digest = Constants.newMessageDigest();
                Throwable throwable = null;
                Object var5_6 = null;
                try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new DigestInputStream(new FileInputStream((File)f), digest), StandardCharsets.UTF_8));){
                    return new PackedRefList(this.parsePackedRefs(br), snapshot, ObjectId.fromRaw(digest.digest()));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            });
            return result != null ? result : NO_PACKED_REFS;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(MessageFormat.format(JGitText.get().cannotReadFile, this.packedRefsFile), e);
        }
    }

    void compareAndSetPackedRefs(PackedRefList curList, PackedRefList newList) {
        if (this.packedRefs.compareAndSet(curList, newList) && !curList.id.equals(newList.id)) {
            this.modCnt.incrementAndGet();
        }
    }

    private RefList<Ref> parsePackedRefs(BufferedReader br) throws IOException {
        String p;
        RefList.Builder<Ref> all = new RefList.Builder<Ref>();
        Ref last = null;
        boolean peeled = false;
        boolean needSort = false;
        while ((p = br.readLine()) != null) {
            if (p.charAt(0) == '#') {
                if (!p.startsWith(PACKED_REFS_HEADER)) continue;
                p = p.substring(PACKED_REFS_HEADER.length());
                peeled = p.contains(PACKED_REFS_PEELED);
                continue;
            }
            if (p.charAt(0) == '^') {
                if (last == null) {
                    throw new IOException(JGitText.get().peeledLineBeforeRef);
                }
                ObjectId id = ObjectId.fromString(p.substring(1));
                last = new ObjectIdRef.PeeledTag(Ref.Storage.PACKED, last.getName(), last.getObjectId(), id);
                all.set(all.size() - 1, last);
                continue;
            }
            int sp = p.indexOf(32);
            if (sp < 0) {
                throw new IOException(MessageFormat.format(JGitText.get().packedRefsCorruptionDetected, this.packedRefsFile.getAbsolutePath()));
            }
            ObjectId id = ObjectId.fromString(p.substring(0, sp));
            String name = RefDirectory.copy(p, sp + 1, p.length());
            ObjectIdRef cur = peeled ? new ObjectIdRef.PeeledNonTag(Ref.Storage.PACKED, name, id) : new ObjectIdRef.Unpeeled(Ref.Storage.PACKED, name, id);
            if (last != null && RefComparator.compareTo(last, cur) > 0) {
                needSort = true;
            }
            all.add(cur);
            last = cur;
        }
        if (needSort) {
            all.sort();
        }
        return all.toRefList();
    }

    private static String copy(String src, int off, int end) {
        return new StringBuilder(end - off).append(src, off, end).toString();
    }

    void commitPackedRefs(final LockFile lck, final RefList<Ref> refs, final PackedRefList oldPackedList, final boolean changed) throws IOException {
        new RefWriter(refs){

            @Override
            protected void writeFile(String name, byte[] content) throws IOException {
                lck.setFSync(true);
                lck.setNeedSnapshot(true);
                try {
                    lck.write(content);
                }
                catch (IOException ioe) {
                    throw new ObjectWritingException(MessageFormat.format(JGitText.get().unableToWrite, name), ioe);
                }
                try {
                    lck.waitForStatChange();
                }
                catch (InterruptedException e) {
                    lck.unlock();
                    throw new ObjectWritingException(MessageFormat.format(JGitText.get().interruptedWriting, name), e);
                }
                if (!lck.commit()) {
                    throw new ObjectWritingException(MessageFormat.format(JGitText.get().unableToWrite, name));
                }
                byte[] digest = Constants.newMessageDigest().digest(content);
                PackedRefList newPackedList = new PackedRefList(refs, lck.getCommitSnapshot(), ObjectId.fromRaw(digest));
                RefDirectory.this.packedRefs.compareAndSet(oldPackedList, newPackedList);
                if (changed) {
                    RefDirectory.this.modCnt.incrementAndGet();
                }
            }
        }.writePackedRefs();
    }

    private Ref readRef(String name, RefList<Ref> packed) throws IOException {
        RefList<LooseRef> curList = this.looseRefs.get();
        int idx = curList.find(name);
        if (idx >= 0) {
            LooseRef o = curList.get(idx);
            LooseRef n = this.scanRef(o, name);
            if (n == null) {
                if (this.looseRefs.compareAndSet(curList, curList.remove(idx))) {
                    this.modCnt.incrementAndGet();
                }
                return packed.get(name);
            }
            if (o == n) {
                return n;
            }
            if (this.looseRefs.compareAndSet(curList, curList.set(idx, n))) {
                this.modCnt.incrementAndGet();
            }
            return n;
        }
        LooseRef n = this.scanRef(null, name);
        if (n == null) {
            return packed.get(name);
        }
        String[] stringArray = additionalRefsNames;
        int n2 = additionalRefsNames.length;
        int n3 = 0;
        while (n3 < n2) {
            String additionalRefsName = stringArray[n3];
            if (name.equals(additionalRefsName)) {
                return n;
            }
            ++n3;
        }
        if (this.looseRefs.compareAndSet(curList, curList.add(idx, n))) {
            this.modCnt.incrementAndGet();
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    LooseRef scanRef(LooseRef ref, String name) throws IOException {
        block18: {
            block19: {
                path = this.fileFor(name);
                if (this.coreConfig.getTrustLooseRefStat() == CoreConfig.TrustStat.AFTER_OPEN) {
                    this.refreshPathToLooseRef(Paths.get(name, new String[0]));
                }
                currentSnapshot = null;
                if (ref != null) {
                    currentSnapshot = ref.getSnapShot();
                    if (!currentSnapshot.isModified(path)) {
                        return ref;
                    }
                    name = ref.getName();
                }
                limit = 4096;
                loose = null;
                try {
                    loose = FileUtils.readWithRetries(path, (FileUtils.IOFunction<File, 1LooseItems>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$3(java.io.File ), (Ljava/io/File;)Lcom/xenoterracide/gradle/semver/jgit/internal/storage/file/RefDirectory$1LooseItems;)((RefDirectory)this));
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(MessageFormat.format(JGitText.get().cannotReadFile, new Object[]{path}), e);
                }
                if (loose == null) {
                    return null;
                }
                n = loose.buf.length;
                if (n == 0) {
                    return null;
                }
                if (!RefDirectory.isSymRef(loose.buf, n)) break block19;
                if (n != 4096) ** GOTO lbl28
                return null;
lbl-1000:
                // 1 sources

                {
                    --n;
lbl28:
                    // 2 sources

                    ** while (n > 0 && Character.isWhitespace((int)loose.buf[n - 1]))
                }
lbl29:
                // 1 sources

                if (n < 6) {
                    content = RawParseUtils.decode(loose.buf, 0, n);
                    throw new IOException(MessageFormat.format(JGitText.get().notARef, new Object[]{name, content}));
                }
                target = RawParseUtils.decode(loose.buf, 5, n);
                if (ref != null && ref.isSymbolic() && ref.getTarget().getName().equals(target)) {
                    if (!RefDirectory.$assertionsDisabled && currentSnapshot == null) {
                        throw new AssertionError();
                    }
                    currentSnapshot.setClean(loose.snapshot);
                    return ref;
                }
                return RefDirectory.newSymbolicRef(loose.snapshot, name, target);
            }
            if (n < 40) {
                return null;
            }
            try {
                id = ObjectId.fromString(loose.buf, 0);
                if (ref != null && !ref.isSymbolic() && id.equals(ref.getTarget().getObjectId())) {
                    if (!RefDirectory.$assertionsDisabled && currentSnapshot == null) {
                        throw new AssertionError();
                    }
                    currentSnapshot.setClean(loose.snapshot);
                    return ref;
                }
                break block18;
            }
            catch (IllegalArgumentException notRef) {
                ** while (n > 0 && Character.isWhitespace((int)loose.buf[n - 1]))
            }
lbl-1000:
            // 1 sources

            {
                --n;
                continue;
            }
lbl54:
            // 1 sources

            content = RawParseUtils.decode(loose.buf, 0, n);
            throw new IOException(MessageFormat.format(JGitText.get().notARef, new Object[]{name, content}), notRef);
        }
        return new LooseUnpeeled(loose.snapshot, name, id);
    }

    void refreshPathToLooseRef(Path refPath) {
        int i = 1;
        while (i < refPath.getNameCount()) {
            block8: {
                File dir = this.fileFor(refPath.subpath(0, i).toString());
                try {
                    Throwable throwable = null;
                    Object var5_6 = null;
                    try {
                        InputStream stream = Files.newInputStream(dir.toPath(), new OpenOption[0]);
                        if (stream == null) break block8;
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    break;
                }
            }
            ++i;
        }
    }

    private static boolean isSymRef(byte[] buf, int n) {
        if (n < 6) {
            return false;
        }
        return buf[0] == 114 && buf[1] == 101 && buf[2] == 102 && buf[3] == 58 && buf[4] == 32;
    }

    boolean isInClone() throws IOException {
        return this.hasDanglingHead() && !this.packedRefsFile.exists() && !this.hasLooseRef();
    }

    private boolean hasDanglingHead() throws IOException {
        Ref head = this.exactRef("HEAD");
        if (head != null) {
            ObjectId id = head.getObjectId();
            return id == null || id.equals(ObjectId.zeroId());
        }
        return false;
    }

    private boolean hasLooseRef() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Stream<Path> stream = Files.walk(this.refsDir.toPath(), new FileVisitOption[0]);){
            return stream.anyMatch(path -> Files.isRegularFile(path, new LinkOption[0]));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    void fireRefsChanged() {
        int curr;
        int last = this.lastNotifiedModCnt.get();
        if (last != (curr = this.modCnt.get()) && this.lastNotifiedModCnt.compareAndSet(last, curr) && last != 0) {
            this.parent.fireEvent(new RefsChangedEvent());
        }
    }

    RefDirectoryUpdate newTemporaryUpdate() throws IOException {
        File tmp = File.createTempFile("renamed_", "_ref", this.refsDir);
        String name = "refs/" + tmp.getName();
        ObjectIdRef.Unpeeled ref = new ObjectIdRef.Unpeeled(Ref.Storage.NEW, name, null);
        return this.createRefDirectoryUpdate(ref);
    }

    File fileFor(String name) {
        if (name.startsWith("refs/")) {
            name = name.substring("refs/".length());
            return new File(this.refsDir, name);
        }
        if (name.equals("HEAD")) {
            return new File(this.gitDir, name);
        }
        return new File(this.gitCommonDir, name);
    }

    static int levelsIn(String name) {
        int count = 0;
        int p = name.indexOf(47);
        while (p >= 0) {
            ++count;
            p = name.indexOf(47, p + 1);
        }
        return count;
    }

    static void delete(File file, int depth) throws IOException {
        RefDirectory.delete(file);
        RefDirectory.deleteEmptyParentDirs(file, depth);
    }

    private static void delete(File file) throws IOException {
        if (!file.delete() && file.isFile()) {
            throw new IOException(MessageFormat.format(JGitText.get().fileCannotBeDeleted, file));
        }
    }

    private static void deleteAndUnlock(File file, int depth, RefDirectoryUpdate refUpdate) throws IOException {
        RefDirectory.delete(file);
        if (refUpdate != null) {
            refUpdate.unlock();
        }
        RefDirectory.deleteEmptyParentDirs(file, depth);
    }

    private static void deleteAndUnlock(File file, int depth, LockFile rLck) throws IOException {
        RefDirectory.delete(file);
        if (rLck != null) {
            rLck.unlock();
        }
        RefDirectory.deleteEmptyParentDirs(file, depth);
    }

    private static void deleteEmptyParentDirs(File file, int depth) {
        File dir = file.getParentFile();
        int i = 0;
        while (i < depth) {
            try {
                Files.deleteIfExists(dir.toPath());
            }
            catch (DirectoryNotEmptyException e) {
                break;
            }
            catch (IOException e) {
                LOG.warn(MessageFormat.format(JGitText.get().unableToRemovePath, dir), (Throwable)e);
                break;
            }
            dir = dir.getParentFile();
            ++i;
        }
    }

    Iterable<Integer> getRetrySleepMs() {
        return this.retrySleepMs;
    }

    void setRetrySleepMs(List<Integer> retrySleepMs) {
        if (retrySleepMs == null || retrySleepMs.isEmpty() || retrySleepMs.get(0) != 0) {
            throw new IllegalArgumentException();
        }
        this.retrySleepMs = retrySleepMs;
    }

    static void sleep(long ms) throws InterruptedIOException {
        if (ms <= 0L) {
            return;
        }
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            InterruptedIOException ie = new InterruptedIOException();
            ie.initCause(e);
            throw ie;
        }
    }

    private static LooseSymbolicRef newSymbolicRef(FileSnapshot snapshot, String name, String target) {
        ObjectIdRef.Unpeeled dst = new ObjectIdRef.Unpeeled(Ref.Storage.NEW, target, null);
        return new LooseSymbolicRef(snapshot, name, dst);
    }

    private /* synthetic */ 1LooseItems lambda$3(File f) throws Exception {
        class LooseItems {
            final FileSnapshot snapshot;
            final byte[] buf;

            LooseItems(FileSnapshot snapshot, byte[] buf) {
                this.snapshot = snapshot;
                this.buf = buf;
            }
        }
        return new LooseItems(FileSnapshot.save(f), IO.readSome(f, 4096));
    }

    private static final class LooseNonTag
    extends ObjectIdRef.PeeledNonTag
    implements LooseRef {
        private final FileSnapshot snapShot;

        LooseNonTag(FileSnapshot snapShot, @NonNull String refName, @NonNull ObjectId id) {
            super(Ref.Storage.LOOSE, refName, id);
            this.snapShot = snapShot;
        }

        @Override
        public FileSnapshot getSnapShot() {
            return this.snapShot;
        }

        @Override
        public LooseRef peel(ObjectIdRef newLeaf) {
            return this;
        }
    }

    private static final class LoosePeeledTag
    extends ObjectIdRef.PeeledTag
    implements LooseRef {
        private final FileSnapshot snapShot;

        LoosePeeledTag(FileSnapshot snapShot, @NonNull String refName, @NonNull ObjectId id, @NonNull ObjectId p) {
            super(Ref.Storage.LOOSE, refName, id, p);
            this.snapShot = snapShot;
        }

        @Override
        public FileSnapshot getSnapShot() {
            return this.snapShot;
        }

        @Override
        public LooseRef peel(ObjectIdRef newLeaf) {
            return this;
        }
    }

    private static interface LooseRef
    extends Ref {
        public FileSnapshot getSnapShot();

        public LooseRef peel(ObjectIdRef var1);
    }

    private class LooseScanner {
        private final RefList<LooseRef> curLoose;
        private int curIdx;
        final RefList.Builder<Ref> symbolic = new RefList.Builder(4);
        RefList.Builder<LooseRef> newLoose;

        LooseScanner(RefList<LooseRef> curLoose) {
            this.curLoose = curLoose;
        }

        void scan(String prefix) {
            if ("".equals(prefix)) {
                this.scanOne("HEAD");
                this.scanTree("refs/", RefDirectory.this.refsDir);
                if (this.newLoose == null && this.curIdx < this.curLoose.size()) {
                    this.newLoose = this.curLoose.copy(this.curIdx);
                }
            } else if (prefix.startsWith("refs/") && prefix.endsWith("/")) {
                this.curIdx = -(this.curLoose.find(prefix) + 1);
                File dir = new File(RefDirectory.this.refsDir, prefix.substring("refs/".length()));
                this.scanTree(prefix, dir);
                while (this.curIdx < this.curLoose.size()) {
                    if (!this.curLoose.get(this.curIdx).getName().startsWith(prefix)) break;
                    if (this.newLoose == null) {
                        this.newLoose = this.curLoose.copy(this.curIdx);
                    }
                    ++this.curIdx;
                }
                if (this.newLoose != null) {
                    while (this.curIdx < this.curLoose.size()) {
                        this.newLoose.add(this.curLoose.get(this.curIdx++));
                    }
                }
            }
        }

        private boolean scanTree(String prefix, File dir) {
            Object[] entries = dir.list(LockFile.FILTER);
            if (entries == null) {
                return false;
            }
            if (entries.length > 0) {
                int i = 0;
                while (i < entries.length) {
                    Object e = entries[i];
                    File f = new File(dir, (String)e);
                    if (f.isDirectory()) {
                        int n = i;
                        entries[n] = String.valueOf(entries[n]) + "/";
                    }
                    ++i;
                }
                Arrays.sort(entries);
                Object[] objectArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    Object name = objectArray[n2];
                    if (((String)name).charAt(((String)name).length() - 1) == '/') {
                        this.scanTree(prefix + (String)name, new File(dir, (String)name));
                    } else {
                        this.scanOne(prefix + (String)name);
                    }
                    ++n2;
                }
            }
            return true;
        }

        private void scanOne(String name) {
            LooseRef n;
            LooseRef cur;
            if (this.curIdx < this.curLoose.size()) {
                do {
                    int cmp;
                    if ((cmp = RefComparator.compareTo((Ref)(cur = this.curLoose.get(this.curIdx)), name)) >= 0) {
                        if (cmp > 0) {
                            cur = null;
                        }
                        break;
                    }
                    if (this.newLoose == null) {
                        this.newLoose = this.curLoose.copy(this.curIdx);
                    }
                    ++this.curIdx;
                    cur = null;
                } while (this.curIdx < this.curLoose.size());
            } else {
                cur = null;
            }
            try {
                n = RefDirectory.this.scanRef(cur, name);
            }
            catch (IOException notValid) {
                n = null;
            }
            if (n != null) {
                if (cur != n && this.newLoose == null) {
                    this.newLoose = this.curLoose.copy(this.curIdx);
                }
                if (this.newLoose != null) {
                    this.newLoose.add(n);
                }
                if (n.isSymbolic()) {
                    this.symbolic.add(n);
                }
            } else if (cur != null && this.newLoose == null) {
                this.newLoose = this.curLoose.copy(this.curIdx);
            }
            if (cur != null) {
                ++this.curIdx;
            }
        }
    }

    private static final class LooseSymbolicRef
    extends SymbolicRef
    implements LooseRef {
        private final FileSnapshot snapShot;

        LooseSymbolicRef(FileSnapshot snapShot, @NonNull String refName, @NonNull Ref target) {
            super(refName, target);
            this.snapShot = snapShot;
        }

        @Override
        public FileSnapshot getSnapShot() {
            return this.snapShot;
        }

        @Override
        public LooseRef peel(ObjectIdRef newLeaf) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class LooseUnpeeled
    extends ObjectIdRef.Unpeeled
    implements LooseRef {
        private FileSnapshot snapShot;

        LooseUnpeeled(FileSnapshot snapShot, @NonNull String refName, @NonNull ObjectId id) {
            super(Ref.Storage.LOOSE, refName, id);
            this.snapShot = snapShot;
        }

        @Override
        public FileSnapshot getSnapShot() {
            return this.snapShot;
        }

        @Override
        @NonNull
        public ObjectId getObjectId() {
            ObjectId id = super.getObjectId();
            assert (id != null);
            return id;
        }

        @Override
        public LooseRef peel(ObjectIdRef newLeaf) {
            ObjectId peeledObjectId = newLeaf.getPeeledObjectId();
            ObjectId objectId = this.getObjectId();
            if (peeledObjectId != null) {
                return new LoosePeeledTag(this.snapShot, this.getName(), objectId, peeledObjectId);
            }
            return new LooseNonTag(this.snapShot, this.getName(), objectId);
        }
    }

    static class PackedRefList
    extends RefList<Ref> {
        private final FileSnapshot snapshot;
        private final ObjectId id;

        private PackedRefList(RefList<Ref> src, FileSnapshot s, ObjectId i) {
            super(src);
            this.snapshot = s;
            this.id = i;
        }
    }
}

