/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.internal.storage.file;

import com.xenoterracide.gradle.semver.jgit.annotations.Nullable;
import com.xenoterracide.gradle.semver.jgit.api.errors.GitAPIException;
import com.xenoterracide.gradle.semver.jgit.api.errors.JGitInternalException;
import com.xenoterracide.gradle.semver.jgit.attributes.AttributesNode;
import com.xenoterracide.gradle.semver.jgit.attributes.AttributesNodeProvider;
import com.xenoterracide.gradle.semver.jgit.errors.ConfigInvalidException;
import com.xenoterracide.gradle.semver.jgit.events.IndexChangedEvent;
import com.xenoterracide.gradle.semver.jgit.internal.JGitText;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.FileReftableDatabase;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.FileSnapshot;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.GC;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.GlobalAttributesNode;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.InfoAttributesNode;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.LockFile;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.ObjectDirectory;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.RefDirectory;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.ReflogWriter;
import com.xenoterracide.gradle.semver.jgit.lib.BaseRepositoryBuilder;
import com.xenoterracide.gradle.semver.jgit.lib.BatchRefUpdate;
import com.xenoterracide.gradle.semver.jgit.lib.Constants;
import com.xenoterracide.gradle.semver.jgit.lib.CoreConfig;
import com.xenoterracide.gradle.semver.jgit.lib.NullProgressMonitor;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.ProgressMonitor;
import com.xenoterracide.gradle.semver.jgit.lib.Ref;
import com.xenoterracide.gradle.semver.jgit.lib.RefDatabase;
import com.xenoterracide.gradle.semver.jgit.lib.RefUpdate;
import com.xenoterracide.gradle.semver.jgit.lib.ReflogEntry;
import com.xenoterracide.gradle.semver.jgit.lib.ReflogReader;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import com.xenoterracide.gradle.semver.jgit.lib.StoredConfig;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevWalk;
import com.xenoterracide.gradle.semver.jgit.storage.file.FileBasedConfig;
import com.xenoterracide.gradle.semver.jgit.storage.file.FileRepositoryBuilder;
import com.xenoterracide.gradle.semver.jgit.transport.ReceiveCommand;
import com.xenoterracide.gradle.semver.jgit.util.FileUtils;
import com.xenoterracide.gradle.semver.jgit.util.IO;
import com.xenoterracide.gradle.semver.jgit.util.RawParseUtils;
import com.xenoterracide.gradle.semver.jgit.util.StringUtils;
import com.xenoterracide.gradle.semver.jgit.util.SystemReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRepository
extends Repository {
    private static final Logger LOG = LoggerFactory.getLogger(FileRepository.class);
    private static final String UNNAMED = "Unnamed repository; edit this file to name it for gitweb.";
    private final FileBasedConfig repoConfig;
    private RefDatabase refs;
    private final ObjectDirectory objectDatabase;
    private final Object snapshotLock = new Object();
    private FileSnapshot snapshot;

    public FileRepository(File gitDir) throws IOException {
        this((BaseRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(gitDir)).setup());
    }

    public FileRepository(String gitDir) throws IOException {
        this(new File(gitDir));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileRepository(BaseRepositoryBuilder options) throws IOException {
        super(options);
        StoredConfig userConfig = null;
        try {
            userConfig = SystemReader.getInstance().getUserConfig();
        }
        catch (ConfigInvalidException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new IOException(e.getMessage(), e);
        }
        this.repoConfig = new FileBasedConfig(userConfig, this.getFS().resolve(this.getCommonDirectory(), "config"), this.getFS());
        this.loadRepoConfig();
        this.repoConfig.addChangeListener(this::fireEvent);
        long repositoryFormatVersion = this.getConfig().getLong("core", null, "repositoryformatversion", 0L);
        String reftype = this.repoConfig.getString("extensions", null, "refStorage");
        if (repositoryFormatVersion >= 1L && reftype != null) {
            if (!StringUtils.equalsIgnoreCase(reftype, "reftable")) throw new IOException(JGitText.get().unknownRepositoryFormat);
            this.refs = new FileReftableDatabase(this);
        } else {
            this.refs = new RefDirectory(this);
        }
        this.objectDatabase = new ObjectDirectory(this.repoConfig, options.getObjectDirectory(), options.getAlternateObjectDirectories(), this.getFS(), new File(this.getCommonDirectory(), "shallow"));
        if (this.objectDatabase.exists() && repositoryFormatVersion > 1L) {
            throw new IOException(MessageFormat.format(JGitText.get().unknownRepositoryFormat2, repositoryFormatVersion));
        }
        if (this.isBare()) return;
        this.snapshot = FileSnapshot.save(this.getIndexFile());
    }

    private void loadRepoConfig() throws IOException {
        try {
            this.repoConfig.load();
        }
        catch (ConfigInvalidException e) {
            throw new IOException(JGitText.get().unknownRepositoryFormat, e);
        }
    }

    private String getRelativeDir(File base, File other) {
        File relPath;
        try {
            relPath = base.toPath().relativize(other.toPath()).toFile();
        }
        catch (IllegalArgumentException e) {
            relPath = other;
        }
        return FileUtils.pathToString(relPath);
    }

    @Override
    public void create(boolean bare) throws IOException {
        this.create(bare, false);
    }

    public void create(boolean bare, boolean relativePaths) throws IOException {
        boolean fileMode;
        FileBasedConfig cfg = this.getConfig();
        if (cfg.getFile().exists()) {
            throw new IllegalStateException(MessageFormat.format(JGitText.get().repositoryAlreadyExists, this.getDirectory()));
        }
        FileUtils.mkdirs(this.getDirectory(), true);
        CoreConfig.HideDotFiles hideDotFiles = this.getConfig().getEnum("core", null, "hidedotfiles", CoreConfig.HideDotFiles.DOTGITONLY);
        if (hideDotFiles != CoreConfig.HideDotFiles.FALSE && !this.isBare() && this.getDirectory().getName().startsWith(".")) {
            this.getFS().setHidden(this.getDirectory(), true);
        }
        this.refs.create();
        this.objectDatabase.create();
        FileUtils.mkdir(new File(this.getDirectory(), "branches"));
        FileUtils.mkdir(new File(this.getDirectory(), "hooks"));
        RefUpdate head = this.updateRef("HEAD");
        head.disableRefLog();
        head.link("refs/heads/" + this.getInitialBranch());
        if (this.getFS().supportsExecute()) {
            File tmp = File.createTempFile("try", "execute", this.getDirectory());
            this.getFS().setExecute(tmp, true);
            boolean on = this.getFS().canExecute(tmp);
            this.getFS().setExecute(tmp, false);
            boolean off = this.getFS().canExecute(tmp);
            FileUtils.delete(tmp);
            fileMode = on && !off;
        } else {
            fileMode = false;
        }
        CoreConfig.SymLinks symLinks = CoreConfig.SymLinks.FALSE;
        if (this.getFS().supportsSymlinks()) {
            File tmp = new File(this.getDirectory(), "tmplink");
            try {
                this.getFS().createSymLink(tmp, "target");
                symLinks = null;
                FileUtils.delete(tmp);
            }
            catch (IOException off) {
                // empty catch block
            }
        }
        if (symLinks != null) {
            cfg.setString("core", null, "symlinks", symLinks.name().toLowerCase(Locale.ROOT));
        }
        cfg.setInt("core", null, "repositoryformatversion", 0);
        cfg.setBoolean("core", null, "filemode", fileMode);
        if (bare) {
            cfg.setBoolean("core", null, "bare", true);
        }
        cfg.setBoolean("core", null, "logallrefupdates", !bare);
        if (SystemReader.getInstance().isMacOS()) {
            cfg.setBoolean("core", null, "precomposeunicode", true);
        }
        if (!bare) {
            File workTree = this.getWorkTree();
            if (!this.getDirectory().getParentFile().equals(workTree)) {
                String gitDirPath;
                String workTreePath;
                if (relativePaths) {
                    File canonGitDir = this.getDirectory().getCanonicalFile();
                    File canonWorkTree = this.getWorkTree().getCanonicalFile();
                    workTreePath = this.getRelativeDir(canonGitDir, canonWorkTree);
                    gitDirPath = this.getRelativeDir(canonWorkTree, canonGitDir);
                } else {
                    workTreePath = this.getWorkTree().getAbsolutePath();
                    gitDirPath = this.getDirectory().getAbsolutePath();
                }
                cfg.setString("core", null, "worktree", workTreePath);
                LockFile dotGitLockFile = new LockFile(new File(workTree, ".git"));
                try {
                    if (dotGitLockFile.lock()) {
                        dotGitLockFile.write(Constants.encode("gitdir: " + gitDirPath));
                        dotGitLockFile.commit();
                    }
                }
                finally {
                    dotGitLockFile.unlock();
                }
            }
        }
        cfg.save();
    }

    public File getObjectsDirectory() {
        return this.objectDatabase.getDirectory();
    }

    @Override
    public ObjectDirectory getObjectDatabase() {
        return this.objectDatabase;
    }

    @Override
    public RefDatabase getRefDatabase() {
        return this.refs;
    }

    @Override
    public String getIdentifier() {
        File directory = this.getDirectory();
        if (directory != null) {
            return directory.getPath();
        }
        throw new IllegalStateException();
    }

    @Override
    public FileBasedConfig getConfig() {
        try {
            SystemReader.getInstance().getUserConfig();
            if (this.repoConfig.isOutdated()) {
                this.loadRepoConfig();
            }
        }
        catch (ConfigInvalidException | IOException e) {
            throw new RuntimeException(e);
        }
        return this.repoConfig;
    }

    @Override
    @Nullable
    public String getGitwebDescription() throws IOException {
        String d;
        try {
            d = RawParseUtils.decode(IO.readFully(this.descriptionFile()));
        }
        catch (FileNotFoundException err) {
            return null;
        }
        if (d != null && ((d = d.trim()).isEmpty() || UNNAMED.equals(d))) {
            return null;
        }
        return d;
    }

    @Override
    public void setGitwebDescription(@Nullable String description) throws IOException {
        String old = this.getGitwebDescription();
        if (Objects.equals(old, description)) {
            return;
        }
        File path = this.descriptionFile();
        LockFile lock = new LockFile(path);
        if (!lock.lock()) {
            throw new IOException(MessageFormat.format(JGitText.get().lockError, path.getAbsolutePath()));
        }
        try {
            Object d = description;
            if (d != null) {
                if (!((String)(d = ((String)d).trim())).isEmpty()) {
                    d = (String)d + "\n";
                }
            } else {
                d = "";
            }
            lock.write(Constants.encode((String)d));
            lock.commit();
        }
        finally {
            lock.unlock();
        }
    }

    private File descriptionFile() {
        return new File(this.getDirectory(), "description");
    }

    @Override
    public Set<ObjectId> getAdditionalHaves() throws IOException {
        return this.getAdditionalHaves(null);
    }

    private Set<ObjectId> getAdditionalHaves(Set<ObjectDirectory.AlternateHandle.Id> skips) throws IOException {
        HashSet<ObjectId> r = new HashSet<ObjectId>();
        skips = this.objectDatabase.addMe(skips);
        ObjectDirectory.AlternateHandle[] alternateHandleArray = this.objectDatabase.myAlternates();
        int n = alternateHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectDirectory.AlternateHandle d = alternateHandleArray[n2];
            if (d instanceof ObjectDirectory.AlternateRepository && !skips.contains(d.getId())) {
                FileRepository repo = ((ObjectDirectory.AlternateRepository)d).repository;
                for (Ref ref : repo.getRefDatabase().getRefs()) {
                    if (ref.getObjectId() != null) {
                        r.add(ref.getObjectId());
                    }
                    if (ref.getPeeledObjectId() == null) continue;
                    r.add(ref.getPeeledObjectId());
                }
                r.addAll(repo.getAdditionalHaves(skips));
            }
            ++n2;
        }
        return r;
    }

    public void openPack(File pack) throws IOException {
        this.objectDatabase.openPack(pack);
    }

    @Override
    public void scanForRepoChanges() throws IOException {
        this.getRefDatabase().getRefs();
        this.detectIndexChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detectIndexChanges() {
        if (this.isBare()) {
            return;
        }
        File indexFile = this.getIndexFile();
        Object object = this.snapshotLock;
        synchronized (object) {
            if (this.snapshot == null) {
                this.snapshot = FileSnapshot.save(indexFile);
                return;
            }
            if (!this.snapshot.isModified(indexFile)) {
                return;
            }
        }
        this.notifyIndexChanged(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyIndexChanged(boolean internal) {
        Object object = this.snapshotLock;
        synchronized (object) {
            this.snapshot = FileSnapshot.save(this.getIndexFile());
        }
        this.fireEvent(new IndexChangedEvent(internal));
    }

    @Override
    public AttributesNodeProvider createAttributesNodeProvider() {
        return new AttributesNodeProviderImpl(this);
    }

    private boolean shouldAutoDetach() {
        return this.getConfig().getBoolean("gc", "autoDetach", true);
    }

    @Override
    public void autoGC(ProgressMonitor monitor) {
        GC gc = new GC(this);
        gc.setProgressMonitor(monitor);
        gc.setAuto(true);
        gc.setBackground(this.shouldAutoDetach());
        try {
            gc.gc();
        }
        catch (GitAPIException | IOException | ParseException e) {
            throw new JGitInternalException(JGitText.get().gcFailed, e);
        }
    }

    /*
     * WARNING - void declaration
     */
    void convertToPackedRefs(boolean writeLogs, boolean backup) throws IOException {
        File commonDirectory = this.getCommonDirectory();
        List<Ref> all = this.refs.getRefs();
        File packedRefs = new File(commonDirectory, "packed-refs");
        if (packedRefs.exists()) {
            throw new IOException(MessageFormat.format(JGitText.get().fileAlreadyExists, packedRefs.getName()));
        }
        File refsFile = new File(commonDirectory, "refs");
        File refsHeadsFile = new File(refsFile, "heads");
        File headFile = new File(commonDirectory, "HEAD");
        FileReftableDatabase oldDb = (FileReftableDatabase)this.refs;
        refsHeadsFile.delete();
        refsFile.delete();
        headFile.delete();
        RefDirectory refDir = new RefDirectory(this);
        this.refs = refDir;
        this.refs.create();
        ReflogWriter logWriter = refDir.newLogWriter(true);
        ArrayList<Ref> symrefs = new ArrayList<Ref>();
        BatchRefUpdate bru = this.refs.newBatchUpdate();
        for (Ref ref : all) {
            if (ref.isSymbolic()) {
                symrefs.add(ref);
            } else {
                bru.addCommand(new ReceiveCommand(ObjectId.zeroId(), ref.getObjectId(), ref.getName()));
            }
            if (!writeLogs) continue;
            ReflogReader reflogReader = oldDb.getReflogReader(ref);
            List<ReflogEntry> logs = reflogReader.getReverseEntries();
            Collections.reverse(logs);
            for (ReflogEntry e : logs) {
                logWriter.log(ref.getName(), e);
            }
        }
        Throwable throwable = null;
        Iterator<Ref> iterator = null;
        try (RevWalk rw = new RevWalk(this);){
            bru.execute(rw, NullProgressMonitor.INSTANCE);
        }
        catch (Throwable throwable2) {
            void var14_20;
            if (throwable == null) {
                Throwable throwable3 = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw var14_20;
        }
        oldDb.close();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ReceiveCommand cmd : bru.getCommands()) {
            if (cmd.getResult() == ReceiveCommand.Result.OK) continue;
            arrayList.add(cmd.getRefName() + ": " + String.valueOf((Object)cmd.getResult()));
        }
        if (!arrayList.isEmpty()) {
            throw new IOException(String.format("%s: %s", JGitText.get().failedToConvert, StringUtils.join(arrayList, ", ")));
        }
        for (Ref s : symrefs) {
            RefUpdate up = this.refs.newUpdate(s.getName(), false);
            up.setForceUpdate(true);
            RefUpdate.Result res = up.link(s.getTarget().getName());
            if (res == RefUpdate.Result.NEW || res == RefUpdate.Result.NO_CHANGE) continue;
            throw new IOException(String.format("ref %s: %s", new Object[]{s.getName(), res}));
        }
        if (!backup) {
            File reftableDir = new File(commonDirectory, "reftable");
            FileUtils.delete(reftableDir, 9);
        }
        this.repoConfig.unset("extensions", null, "refStorage");
        this.repoConfig.setLong("core", null, "repositoryformatversion", 0L);
        this.repoConfig.save();
    }

    void convertToReftable(boolean writeLogs, boolean backup) throws IOException {
        File commonDirectory = this.getCommonDirectory();
        File directory = this.getDirectory();
        File reftableDir = new File(commonDirectory, "reftable");
        File headFile = new File(directory, "HEAD");
        if (reftableDir.exists() && FileUtils.hasFiles(reftableDir.toPath())) {
            throw new IOException(JGitText.get().reftableDirExists);
        }
        FileReftableDatabase.convertFrom(this, writeLogs);
        File refsFile = new File(commonDirectory, "refs");
        File packedRefs = new File(commonDirectory, "packed-refs");
        File logsDir = new File(commonDirectory, "logs");
        List additional = this.getRefDatabase().getAdditionalRefs().stream().map(Ref::getName).collect(Collectors.toList());
        additional.add("HEAD");
        if (backup) {
            FileUtils.rename(refsFile, new File(commonDirectory, "refs.old"));
            if (packedRefs.exists()) {
                FileUtils.rename(packedRefs, new File(commonDirectory, "packed-refs.old"));
            }
            if (logsDir.exists()) {
                FileUtils.rename(logsDir, new File(commonDirectory, "logs.old"));
            }
            for (String r : additional) {
                FileUtils.rename(new File(commonDirectory, r), new File(commonDirectory, r + ".old"));
            }
        } else {
            FileUtils.delete(packedRefs, 4);
            FileUtils.delete(headFile, 4);
            FileUtils.delete(logsDir, 5);
            FileUtils.delete(refsFile, 5);
            for (String r : additional) {
                new File(commonDirectory, r).delete();
            }
        }
        FileUtils.mkdir(refsFile, true);
        Throwable throwable = null;
        Iterator iterator = null;
        try (FileOutputStream os = new FileOutputStream(headFile);){
            ((OutputStream)os).write(Constants.encodeASCII("ref: refs/heads/.invalid"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        FileUtils.createNewFile(new File(refsFile, "heads"));
        this.repoConfig.setString("extensions", null, "refStorage", "reftable");
        this.repoConfig.setLong("core", null, "repositoryformatversion", 1L);
        this.repoConfig.save();
        this.refs.close();
        this.refs = new FileReftableDatabase(this);
    }

    public void convertRefStorage(String format, boolean writeLogs, boolean backup) throws IOException {
        if (format.equals("reftable")) {
            if (this.refs instanceof RefDirectory) {
                this.convertToReftable(writeLogs, backup);
            }
        } else if (format.equals("refdir")) {
            if (this.refs instanceof FileReftableDatabase) {
                this.convertToPackedRefs(writeLogs, backup);
            }
        } else {
            throw new IOException(MessageFormat.format(JGitText.get().unknownRefStorageFormat, format));
        }
    }

    static class AttributesNodeProviderImpl
    implements AttributesNodeProvider {
        private AttributesNode infoAttributesNode;
        private AttributesNode globalAttributesNode;

        protected AttributesNodeProviderImpl(Repository repo) {
            this.infoAttributesNode = new InfoAttributesNode(repo);
            this.globalAttributesNode = new GlobalAttributesNode(repo);
        }

        @Override
        public AttributesNode getInfoAttributesNode() throws IOException {
            if (this.infoAttributesNode instanceof InfoAttributesNode) {
                this.infoAttributesNode = ((InfoAttributesNode)this.infoAttributesNode).load();
            }
            return this.infoAttributesNode;
        }

        @Override
        public AttributesNode getGlobalAttributesNode() throws IOException {
            if (this.globalAttributesNode instanceof GlobalAttributesNode) {
                this.globalAttributesNode = ((GlobalAttributesNode)this.globalAttributesNode).load();
            }
            return this.globalAttributesNode;
        }

        static void loadRulesFromFile(AttributesNode r, File attrs) throws FileNotFoundException, IOException {
            if (attrs.exists()) {
                Throwable throwable = null;
                Object var3_4 = null;
                try (FileInputStream in = new FileInputStream(attrs);){
                    r.parse(in);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
    }
}

