/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.internal.diff;

import com.xenoterracide.gradle.semver.jgit.diff.DiffEntry;
import com.xenoterracide.gradle.semver.jgit.diff.RenameDetector;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import com.xenoterracide.gradle.semver.jgit.treewalk.filter.PathFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class FilteredRenameDetector {
    private final RenameDetector renameDetector;

    public FilteredRenameDetector(Repository repository) {
        this(new RenameDetector(repository));
    }

    public FilteredRenameDetector(RenameDetector renameDetector) {
        this.renameDetector = renameDetector;
    }

    public List<DiffEntry> compute(List<DiffEntry> diffs, PathFilter pathFilter) throws IOException {
        return this.compute(diffs, Arrays.asList(pathFilter));
    }

    public List<DiffEntry> compute(List<DiffEntry> changes, List<PathFilter> pathFilters) throws IOException {
        if (pathFilters == null) {
            throw new IllegalArgumentException("Must specify path filters");
        }
        HashSet<String> paths = new HashSet<String>(pathFilters.size());
        for (PathFilter pathFilter : pathFilters) {
            paths.add(pathFilter.getPath());
        }
        ArrayList<DiffEntry> filtered = new ArrayList<DiffEntry>();
        for (DiffEntry diff : changes) {
            Object changeType = diff.getChangeType();
            if (changeType == DiffEntry.ChangeType.ADD && !paths.contains(diff.getNewPath())) continue;
            filtered.add(diff);
        }
        this.renameDetector.reset();
        this.renameDetector.addAll(filtered);
        List<DiffEntry> sourceChanges = this.renameDetector.compute();
        filtered.clear();
        for (DiffEntry diff : changes) {
            DiffEntry.ChangeType changeType = diff.getChangeType();
            if (changeType == DiffEntry.ChangeType.DELETE && !paths.contains(diff.getOldPath())) continue;
            filtered.add(diff);
        }
        this.renameDetector.reset();
        this.renameDetector.addAll(filtered);
        List<DiffEntry> targetChanges = this.renameDetector.compute();
        ArrayList<DiffEntry> result = new ArrayList<DiffEntry>();
        for (DiffEntry sourceChange : sourceChanges) {
            if (!paths.contains(sourceChange.getNewPath())) continue;
            result.add(sourceChange);
        }
        for (DiffEntry targetChange : targetChanges) {
            if (!paths.contains(targetChange.getOldPath())) continue;
            result.add(targetChange);
        }
        this.renameDetector.reset();
        return result;
    }
}

