/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.attributes;

import com.xenoterracide.gradle.semver.jgit.attributes.FilterCommand;
import com.xenoterracide.gradle.semver.jgit.attributes.FilterCommandFactory;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class FilterCommandRegistry {
    private static Map<String, FilterCommandFactory> filterCommandRegistry = new ConcurrentHashMap<String, FilterCommandFactory>();

    public static FilterCommandFactory register(String filterCommandName, FilterCommandFactory factory) {
        return filterCommandRegistry.put(filterCommandName, factory);
    }

    public static FilterCommandFactory unregister(String filterCommandName) {
        return filterCommandRegistry.remove(filterCommandName);
    }

    public static boolean isRegistered(String filterCommandName) {
        return filterCommandRegistry.containsKey(filterCommandName);
    }

    public static Set<String> getRegisteredFilterCommands() {
        return filterCommandRegistry.keySet();
    }

    public static FilterCommand createFilterCommand(String filterCommandName, Repository db, InputStream in, OutputStream out) throws IOException {
        FilterCommandFactory cf = filterCommandRegistry.get(filterCommandName);
        return cf == null ? null : cf.create(db, in, out);
    }
}

