/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.attributes;

import com.xenoterracide.gradle.semver.jgit.attributes.AttributesRule;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AttributesNode {
    private final List<AttributesRule> rules;

    public AttributesNode() {
        this.rules = new ArrayList<AttributesRule>();
    }

    public AttributesNode(List<AttributesRule> rules) {
        this.rules = rules;
    }

    public void parse(InputStream in) throws IOException {
        String txt;
        BufferedReader br = AttributesNode.asReader(in);
        while ((txt = br.readLine()) != null) {
            if ((txt = txt.trim()).length() <= 0 || txt.startsWith("#") || txt.startsWith("!")) continue;
            int patternEndSpace = txt.indexOf(32);
            int patternEndTab = txt.indexOf(9);
            int patternEnd = patternEndSpace == -1 ? patternEndTab : (patternEndTab == -1 ? patternEndSpace : Math.min(patternEndSpace, patternEndTab));
            if (patternEnd <= -1) continue;
            this.rules.add(new AttributesRule(txt.substring(0, patternEnd), txt.substring(patternEnd + 1).trim()));
        }
    }

    private static BufferedReader asReader(InputStream in) {
        return new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
    }

    public List<AttributesRule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }
}

