/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.api;

import com.xenoterracide.gradle.semver.jgit.api.GitCommand;
import com.xenoterracide.gradle.semver.jgit.api.errors.GitAPIException;
import com.xenoterracide.gradle.semver.jgit.api.errors.JGitInternalException;
import com.xenoterracide.gradle.semver.jgit.lib.Ref;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import com.xenoterracide.gradle.semver.jgit.notes.Note;
import com.xenoterracide.gradle.semver.jgit.notes.NoteMap;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevCommit;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevObject;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevWalk;
import java.io.IOException;

public class ShowNoteCommand
extends GitCommand<Note> {
    private RevObject id;
    private String notesRef = "refs/notes/commits";

    protected ShowNoteCommand(Repository repo) {
        super(repo);
    }

    @Override
    public Note call() throws GitAPIException {
        this.checkCallable();
        NoteMap map = NoteMap.newEmptyMap();
        RevCommit notesCommit = null;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (RevWalk walk = new RevWalk(this.repo);){
                Ref ref = this.repo.exactRef(this.notesRef);
                if (ref != null) {
                    notesCommit = walk.parseCommit(ref.getObjectId());
                    map = NoteMap.read(walk.getObjectReader(), notesCommit);
                }
                return map.getNote(this.id);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    public ShowNoteCommand setObjectId(RevObject id) {
        this.checkCallable();
        this.id = id;
        return this;
    }

    public ShowNoteCommand setNotesRef(String notesRef) {
        this.checkCallable();
        this.notesRef = notesRef;
        return this;
    }
}

