/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.git;

import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Project;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.jspecify.annotations.Nullable;

public final class ProvidedFactory {
    private final ObjectFactory objectFactory;
    private final ProviderFactory providerFactory;

    public ProvidedFactory(Project project) {
        this(project.getObjects(), project.getProviders());
    }

    private ProvidedFactory(ObjectFactory objectFactory, ProviderFactory providerFactory) {
        this.objectFactory = objectFactory;
        this.providerFactory = providerFactory;
    }

    public Provider<@Nullable String> providedString(Callable<@Nullable String> callable) {
        return this.provided(callable, String.class);
    }

    public Provider<String> providedString(Provider<String> callable) {
        return this.provided(callable, String.class);
    }

    public Provider<Long> providedLong(Provider<Long> callable) {
        return this.provided(callable, Long.class);
    }

    public <E> Provider<List<E>> providedList(Provider<List<E>> callable, Class<E> type) {
        ListProperty prop = this.objectFactory.listProperty(type);
        prop.set(callable);
        prop.finalizeValueOnRead();
        prop.disallowChanges();
        return prop;
    }

    public <T> Provider<T> provided(Callable<@Nullable T> callable, Class<T> type) {
        return this.provided(this.providerFactory.provider(callable), type);
    }

    public <T> Provider<T> provided(Provider<@Nullable T> provider, Class<T> type) {
        Property prop = this.objectFactory.property(type);
        prop.set(provider);
        prop.finalizeValueOnRead();
        prop.disallowChanges();
        return prop;
    }

    public Property<Boolean> propertyBoolean() {
        return this.property(Boolean.class);
    }

    public Property<@Nullable String> propertyString() {
        return this.property(String.class);
    }

    public <T> Property<T> property(Class<T> type) {
        Property prop = this.objectFactory.property(type);
        prop.finalizeValueOnRead();
        return prop;
    }
}

