/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.git;

import com.xenoterracide.gradle.git.DistanceCalculator;
import com.xenoterracide.gradle.git.GitMetadata;
import com.xenoterracide.gradle.git.GitRemote;
import com.xenoterracide.gradle.git.GitStatus;
import com.xenoterracide.gradle.git.IterableTools;
import com.xenoterracide.gradle.git.TryGit;
import com.xenoterracide.gradle.semver.jgit.api.Git;
import com.xenoterracide.gradle.semver.jgit.api.errors.RefNotFoundException;
import com.xenoterracide.gradle.semver.jgit.errors.RepositoryNotFoundException;
import com.xenoterracide.gradle.semver.jgit.lib.AbbreviatedObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.AnyObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.Ref;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import com.xenoterracide.gradle.semver.jgit.transport.RemoteConfig;
import com.xenoterracide.tools.java.function.ExceptionTools;
import io.vavr.API;
import io.vavr.CheckedFunction1;
import io.vavr.Predicates;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitMetadataImpl
implements GitMetadata {
    private static final String VERSION_GLOB = "v[0-9]*.[0-9]*.[0-9]*";
    private static final String GIT_SEPARATOR = "/";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TryGit git;

    GitMetadataImpl(TryGit git) {
        this.git = git;
    }

    static <T> Function<? super Throwable, ? extends T> allWith(@Nullable T value) {
        return e -> API.Match((Object)e).option(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(RefNotFoundException.class)), (Object)value), API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(RepositoryNotFoundException.class)), (Object)value)}).getOrElseThrow(() -> ExceptionTools.toRuntime(e));
    }

    Try<Repository> gitRepository() {
        return Try.of(this.git::get).filter(Objects::nonNull).map(Git::getRepository).onFailure(e -> this.log.error("failed to get repository", e));
    }

    @Override
    public @Nullable String branch() {
        return (String)this.gitRepository().mapTry(Repository::getBranch).recover(NoSuchElementException.class, e -> null).getOrNull();
    }

    Try<ObjectId> getObjectIdFor(@NonNull String shalike) {
        return this.gitRepository().mapTry((CheckedFunction1 & Serializable)r -> r.resolve(Objects.requireNonNull(shalike)));
    }

    @Nullable String getRev(@NonNull String shalike) {
        return (String)this.getObjectIdFor(shalike).map(AnyObjectId::getName).getOrNull();
    }

    @Override
    public @Nullable String uniqueShort() {
        return (String)this.gitRepository().mapTry(Repository::newObjectReader).mapTry((CheckedFunction1 & Serializable)reader -> reader.abbreviate((AnyObjectId)this.getObjectIdFor("HEAD").get())).map(AbbreviatedObjectId::name).recover(NoSuchElementException.class, e -> null).onFailure(e -> this.log.error("failed to get unique short", e)).getOrNull();
    }

    @Override
    public @Nullable String tag() {
        return (String)this.git.tryCommand((CheckedFunction1 & Serializable)g -> g.describe().setMatch(VERSION_GLOB).setAbbrev(0)).recover(NoSuchElementException.class, e -> null).recover(GitMetadataImpl.allWith(null)).onFailure(e -> this.log.error("failed to get tag", e)).getOrNull();
    }

    long shortCount() {
        return (Long)this.git.tryCommand((CheckedFunction1 & Serializable)git -> git.log().setMaxCount(5)).map(IterableTools::of).map(Stream::count).getOrElse((Object)0L);
    }

    @Override
    public long distance() {
        long shortCount = this.shortCount();
        if (shortCount < 4L) {
            this.log.warn("shallow clone detected! git only has {} commits", (Object)shortCount);
        }
        return new DistanceCalculator(this.git).apply("HEAD");
    }

    @Override
    public GitStatus status() {
        return (GitStatus)((Object)this.git.tryCommand(Git::status).filter(Objects::nonNull).map(status -> status.isClean() ? GitStatus.CLEAN : GitStatus.DIRTY).recover(NoSuchElementException.class, e -> GitStatus.NO_REPO).recover(RepositoryNotFoundException.class, e -> GitStatus.NO_REPO).onFailure(e -> this.log.error("failed to get status", e)).getOrElseThrow(ExceptionTools::toRuntime));
    }

    @Override
    public @Nullable String commit() {
        return this.getRev("HEAD");
    }

    @Override
    public List<GitRemote> remotes() {
        return (List)this.git.tryCommand(Git::remoteList).map(Collection::stream).map(s -> s.map(RemoteConfig::getName)).map(s -> s.filter(Objects::nonNull)).map(s -> s.map(name -> RemoteImpl.nullCheck(name, this.headBranch((String)name)))).map(s -> s.collect(Collectors.toList())).onFailure(e -> this.log.error("failed to get remotes", e)).getOrElse(ArrayList::new);
    }

    @Nullable String headBranch(String remote) {
        String remoteRef = "refs/remotes/" + remote + "/HEAD";
        return (String)this.gitRepository().mapTry((CheckedFunction1 & Serializable)r -> r.findRef(remoteRef)).filter(Objects::nonNull).filter(Ref::isSymbolic).map(Ref::getLeaf).map(Ref::getName).recover(NoSuchElementException.class, e -> null).onFailure(e -> this.log.error("failed to get HEAD branch", e)).getOrNull();
    }

    private static class RemoteImpl
    implements GitRemote {
        private final String name;
        private final @Nullable String headBranchRefName;

        RemoteImpl(String name, @Nullable String headBranchRefName) {
            this.name = name;
            this.headBranchRefName = headBranchRefName;
        }

        static GitRemote nullCheck(@Nullable String name, @Nullable String headBranchRefName) {
            return new RemoteImpl(Objects.requireNonNull(name), headBranchRefName);
        }

        @Override
        public @Nullable String headBranchRefName() {
            return this.headBranchRefName;
        }

        @Override
        public @NonNull String name() {
            return this.name;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
        }
    }
}

