/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.git;

import com.xenoterracide.gradle.semver.guava.base.Splitter;
import com.xenoterracide.gradle.semver.jgit.api.DescribeCommand;
import com.xenoterracide.gradle.semver.jgit.api.Git;
import com.xenoterracide.gradle.semver.jgit.api.errors.GitAPIException;
import com.xenoterracide.gradle.semver.jgit.errors.InvalidPatternException;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectId;
import io.vavr.CheckedFunction1;
import java.io.IOException;
import java.util.List;
import org.jspecify.annotations.Nullable;

class Describer
implements CheckedFunction1<Git, Described> {
    private static final long serialVersionUID = 1L;
    private static final Splitter DESCRIBE_SPLITTER = Splitter.on('-');
    private static final String VERSION_GLOB = "v[0-9]*.[0-9]*.[0-9]*";
    private final ObjectId oid;

    Describer(ObjectId oid) {
        this.oid = oid;
    }

    static CheckedFunction1<Git, Described> describe(ObjectId oid) {
        return new Describer(oid);
    }

    public @Nullable Described apply(Git git) throws InvalidPatternException, IOException, GitAPIException {
        DescribeCommand cmd = git.describe().setMatch(VERSION_GLOB).setLong(true).setTags(true).setTarget(this.oid);
        String desc = cmd.call();
        return desc != null ? new Described(DESCRIBE_SPLITTER.splitToList(desc)) : null;
    }

    static class Described {
        private final List<String> parts;

        Described(List<String> parts) {
            this.parts = parts;
        }

        long distance() {
            return this.parts.size() > 2 ? Long.parseLong(this.parts.get(this.parts.size() - 2)) : 0L;
        }
    }
}

