/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swaggersocket.protocol;

import com.wordnik.swaggersocket.protocol.Header;
import com.wordnik.swaggersocket.protocol.ProtocolBase;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class Response
extends ProtocolBase {
    private String uuid;
    private String path;
    private int status;
    private String reasonPhrase;

    public Response() {
    }

    private Response(Builder b) {
        this.uuid = b.uuid;
        this.path = b.path;
        this.status = b.status;
        this.messageBody = b.messageBody;
        this.reasonPhrase = b.reasonPhrase;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public int getStatusCode() {
        return this.status;
    }

    public void setStatusCode(int status) {
        this.status = status;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public void setReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
    }

    public static final class Builder {
        private String uuid = UUID.randomUUID().toString();
        private String method = "POST";
        private String path = "/";
        private String reasonPhrase;
        private int status;
        private final List<Header> headers = new ArrayList<Header>();
        private Object messageBody;

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder status(int status, String reasonPhrase) {
            this.status = status;
            this.reasonPhrase = reasonPhrase;
            return this;
        }

        public Builder header(Header header) {
            this.headers.add(header);
            return this;
        }

        public Builder body(Object messageBody) {
            this.messageBody = messageBody;
            return this;
        }

        public Response build() {
            return new Response(this);
        }
    }
}

