/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport.netty;

import com.weibo.api.motan.common.FutureState;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.protocol.rpc.RpcProtocolVersion;
import com.weibo.api.motan.rpc.Future;
import com.weibo.api.motan.rpc.FutureListener;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class NettyResponseFuture
implements Response,
Future {
    private volatile FutureState state = FutureState.DOING;
    private Object lock = new Object();
    private Object result = null;
    private Exception exception = null;
    private long createTime = System.currentTimeMillis();
    private int timeout = 0;
    private long processTime = 0L;
    private Request request;
    private List<FutureListener> listeners;
    private Channel channel;

    public NettyResponseFuture(Request requestObj, int timeout, Channel channel) {
        this.request = requestObj;
        this.timeout = timeout;
        this.channel = channel;
    }

    public void onSuccess(Response response) {
        this.result = response.getValue();
        this.processTime = response.getProcessTime();
        this.done();
    }

    public void onFailure(Response response) {
        this.exception = response.getException();
        this.processTime = response.getProcessTime();
        this.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isDoing()) {
                return this.getValueOrThrowable();
            }
            if (this.timeout <= 0) {
                try {
                    this.lock.wait();
                }
                catch (Exception e) {
                    this.cancel((Exception)((Object)new MotanServiceException("NettyResponseFuture getValue InterruptedException : " + MotanFrameworkUtil.toString((Request)this.request) + " cost=" + (System.currentTimeMillis() - this.createTime), (Throwable)e)));
                }
                return this.getValueOrThrowable();
            }
            long waitTime = (long)this.timeout - (System.currentTimeMillis() - this.createTime);
            if (waitTime > 0L) {
                do {
                    try {
                        this.lock.wait(waitTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (this.isDoing() && (waitTime = (long)this.timeout - (System.currentTimeMillis() - this.createTime)) > 0L);
            }
            if (this.isDoing()) {
                this.timeoutSoCancel();
            }
            return this.getValueOrThrowable();
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean cancel() {
        MotanServiceException e = new MotanServiceException("NettyResponseFuture task cancel: serverPort=" + this.channel.getUrl().getServerPortStr() + " " + MotanFrameworkUtil.toString((Request)this.request) + " cost=" + (System.currentTimeMillis() - this.createTime));
        return this.cancel((Exception)((Object)e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cancel(Exception e) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isDoing()) {
                return false;
            }
            this.state = FutureState.CANCELLED;
            this.exception = e;
            this.lock.notifyAll();
        }
        this.notifyListeners();
        return true;
    }

    public boolean isCancelled() {
        return this.state.isCancelledState();
    }

    public boolean isDone() {
        return this.state.isDoneState();
    }

    public boolean isSuccess() {
        return this.isDone() && this.exception == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(FutureListener listener) {
        if (listener == null) {
            throw new NullPointerException("FutureListener is null");
        }
        boolean notifyNow = false;
        Object object = this.lock;
        synchronized (object) {
            if (!this.isDoing()) {
                notifyNow = true;
            } else {
                if (this.listeners == null) {
                    this.listeners = new ArrayList<FutureListener>(1);
                }
                this.listeners.add(listener);
            }
        }
        if (notifyNow) {
            this.notifyListener(listener);
        }
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public Object getRequestObj() {
        return this.request;
    }

    public FutureState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeoutSoCancel() {
        this.processTime = System.currentTimeMillis() - this.createTime;
        Object object = this.lock;
        synchronized (object) {
            if (!this.isDoing()) {
                return;
            }
            this.state = FutureState.CANCELLED;
            this.exception = new MotanServiceException("NettyResponseFuture request timeout: serverPort=" + this.channel.getUrl().getServerPortStr() + " " + MotanFrameworkUtil.toString((Request)this.request) + " cost=" + (System.currentTimeMillis() - this.createTime), MotanErrorMsgConstant.SERVICE_TIMEOUT);
            this.lock.notifyAll();
        }
        this.notifyListeners();
    }

    private void notifyListeners() {
        if (this.listeners != null) {
            for (FutureListener listener : this.listeners) {
                this.notifyListener(listener);
            }
        }
    }

    private void notifyListener(FutureListener listener) {
        try {
            listener.operationComplete((Future)this);
        }
        catch (Throwable t) {
            LoggerUtil.error((String)("NettyResponseFuture notifyListener Error: " + listener.getClass().getSimpleName()), (Throwable)t);
        }
    }

    private boolean isDoing() {
        return this.state.isDoingState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean done() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isDoing()) {
                return false;
            }
            this.state = FutureState.DONE;
            this.lock.notifyAll();
        }
        this.notifyListeners();
        return true;
    }

    public long getRequestId() {
        return this.request.getRequestId();
    }

    private Object getValueOrThrowable() {
        if (this.exception != null) {
            throw this.exception instanceof RuntimeException ? (RuntimeException)this.exception : new MotanServiceException(this.exception.getMessage(), (Throwable)this.exception);
        }
        return this.result;
    }

    public long getProcessTime() {
        return this.processTime;
    }

    public void setProcessTime(long time) {
        this.processTime = time;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public Map<String, String> getAttachments() {
        return Collections.EMPTY_MAP;
    }

    public void setAttachment(String key, String value) {
    }

    public void setRpcProtocolVersion(byte rpcProtocolVersion) {
    }

    public byte getRpcProtocolVersion() {
        return RpcProtocolVersion.VERSION_1.getVersion();
    }
}

