/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport.support;

import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.rpc.DefaultRequest;
import com.weibo.api.motan.rpc.DefaultResponse;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.transport.HeartbeatFactory;
import com.weibo.api.motan.transport.MessageHandler;
import com.weibo.api.motan.util.RequestIdGenerator;

@SpiMeta(name="motan")
public class DefaultRpcHeartbeatFactory
implements HeartbeatFactory {
    @Override
    public Request createRequest() {
        DefaultRequest request = new DefaultRequest();
        request.setRequestId(RequestIdGenerator.getRequestId());
        request.setInterfaceName("com.weibo.api.motan.rpc.heartbeat");
        request.setMethodName("heartbeat");
        request.setParamtersDesc("void");
        return request;
    }

    @Override
    public MessageHandler wrapMessageHandler(MessageHandler handler) {
        return new HeartMessageHandleWrapper(handler);
    }

    public static boolean isHeartbeatRequest(Object message) {
        if (!(message instanceof Request)) {
            return false;
        }
        Request request = (Request)message;
        return "com.weibo.api.motan.rpc.heartbeat".equals(request.getInterfaceName()) && "heartbeat".equals(request.getMethodName()) && "void".endsWith(request.getParamtersDesc());
    }

    private class HeartMessageHandleWrapper
    implements MessageHandler {
        private MessageHandler messageHandler;

        public HeartMessageHandleWrapper(MessageHandler messageHandler) {
            this.messageHandler = messageHandler;
        }

        @Override
        public Object handle(Channel channel, Object message) {
            if (DefaultRpcHeartbeatFactory.isHeartbeatRequest(message)) {
                DefaultResponse response = new DefaultResponse();
                response.setValue("heartbeat");
                return response;
            }
            return this.messageHandler.handle(channel, message);
        }
    }
}

