/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.switcher;

import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.switcher.Switcher;
import com.weibo.api.motan.switcher.SwitcherService;
import com.weibo.api.motan.util.LoggerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@SpiMeta(name="localSwitcherService")
public class LocalSwitcherService
implements SwitcherService {
    private static ConcurrentMap<String, Switcher> switchers = new ConcurrentHashMap<String, Switcher>();

    @Override
    public Switcher getSwitcher(String name) {
        return (Switcher)switchers.get(name);
    }

    @Override
    public List<Switcher> getAllSwitchers() {
        return new ArrayList<Switcher>(switchers.values());
    }

    public static Switcher getSwitcherStatic(String name) {
        return (Switcher)switchers.get(name);
    }

    public static List<Switcher> getAllSwitchersStatic() {
        return new ArrayList<Switcher>(switchers.values());
    }

    public static void putSwitcher(Switcher switcher) {
        if (switcher == null) {
            throw new MotanFrameworkException("LocalSwitcherService addSwitcher Error: switcher is null");
        }
        switchers.put(switcher.getName(), switcher);
    }

    public static void putSwitcher(String name, boolean on) {
        if (switchers.get(name) != null) {
            LoggerUtil.warn("LocalSwitcherService addSwitcher Error: switcher exists");
            return;
        }
        Switcher switcher = new Switcher(name, on);
        switchers.putIfAbsent(name, switcher);
    }

    public static void onSwitcher(String name) {
        Switcher switcher = (Switcher)switchers.get(name);
        if (switcher == null) {
            switcher = new Switcher(name, true);
            LocalSwitcherService.putSwitcher(switcher);
        }
        switcher.onSwitcher();
    }

    public static void offSwitcher(String name) {
        Switcher switcher = (Switcher)switchers.get(name);
        if (switcher == null) {
            switcher = new Switcher(name, false);
            LocalSwitcherService.putSwitcher(switcher);
        }
        switcher.offSwitcher();
    }

    @Override
    public void initSwitcher(String switcherName, boolean initialValue) {
        LocalSwitcherService.putSwitcher(switcherName, initialValue);
    }

    @Override
    public boolean switcherIsOpen(String switcherName) {
        Switcher switcher = (Switcher)switchers.get(switcherName);
        return switcher != null && switcher.isOn();
    }

    @Override
    public boolean switcherIsOpen(String switcherName, boolean defaultValue) {
        Switcher switcher = (Switcher)switchers.get(switcherName);
        if (switcher == null) {
            switchers.putIfAbsent(switcherName, new Switcher(switcherName, defaultValue));
            switcher = (Switcher)switchers.get(switcherName);
        }
        return switcher.isOn();
    }

    @Override
    public void setSwitcher(String switcherName, boolean value) {
        LocalSwitcherService.putSwitcher(new Switcher(switcherName, value));
    }
}

