/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.rpc;

import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanBizException;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.rpc.AbstractProvider;
import com.weibo.api.motan.rpc.DefaultResponse;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.LoggerUtil;
import java.lang.reflect.Method;

@SpiMeta(name="motan")
public class DefaultProvider<T>
extends AbstractProvider<T> {
    protected T proxyImpl;

    public DefaultProvider(T proxyImpl, URL url, Class<T> clz) {
        super(url, clz);
        this.proxyImpl = proxyImpl;
    }

    @Override
    public Response invoke(Request request) {
        DefaultResponse response = new DefaultResponse();
        Method method = this.lookup(request);
        if (method == null) {
            MotanServiceException exception = new MotanServiceException("Service method not exist: " + request.getInterfaceName() + "." + request.getMethodName() + "(" + request.getParamtersDesc() + ")", MotanErrorMsgConstant.SERVICE_UNFOUND);
            response.setException(exception);
            return response;
        }
        try {
            Object value = method.invoke(this.proxyImpl, request.getArguments());
            response.setValue(value);
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                LoggerUtil.error("Exception caught when method invoke: " + e.getCause());
                response.setException(new MotanBizException("provider call process error", e.getCause()));
            } else {
                response.setException(new MotanBizException("provider call process error", e));
            }
        }
        catch (Throwable t) {
            if (t.getCause() != null) {
                response.setException(new MotanServiceException("provider has encountered a fatal error!", t.getCause()));
            }
            response.setException(new MotanServiceException("provider has encountered a fatal error!", t));
        }
        response.setRpcProtocolVersion(request.getRpcProtocolVersion());
        response.setAttachments(request.getAttachments());
        return response;
    }
}

