/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.registry.support;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.registry.NotifyListener;
import com.weibo.api.motan.registry.RegistryService;
import com.weibo.api.motan.registry.support.AbstractRegistry;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.CollectionUtil;
import com.weibo.api.motan.util.ConcurrentHashSet;
import com.weibo.api.motan.util.LoggerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.ObjectUtils;

@SpiMeta(name="local")
public class LocalRegistryService
extends AbstractRegistry {
    private ConcurrentMap<String, List<URL>> registeredServices = new ConcurrentHashMap<String, List<URL>>();
    private ConcurrentHashMap<String, ConcurrentHashMap<URL, ConcurrentHashSet<NotifyListener>>> subscribeListeners = new ConcurrentHashMap();
    private URL registryUrl;

    public LocalRegistryService() {
        this(new URL("local", "127.0.0.1", 0, RegistryService.class.getName()));
    }

    public LocalRegistryService(URL url) {
        super(url);
        this.registryUrl = url;
    }

    @Override
    public void doSubscribe(URL url, NotifyListener listener) {
        ConcurrentHashSet<NotifyListener> listeners;
        String subscribeKey = this.getSubscribeKey(url);
        ConcurrentHashMap<URL, ConcurrentHashSet<NotifyListener>> urlListeners = this.subscribeListeners.get(subscribeKey);
        if (urlListeners == null) {
            this.subscribeListeners.putIfAbsent(subscribeKey, new ConcurrentHashMap());
            urlListeners = this.subscribeListeners.get(subscribeKey);
        }
        if ((listeners = urlListeners.get(url)) == null) {
            urlListeners.putIfAbsent(url, new ConcurrentHashSet());
            listeners = urlListeners.get(url);
        }
        listeners.add(listener);
        List<URL> urls = this.discover(url);
        if (urls != null && urls.size() > 0) {
            listener.notify(this.getUrl(), urls);
        }
        LoggerUtil.info("LocalRegistryService subscribe: url={}", url);
    }

    @Override
    public void doUnsubscribe(URL url, NotifyListener listener) {
        String subscribeKey = this.getSubscribeKey(url);
        ConcurrentHashMap<URL, ConcurrentHashSet<NotifyListener>> urlListeners = this.subscribeListeners.get(subscribeKey);
        if (urlListeners != null) {
            urlListeners.remove(url);
        }
        LoggerUtil.info("LocalRegistryService unsubscribe: url={}", url);
    }

    @Override
    public List<URL> doDiscover(URL url) {
        return (List)this.registeredServices.get(this.getRegistryKey(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRegister(URL url) {
        String registryKey = this.getRegistryKey(url);
        ConcurrentMap<String, List<URL>> concurrentMap = this.registeredServices;
        synchronized (concurrentMap) {
            List urls = (List)this.registeredServices.get(registryKey);
            if (urls == null) {
                this.registeredServices.putIfAbsent(registryKey, new ArrayList());
                urls = (List)this.registeredServices.get(registryKey);
            }
            this.add(url, urls);
            LoggerUtil.info("LocalRegistryService register: url={}", url);
            this.notifyListeners(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUnregister(URL url) {
        ConcurrentMap<String, List<URL>> concurrentMap = this.registeredServices;
        synchronized (concurrentMap) {
            List urls = (List)this.registeredServices.get(this.getRegistryKey(url));
            if (urls == null) {
                return;
            }
            this.remove(url, urls);
            LoggerUtil.info("LocalRegistryService unregister: url={}", url);
            this.notifyListeners(url);
        }
    }

    @Override
    public URL getUrl() {
        return this.registryUrl;
    }

    public Map<String, List<URL>> getAllUrl() {
        HashMap<String, List<URL>> copyMap = new HashMap<String, List<URL>>(this.registeredServices.size());
        for (Map.Entry entry : this.registeredServices.entrySet()) {
            String key = (String)entry.getKey();
            ArrayList<URL> copyList = new ArrayList<URL>(((List)entry.getValue()).size());
            for (URL url : (List)entry.getValue()) {
                copyList.add(url.createCopy());
            }
            copyMap.put(key, copyList);
        }
        return copyMap;
    }

    private void remove(URL url, List<URL> urls) {
        if (CollectionUtil.isEmpty(urls)) {
            return;
        }
        this.removeCachedUrlByIdentity(url, urls);
    }

    private void add(URL url, List<URL> urls) {
        this.removeCachedUrlByIdentity(url, urls);
        urls.add(url);
    }

    private void removeCachedUrlByIdentity(URL url, List<URL> urls) {
        if (CollectionUtil.isEmpty(urls)) {
            return;
        }
        URL oldUrl = null;
        for (URL cachedUrl : urls) {
            if (!ObjectUtils.equals((Object)url, (Object)cachedUrl)) continue;
            oldUrl = cachedUrl;
            break;
        }
        if (oldUrl != null) {
            urls.remove(oldUrl);
        }
    }

    private void notifyListeners(URL changedUrl) {
        List<URL> interestingUrls = this.discover(changedUrl);
        if (interestingUrls != null) {
            ConcurrentHashMap<URL, ConcurrentHashSet<NotifyListener>> urlListeners = this.subscribeListeners.get(this.getSubscribeKey(changedUrl));
            if (urlListeners == null) {
                return;
            }
            for (ConcurrentHashSet<NotifyListener> listeners : urlListeners.values()) {
                for (NotifyListener ln : listeners) {
                    try {
                        ln.notify(this.getUrl(), interestingUrls);
                    }
                    catch (Exception e) {
                        LoggerUtil.warn(String.format("Exception when notify listerner %s, changedUrl: %s", ln, changedUrl), e);
                    }
                }
            }
        }
    }

    private String getRegistryKey(URL url) {
        String keyPrefix = url.getPath();
        String nodeType = url.getParameter(URLParamType.nodeType.getName());
        if (nodeType != null) {
            return keyPrefix + "/" + nodeType;
        }
        LoggerUtil.warn("Url need a nodeType as param in localRegistry, url={}", url);
        return keyPrefix;
    }

    private String getSubscribeKey(URL url) {
        return this.getRegistryKey(url);
    }
}

