/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.support;

import com.weibo.api.motan.common.MotanConstants;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.Activation;
import com.weibo.api.motan.core.extension.ActivationComparator;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.filter.AccessLogFilter;
import com.weibo.api.motan.filter.Filter;
import com.weibo.api.motan.rpc.Exporter;
import com.weibo.api.motan.rpc.Protocol;
import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ProtocolFilterDecorator
implements Protocol {
    private Protocol protocol;

    public ProtocolFilterDecorator(Protocol protocol) {
        if (protocol == null) {
            throw new MotanFrameworkException("Protocol is null when construct ProtocolFilterDecorator", MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
        }
        this.protocol = protocol;
    }

    @Override
    public <T> Exporter<T> export(Provider<T> provider, URL url) {
        return this.protocol.export(this.decorateWithFilter(provider, url), url);
    }

    @Override
    public <T> Referer<T> refer(Class<T> clz, URL url, URL serviceUrl) {
        return this.decorateWithFilter(this.protocol.refer(clz, url, serviceUrl), url);
    }

    @Override
    public void destroy() {
        this.protocol.destroy();
    }

    private <T> Referer<T> decorateWithFilter(Referer<T> referer, URL url) {
        List<Filter> filters = this.getFilters(url, "referer");
        Referer lastRef = referer;
        Iterator<Filter> iterator = filters.iterator();
        while (iterator.hasNext()) {
            Filter filter;
            final Filter f = filter = iterator.next();
            final Referer lf = lastRef;
            lastRef = new Referer<T>(){

                @Override
                public Response call(Request request) {
                    if (!f.getClass().getAnnotation(Activation.class).retry() && request.getRetries() != 0) {
                        return lf.call(request);
                    }
                    return f.filter(lf, request);
                }

                @Override
                public String desc() {
                    return lf.desc();
                }

                @Override
                public void destroy() {
                    lf.destroy();
                }

                @Override
                public Class<T> getInterface() {
                    return lf.getInterface();
                }

                @Override
                public URL getUrl() {
                    return lf.getUrl();
                }

                @Override
                public void init() {
                    lf.init();
                }

                @Override
                public boolean isAvailable() {
                    return lf.isAvailable();
                }

                @Override
                public int activeRefererCount() {
                    return lf.activeRefererCount();
                }

                @Override
                public URL getServiceUrl() {
                    return lf.getServiceUrl();
                }
            };
        }
        return lastRef;
    }

    private <T> Provider<T> decorateWithFilter(Provider<T> provider, URL url) {
        List<Filter> filters = this.getFilters(url, "service");
        if (filters == null || filters.size() == 0) {
            return provider;
        }
        Provider lastProvider = provider;
        Iterator<Filter> iterator = filters.iterator();
        while (iterator.hasNext()) {
            Filter filter;
            final Filter f = filter = iterator.next();
            final Provider lp = lastProvider;
            lastProvider = new Provider<T>(){

                @Override
                public Response call(Request request) {
                    return f.filter(lp, request);
                }

                @Override
                public String desc() {
                    return lp.desc();
                }

                @Override
                public void destroy() {
                    lp.destroy();
                }

                @Override
                public Class<T> getInterface() {
                    return lp.getInterface();
                }

                @Override
                public URL getUrl() {
                    return lp.getUrl();
                }

                @Override
                public void init() {
                    lp.init();
                }

                @Override
                public boolean isAvailable() {
                    return lp.isAvailable();
                }
            };
        }
        return lastProvider;
    }

    private List<Filter> getFilters(URL url, String key) {
        boolean accessLog;
        String filterStr;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        List<Filter> defaultFilters = ExtensionLoader.getExtensionLoader(Filter.class).getExtensions(key);
        if (defaultFilters != null && defaultFilters.size() > 0) {
            filters.addAll(defaultFilters);
        }
        if (StringUtils.isNotBlank((CharSequence)(filterStr = url.getParameter(URLParamType.filter.getName())))) {
            String[] filterNames;
            for (String fn : filterNames = MotanConstants.COMMA_SPLIT_PATTERN.split(filterStr)) {
                this.addIfAbsent(filters, fn);
            }
        }
        if (accessLog = url.getBooleanParameter(URLParamType.accessLog.getName(), URLParamType.accessLog.getBooleanValue()).booleanValue()) {
            this.addIfAbsent(filters, AccessLogFilter.class.getAnnotation(SpiMeta.class).name());
        }
        Collections.sort(filters, new ActivationComparator());
        Collections.reverse(filters);
        return filters;
    }

    private void addIfAbsent(List<Filter> filters, String extensionName) {
        if (StringUtils.isBlank((CharSequence)extensionName)) {
            return;
        }
        Filter extFilter = ExtensionLoader.getExtensionLoader(Filter.class).getExtension(extensionName);
        if (extFilter == null) {
            return;
        }
        boolean exists = false;
        for (Filter f : filters) {
            if (f.getClass() != extFilter.getClass()) continue;
            exists = true;
            break;
        }
        if (!exists) {
            filters.add(extFilter);
        }
    }
}

