/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.config;

import com.weibo.api.motan.config.MethodConfig;
import com.weibo.api.motan.config.annotation.ConfigDesc;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.util.LoggerUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractConfig
implements Serializable {
    private static final long serialVersionUID = 5736580957909744603L;
    protected String id;
    private static final String[] SUFFIXS = new String[]{"Config", "Bean"};

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    protected static void collectConfigParams(Map<String, String> parameters, AbstractConfig ... configs) {
        for (AbstractConfig config : configs) {
            if (config == null) continue;
            config.appendConfigParams(parameters);
        }
    }

    protected static void collectMethodConfigParams(Map<String, String> parameters, List<MethodConfig> methods) {
        if (methods == null || methods.isEmpty()) {
            return;
        }
        for (MethodConfig mc : methods) {
            if (mc == null) continue;
            mc.appendConfigParams(parameters, "methodconfig." + mc.getName() + "(" + mc.getArgumentTypes() + ")");
        }
    }

    protected void appendConfigParams(Map<String, String> parameters) {
        this.appendConfigParams(parameters, null);
    }

    protected void appendConfigParams(Map<String, String> parameters, String prefix) {
        Method[] methods;
        for (Method method : methods = this.getClass().getMethods()) {
            try {
                Map map;
                String name = method.getName();
                if (this.isConfigMethod(method)) {
                    Object value;
                    String prop;
                    int idx = name.startsWith("get") ? 3 : 2;
                    String key = prop = name.substring(idx, idx + 1).toLowerCase() + name.substring(idx + 1);
                    ConfigDesc configDesc = method.getAnnotation(ConfigDesc.class);
                    if (configDesc != null && !StringUtils.isBlank((CharSequence)configDesc.key())) {
                        key = configDesc.key();
                    }
                    if ((value = method.invoke((Object)this, new Object[0])) == null || StringUtils.isBlank((CharSequence)String.valueOf(value))) {
                        if (configDesc == null || !configDesc.required()) continue;
                        throw new MotanFrameworkException(String.format("%s.%s should not be null or empty", this.getClass().getSimpleName(), key), MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
                    }
                    if (prefix != null && prefix.length() > 0) {
                        key = prefix + "." + key;
                    }
                    parameters.put(key, String.valueOf(value).trim());
                    continue;
                }
                if (!"getParameters".equals(name) || !Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 0 || method.getReturnType() != Map.class || (map = (Map)method.invoke((Object)this, new Object[0])) == null || map.size() <= 0) continue;
                String pre = prefix != null && prefix.length() > 0 ? prefix + "." : "";
                for (Map.Entry entry : map.entrySet()) {
                    parameters.put(pre + (String)entry.getKey(), (String)entry.getValue());
                }
            }
            catch (Exception e) {
                throw new MotanFrameworkException(String.format("Error when append params for config: %s.%s", this.getClass().getSimpleName(), method.getName()), e, MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
            }
        }
    }

    private boolean isConfigMethod(Method method) {
        ConfigDesc configDesc;
        boolean checkMethod;
        boolean bl = checkMethod = (method.getName().startsWith("get") || method.getName().startsWith("is")) && !"isDefault".equals(method.getName()) && Modifier.isPublic(method.getModifiers()) && method.getParameterTypes().length == 0 && this.isPrimitive(method.getReturnType());
        if (checkMethod && (configDesc = method.getAnnotation(ConfigDesc.class)) != null && configDesc.excluded()) {
            return false;
        }
        return checkMethod;
    }

    private boolean isPrimitive(Class<?> type) {
        return type.isPrimitive() || type == String.class || type == Character.class || type == Boolean.class || type == Byte.class || type == Short.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class;
    }

    public String toString() {
        try {
            Method[] methods;
            StringBuilder buf = new StringBuilder();
            buf.append("<motan:");
            buf.append(AbstractConfig.getTagName(this.getClass()));
            for (Method method : methods = this.getClass().getMethods()) {
                try {
                    String name = method.getName();
                    if (!name.startsWith("get") && !name.startsWith("is") || "getClass".equals(name) || "get".equals(name) || "is".equals(name) || !Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 0 || !this.isPrimitive(method.getReturnType())) continue;
                    int i = name.startsWith("get") ? 3 : 2;
                    String key = name.substring(i, i + 1).toLowerCase() + name.substring(i + 1);
                    Object value = method.invoke((Object)this, new Object[0]);
                    if (value == null) continue;
                    buf.append(" ");
                    buf.append(key);
                    buf.append("=\"");
                    buf.append(value);
                    buf.append("\"");
                }
                catch (Exception e) {
                    LoggerUtil.warn(e.getMessage(), e);
                }
            }
            buf.append(" />");
            return buf.toString();
        }
        catch (Throwable t) {
            LoggerUtil.warn(t.getMessage(), t);
            return super.toString();
        }
    }

    private static String getTagName(Class<?> cls) {
        String tag = cls.getSimpleName();
        for (String suffix : SUFFIXS) {
            if (!tag.endsWith(suffix)) continue;
            tag = tag.substring(0, tag.length() - suffix.length());
            break;
        }
        tag = tag.toLowerCase();
        return tag;
    }
}

