/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.wavefront.sdk.common.Constants;
import com.wavefront.sdk.common.Pair;
import com.wavefront.sdk.common.annotation.NonNull;
import com.wavefront.sdk.common.annotation.Nullable;
import com.wavefront.sdk.entities.events.EventDTO;
import com.wavefront.sdk.entities.histograms.HistogramGranularity;
import com.wavefront.sdk.entities.tracing.SpanLog;
import com.wavefront.sdk.entities.tracing.SpanLogsDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public class Utils {
    private static final Logger logger = Logger.getLogger(Utils.class.getCanonicalName());
    private static final ObjectMapper JSON_PARSER = new ObjectMapper();

    public static String sanitize(String s) {
        return Utils.sanitizeInternal(s, true, false);
    }

    public static String sanitize(String s, boolean ignoreSlash) {
        return Utils.sanitizeInternal(s, true, ignoreSlash);
    }

    public static String sanitizeWithoutQuotes(String s) {
        return Utils.sanitizeInternal(s, false, false);
    }

    public static String sanitizeValue(String s) {
        String res = s.trim();
        if (s.contains("\"") || s.contains("'")) {
            res = res.replace("\"", "\\\"");
        }
        return "\"" + res.replace("\n", "\\n") + "\"";
    }

    public static String metricToLineData(String name, double value, @Nullable Long timestamp, String source, @Nullable Map<String, String> tags, String defaultSource) {
        if (source == null || source.isEmpty()) {
            source = defaultSource;
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("metrics name cannot be blank " + Utils.getContextInfo(name, source, tags));
        }
        if (source == null || source.isEmpty()) {
            throw new IllegalArgumentException("source cannot be blank " + Utils.getContextInfo(name, source, tags));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Utils.sanitize(name));
        sb.append(' ');
        sb.append(value);
        if (timestamp != null) {
            sb.append(' ');
            sb.append(timestamp);
        }
        sb.append(" source=");
        sb.append(Utils.sanitizeValue(source));
        if (tags != null) {
            for (Map.Entry<String, String> tag : tags.entrySet()) {
                String key = tag.getKey();
                String val = tag.getValue();
                if (key == null || key.isEmpty()) {
                    throw new IllegalArgumentException("metric point tag key cannot be blank " + Utils.getContextInfo(name, source, tags));
                }
                if (val == null || val.isEmpty()) {
                    throw new IllegalArgumentException("metric point tag value cannot be blank for tag key: " + key + " " + Utils.getContextInfo(name, source, tags));
                }
                sb.append(' ');
                sb.append(Utils.sanitize(key));
                sb.append('=');
                sb.append(Utils.sanitizeValue(val));
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    public static String logToLineData(String name, double value, @Nullable Long timestamp, String source, @Nullable Map<String, String> tags, String defaultSource) {
        if (source == null || source.isEmpty()) {
            source = defaultSource;
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("log name cannot be blank " + Utils.getContextInfo(name, source, tags));
        }
        if (source == null || source.isEmpty()) {
            throw new IllegalArgumentException("source cannot be blank " + Utils.getContextInfo(name, source, tags));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Utils.sanitize(name, true));
        sb.append(' ');
        sb.append(value);
        if (timestamp != null) {
            sb.append(' ');
            sb.append(timestamp);
        }
        sb.append(" source=");
        sb.append(Utils.sanitizeValue(source));
        if (tags != null) {
            for (Map.Entry<String, String> tag : tags.entrySet()) {
                String key = tag.getKey();
                String val = tag.getValue();
                if (key == null || key.isEmpty()) {
                    throw new IllegalArgumentException("log label key cannot be blank " + Utils.getContextInfo(name, source, tags));
                }
                if (val == null || val.isEmpty()) {
                    throw new IllegalArgumentException("log label value cannot be blank for log label key: " + key + " " + Utils.getContextInfo(name, source, tags));
                }
                sb.append(' ');
                sb.append(Utils.sanitize(key));
                sb.append('=');
                sb.append(Utils.sanitizeValue(val));
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    public static String histogramToLineData(String name, List<Pair<Double, Integer>> centroids, Set<HistogramGranularity> histogramGranularities, @Nullable Long timestamp, String source, @Nullable Map<String, String> tags, String defaultSource) {
        if (source == null || source.isEmpty()) {
            source = defaultSource;
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("histogram name cannot be blank " + Utils.getContextInfo(name, source, tags));
        }
        if (source == null || source.isEmpty()) {
            throw new IllegalArgumentException("histogram source cannot be blank " + Utils.getContextInfo(name, source, tags));
        }
        if (histogramGranularities == null || histogramGranularities.isEmpty()) {
            throw new IllegalArgumentException("Histogram granularities cannot be null or empty " + Utils.getContextInfo(name, source, tags));
        }
        if (centroids == null || centroids.isEmpty()) {
            throw new IllegalArgumentException("A distribution should have at least one centroid " + Utils.getContextInfo(name, source, tags));
        }
        StringBuilder sb = new StringBuilder();
        for (HistogramGranularity histogramGranularity : histogramGranularities) {
            sb.append(histogramGranularity.identifier);
            if (timestamp != null) {
                sb.append(' ');
                sb.append(Long.toString(timestamp));
            }
            sb.append(' ');
            Utils.appendCompactedCentroids(sb, centroids);
            sb.append(Utils.sanitize(name));
            sb.append(" source=");
            sb.append(Utils.sanitizeValue(source));
            if (tags != null) {
                for (Map.Entry<String, String> tag : tags.entrySet()) {
                    String key = tag.getKey();
                    String val = tag.getValue();
                    if (key == null || key.isEmpty()) {
                        throw new IllegalArgumentException("histogram tag key cannot be blank " + Utils.getContextInfo(name, source, tags));
                    }
                    if (val == null || val.isEmpty()) {
                        throw new IllegalArgumentException("histogram tag value cannot be blank for tag key: " + key + " " + Utils.getContextInfo(name, source, tags));
                    }
                    sb.append(' ');
                    sb.append(Utils.sanitize(tag.getKey()));
                    sb.append('=');
                    sb.append(Utils.sanitizeValue(tag.getValue()));
                }
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String tracingSpanToLineData(String name, long startMillis, long durationMillis, String source, UUID traceId, UUID spanId, @Nullable List<UUID> parents, @Nullable List<UUID> followsFrom, @Nullable List<Pair<String, String>> tags, @Nullable List<SpanLog> spanLogs, String defaultSource) {
        if (source == null || source.isEmpty()) {
            source = defaultSource;
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("span name cannot be blank " + Utils.getContextInfo(name, source, tags));
        }
        if (source == null || source.isEmpty()) {
            throw new IllegalArgumentException("span source cannot be blank " + Utils.getContextInfo(name, source, tags));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Utils.sanitizeValue(name));
        sb.append(" source=");
        sb.append(Utils.sanitizeValue(source));
        sb.append(" traceId=");
        sb.append(traceId);
        sb.append(" spanId=");
        sb.append(spanId);
        if (parents != null) {
            for (UUID uUID : parents) {
                sb.append(" parent=");
                sb.append(uUID.toString());
            }
        }
        if (followsFrom != null) {
            for (UUID uUID : followsFrom) {
                sb.append(" followsFrom=");
                sb.append(uUID.toString());
            }
        }
        if (tags != null) {
            for (Pair pair : tags) {
                String key = (String)pair._1;
                String val = (String)pair._2;
                if (key == null || key.isEmpty()) {
                    throw new IllegalArgumentException("span tag key cannot be blank " + Utils.getContextInfo(name, source, tags));
                }
                if (val == null || val.isEmpty()) {
                    throw new IllegalArgumentException("span tag value cannot be blank for tag key: " + key + " " + Utils.getContextInfo(name, source, tags));
                }
                sb.append(' ');
                sb.append(Utils.sanitize(key));
                sb.append('=');
                sb.append(Utils.sanitizeValue(val));
            }
        }
        if (spanLogs != null && !spanLogs.isEmpty()) {
            sb.append(' ');
            sb.append(Utils.sanitize("_spanLogs"));
            sb.append('=');
            sb.append(Utils.sanitize("true"));
        }
        sb.append(' ');
        sb.append(startMillis);
        sb.append(' ');
        sb.append(durationMillis);
        sb.append('\n');
        return sb.toString();
    }

    public static String eventToLineData(String name, long startMillis, long endMillis, @Nullable String source, @Nullable Map<String, String> tags, @Nullable Map<String, String> annotations, String defaultSource, boolean jsonify) throws JsonProcessingException {
        String val;
        String key;
        if (source == null || source.isEmpty()) {
            source = defaultSource;
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("event name cannot be blank " + Utils.getContextInfo(name, source, tags));
        }
        if (source == null || source.isEmpty()) {
            throw new IllegalArgumentException("event source and default source cannot be blank " + Utils.getContextInfo(name, source, tags));
        }
        if (endMillis == 0L) {
            endMillis = startMillis + 1L;
        }
        ArrayList<String> sanitizedTags = null;
        HashMap<String, String> sanitizedAnnotations = null;
        if (tags != null) {
            sanitizedTags = new ArrayList<String>();
            for (Map.Entry<String, String> tag : tags.entrySet()) {
                key = tag.getKey();
                val = tag.getValue();
                if (key == null || key.isEmpty()) {
                    throw new IllegalArgumentException("event tag key cannot be blank " + Utils.getContextInfo(name, source, tags));
                }
                if (val == null || val.isEmpty()) {
                    throw new IllegalArgumentException("event tag value cannot be blank for tag key: " + key + " " + Utils.getContextInfo(name, source, tags));
                }
                sanitizedTags.add(Utils.sanitizeWithoutQuotes(key) + ": " + val.trim());
            }
        }
        if (annotations != null) {
            sanitizedAnnotations = new HashMap<String, String>();
            for (Map.Entry<String, String> annotation : annotations.entrySet()) {
                key = annotation.getKey();
                val = annotation.getValue();
                if (key == null || key.isEmpty()) {
                    throw new IllegalArgumentException("event annotation key cannot be blank " + Utils.getContextInfo(name, source, tags));
                }
                if (val == null || val.isEmpty()) {
                    throw new IllegalArgumentException("event annotation value cannot be blank for annotation key: " + key + " " + Utils.getContextInfo(name, source, tags));
                }
                sanitizedAnnotations.put(Utils.sanitizeWithoutQuotes(key), val.trim());
            }
        }
        if (jsonify) {
            StringBuilder toReturn = new StringBuilder();
            if (sanitizedAnnotations == null) {
                sanitizedAnnotations = new HashMap();
            }
            toReturn.append(JSON_PARSER.writeValueAsString((Object)new EventDTO(name, startMillis, endMillis, source, sanitizedAnnotations, sanitizedTags))).append("\n");
            return toReturn.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("@Event");
        sb.append(' ');
        sb.append(startMillis);
        sb.append(' ');
        sb.append(endMillis);
        sb.append(' ');
        sb.append(Utils.sanitizeValue(name));
        if (sanitizedAnnotations != null) {
            for (Map.Entry annotation : sanitizedAnnotations.entrySet()) {
                sb.append(' ');
                sb.append((String)annotation.getKey());
                sb.append('=');
                sb.append(Utils.sanitizeValue((String)annotation.getValue()));
            }
        }
        sb.append(" host=");
        sb.append(Utils.sanitizeValue(source));
        if (sanitizedTags != null) {
            for (String tag : sanitizedTags) {
                sb.append(" tag=");
                sb.append(Utils.sanitizeValue(tag));
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    public static String spanLogsToLineData(UUID traceId, UUID spanId, @NonNull List<SpanLog> spanLogs) throws JsonProcessingException {
        return Utils.spanLogsToLineData(traceId, spanId, spanLogs, null);
    }

    public static String spanLogsToLineData(UUID traceId, UUID spanId, @NonNull List<SpanLog> spanLogs, @Nullable String span) throws JsonProcessingException {
        StringBuilder toReturn = new StringBuilder();
        toReturn.append(JSON_PARSER.writeValueAsString((Object)new SpanLogsDTO(traceId, spanId, spanLogs, span)));
        toReturn.append("\n");
        return toReturn.toString();
    }

    public static void shutdownExecutorAndWait(ExecutorService tpe) {
        tpe.shutdown();
        try {
            if (!tpe.awaitTermination(60L, TimeUnit.SECONDS)) {
                tpe.shutdownNow();
                if (!tpe.awaitTermination(60L, TimeUnit.SECONDS)) {
                    logger.log(Level.FINE, "pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            tpe.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private static String sanitizeInternal(String s, boolean addQuotes, boolean ignoreSlash) {
        StringBuilder sb = new StringBuilder();
        if (addQuotes) {
            sb.append('\"');
        }
        for (int i = 0; i < s.length(); ++i) {
            boolean isDeltaTildaPrefixed;
            char cur = s.charAt(i);
            boolean isLegal = true;
            boolean isTildaPrefixed = s.charAt(0) == '~';
            boolean isDeltaPrefixed = s.charAt(0) == '\u2206' || s.charAt(0) == '\u0394';
            boolean bl = isDeltaTildaPrefixed = isDeltaPrefixed && s.charAt(1) == '~';
            if (!(',' <= cur && cur <= '9' || 'A' <= cur && cur <= 'Z' || 'a' <= cur && cur <= 'z' || cur == '_' || i == 0 && (isDeltaPrefixed || isTildaPrefixed) || i == 1 && isDeltaTildaPrefixed)) {
                isLegal = false;
            }
            if (cur == '/' && !ignoreSlash) {
                isLegal = false;
            }
            sb.append(isLegal ? cur : (char)'-');
        }
        if (addQuotes) {
            sb.append('\"');
        }
        return sb.toString();
    }

    private static String getContextInfo(@Nullable String name, @Nullable String source, @Nullable Object tags) {
        try {
            StringBuilder sb = new StringBuilder("(");
            if (name != null) {
                sb.append(name);
            }
            if (source != null) {
                sb.append(" source=").append(source);
            }
            if (tags != null) {
                if (tags instanceof Map) {
                    for (Map.Entry entry : ((Map)tags).entrySet()) {
                        sb.append(' ').append((String)entry.getKey()).append("=[").append((String)entry.getValue()).append(']');
                    }
                } else if (tags instanceof List) {
                    for (Pair entry : (List)tags) {
                        sb.append(' ').append((String)entry._1).append("=[").append((String)entry._2).append(']');
                    }
                }
            }
            sb.append(")");
            return sb.toString();
        }
        catch (Exception ex) {
            return "";
        }
    }

    private static void appendCompactedCentroids(StringBuilder sb, List<Pair<Double, Integer>> centroids) {
        Double accumulatedValue = null;
        int accumulatedCount = 0;
        for (Pair<Double, Integer> centroid : centroids) {
            double value = (Double)centroid._1;
            int count = (Integer)centroid._2;
            if (accumulatedValue != null && value != accumulatedValue) {
                sb.append('#').append(accumulatedCount).append(' ');
                sb.append(accumulatedValue).append(' ');
                accumulatedValue = value;
                accumulatedCount = count;
                continue;
            }
            if (accumulatedValue == null) {
                accumulatedValue = value;
            }
            accumulatedCount += count;
        }
        if (accumulatedValue != null) {
            sb.append('#').append(accumulatedCount).append(' ');
            sb.append(accumulatedValue).append(' ');
        }
    }

    public static Optional<ResourceBundle> getResource(String pathToResource) {
        if (pathToResource != null && !pathToResource.isEmpty()) {
            ResourceBundle resourceBundle = null;
            try {
                resourceBundle = ResourceBundle.getBundle("META-INF/" + pathToResource);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, ex.getMessage());
            }
            if (resourceBundle != null) {
                return Optional.of(resourceBundle);
            }
        }
        return Optional.empty();
    }

    public static Optional<String> getVersion(String artifactId) {
        String version;
        ResourceBundle resourceBundle;
        Optional<ResourceBundle> resource;
        if (artifactId != null && !artifactId.isEmpty() && (resource = Utils.getResource(artifactId + "/build")).isPresent() && (resourceBundle = resource.get()).containsKey("project.version") && (version = resourceBundle.getString("project.version")) != null && !version.isEmpty()) {
            return Optional.of(version);
        }
        return Optional.empty();
    }

    public static double getSemVerGauge(String artifactId) {
        Optional<String> version = Utils.getVersion(artifactId);
        if (version.isPresent()) {
            return Utils.convertSemVerToGauge(version.get());
        }
        logger.log(Level.INFO, "Could not retrieve build version info for : ", artifactId);
        return 0.0;
    }

    public static double convertSemVerToGauge(String version) {
        Matcher semVerMatcher;
        if (version != null && !version.isEmpty() && (semVerMatcher = Constants.SEMVER_PATTERN.matcher(version)).matches()) {
            StringBuilder sdkVersion = new StringBuilder(semVerMatcher.group(1));
            sdkVersion.append(".");
            String minor = semVerMatcher.group(2);
            String patch = semVerMatcher.group(3);
            String snapshot = semVerMatcher.group(4);
            if (minor.length() == 1) {
                sdkVersion.append("0" + minor);
            } else {
                sdkVersion.append(minor);
            }
            if (patch.length() == 1) {
                sdkVersion.append("0" + patch);
            } else {
                sdkVersion.append(patch);
            }
            try {
                return Double.valueOf(sdkVersion.toString());
            }
            catch (Exception ex) {
                logger.log(Level.INFO, ex.getMessage());
            }
        }
        return 0.0;
    }
}

