/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.ast;

import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeIterator;
import com.vladsch.flexmark.util.collection.iteration.ReversiblePeekingIterable;
import com.vladsch.flexmark.util.collection.iteration.ReversiblePeekingIterator;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class NodeIterable
implements ReversiblePeekingIterable<Node> {
    final Node firstNode;
    final Node lastNode;
    final boolean reversed;
    public static final ReversiblePeekingIterable<Node> EMPTY = new ReversiblePeekingIterable<Node>(){

        @NotNull
        public ReversiblePeekingIterator<Node> iterator() {
            return NodeIterator.EMPTY;
        }

        @NotNull
        public ReversiblePeekingIterable<Node> reversed() {
            return this;
        }

        public void forEach(Consumer<? super Node> consumer) {
        }

        public boolean isReversed() {
            return false;
        }

        @NotNull
        public ReversiblePeekingIterator<Node> reversedIterator() {
            return NodeIterator.EMPTY;
        }
    };

    public NodeIterable(Node firstNode, Node lastNode, boolean reversed) {
        this.firstNode = firstNode;
        this.lastNode = lastNode;
        this.reversed = reversed;
    }

    @NotNull
    public ReversiblePeekingIterator<Node> iterator() {
        return new NodeIterator(this.firstNode, this.lastNode, this.reversed);
    }

    public void forEach(Consumer<? super Node> consumer) {
        ReversiblePeekingIterator<Node> iterator = this.iterator();
        while (iterator.hasNext()) {
            consumer.accept((Node)iterator.next());
        }
    }

    @NotNull
    public ReversiblePeekingIterable<Node> reversed() {
        return new NodeIterable(this.firstNode, this.lastNode, !this.reversed);
    }

    public boolean isReversed() {
        return this.reversed;
    }

    @NotNull
    public ReversiblePeekingIterator<Node> reversedIterator() {
        return new NodeIterator(this.firstNode, this.lastNode, !this.reversed);
    }
}

