/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.escaped.character.internal;

import com.vladsch.flexmark.ast.DoNotDecorate;
import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ext.escaped.character.EscapedCharacter;
import com.vladsch.flexmark.parser.block.NodePostProcessor;
import com.vladsch.flexmark.parser.block.NodePostProcessorFactory;
import com.vladsch.flexmark.util.NodeTracker;
import com.vladsch.flexmark.util.html.Escaping;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import com.vladsch.flexmark.util.sequence.ReplacedTextRegion;
import java.util.ArrayList;

public class EscapedCharacterNodePostProcessor
extends NodePostProcessor {
    public EscapedCharacterNodePostProcessor(Document document) {
    }

    public void process(NodeTracker state, Node node) {
        BasedSequence original = node.getChars();
        ReplacedTextMapper textMapper = new ReplacedTextMapper(original);
        BasedSequence literal = Escaping.unescape((BasedSequence)original, (ReplacedTextMapper)textMapper);
        int lastEscaped = 0;
        boolean wrapInTextBase = !(node.getParent() instanceof TextBase);
        TextBase textBase = wrapInTextBase ? null : (TextBase)node.getParent();
        ArrayList replacedRegions = textMapper.getRegions();
        for (ReplacedTextRegion region : replacedRegions) {
            int startOffset = region.getOriginalRange().getStart() - original.getStartOffset();
            int endOffset = region.getOriginalRange().getEnd() - original.getStartOffset();
            if (original.charAt(startOffset) != '\\' || region.getReplacedRange().length() != 1 || startOffset + 1 >= original.length()) continue;
            if (wrapInTextBase) {
                wrapInTextBase = false;
                textBase = new TextBase(original);
                node.insertBefore((Node)textBase);
                state.nodeAdded((Node)textBase);
            }
            if (startOffset != lastEscaped) {
                if (startOffset > original.length() || lastEscaped > original.length()) {
                    boolean bl = false;
                }
                BasedSequence escapedChars = original.subSequence(lastEscaped, startOffset);
                Text node1 = new Text(escapedChars);
                textBase.appendChild((Node)node1);
                state.nodeAdded((Node)node1);
            }
            BasedSequence origToDecorateText = original.subSequence(startOffset, endOffset);
            BasedSequence text = origToDecorateText.subSequence(1);
            EscapedCharacter decorationNode = new EscapedCharacter(origToDecorateText.subSequence(0, 1), text);
            textBase.appendChild((Node)decorationNode);
            state.nodeAdded((Node)decorationNode);
            lastEscaped = endOffset;
        }
        if (lastEscaped > 0) {
            if (lastEscaped != original.length()) {
                BasedSequence escapedChars = original.subSequence(lastEscaped, original.length());
                Text node1 = new Text(escapedChars);
                textBase.appendChild((Node)node1);
                state.nodeAdded((Node)node1);
            }
            node.unlink();
            state.nodeRemoved(node);
        }
    }

    public static class Factory
    extends NodePostProcessorFactory {
        public Factory() {
            super(false);
            this.addNodeWithExclusions(Text.class, new Class[]{DoNotDecorate.class});
        }

        public NodePostProcessor create(Document document) {
            return new EscapedCharacterNodePostProcessor(document);
        }
    }
}

