/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.schema;

import com.ververica.cdc.connectors.mysql.source.utils.StatementUtils;
import org.apache.commons.lang3.StringUtils;

class MySqlFieldDefinition {
    private String columnName;
    private String columnType;
    private boolean nullable;
    private boolean key;
    private String defaultValue;
    private String extra;
    private boolean unique;

    MySqlFieldDefinition() {
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getColumnType() {
        return this.columnType;
    }

    public void setColumnType(String columnType) {
        this.columnType = columnType;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public String getDefaultValue() {
        return StringUtils.isEmpty((CharSequence)this.defaultValue) ? "" : "DEFAULT " + this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isUnsigned() {
        return StringUtils.containsIgnoreCase((CharSequence)this.columnType, (CharSequence)"unsigned");
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isKey() {
        return this.key;
    }

    public void setKey(boolean key) {
        this.key = key;
    }

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public String toDdl() {
        return StatementUtils.quote(this.columnName) + " " + this.columnType + " " + (this.nullable ? "" : "NOT NULL");
    }
}

