/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.support.utils;

import com.verizon.ads.Logger;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Macros {
    private static final Logger logger = Logger.getInstance(Macros.class);

    public static String replacePattern(Pattern pattern, String source, Map<String, String> macros) {
        return Macros.replacePattern(pattern, source, macros, null);
    }

    public static String replacePattern(Pattern pattern, String source, Map<String, String> macros, String defaultValue) {
        if (pattern == null || source == null) {
            return source;
        }
        try {
            Matcher matcher = pattern.matcher(source);
            if (!matcher.find()) {
                return source;
            }
            StringBuffer sb = new StringBuffer(source.length() + 512);
            do {
                String replacement;
                String key = matcher.group();
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    if (matcher.group(i) == null) continue;
                    key = matcher.group(i);
                    break;
                }
                if (key.length() == 0) {
                    return source;
                }
                String string = replacement = macros != null ? macros.get(key) : null;
                if (replacement != null) {
                    matcher.appendReplacement(sb, replacement);
                    continue;
                }
                logger.w(String.format("Value for macro key %s was not provided", key));
                if (defaultValue == null) continue;
                matcher.appendReplacement(sb, defaultValue);
            } while (matcher.find());
            matcher.appendTail(sb);
            String result = sb.toString();
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d(String.format("Macro replacement:\nsource:%s\nresult:%s", source, result));
            }
            return result;
        }
        catch (Exception e) {
            logger.e("Error performing macro replacement", (Throwable)e);
            return source;
        }
    }
}

