/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.support;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import com.verizon.ads.Component;
import com.verizon.ads.ComponentFactory;
import com.verizon.ads.Logger;
import com.verizon.ads.RuleComponent;
import com.verizon.ads.VideoPlayer;
import com.verizon.ads.VideoPlayerView;
import com.verizon.ads.support.ViewabilityWatcherRule;
import com.verizon.ads.utils.ThreadUtils;
import java.util.Map;
import org.json.JSONObject;

public class VideoViewabilityRuleComponent
extends ViewabilityWatcherRule
implements RuleComponent,
VideoPlayer.VideoPlayerListener {
    private static final Logger logger = Logger.getInstance(VideoViewabilityRuleComponent.class);
    private final Map<String, Object> eventArgs;
    private final String eventId;
    private final boolean audioRequired;
    private boolean ruleHasFired;
    private RuleComponent.RuleListener listener;
    private float currentVolume;
    private int lastPosition;
    private boolean playbackComplete = false;
    private boolean paused = false;

    protected VideoViewabilityRuleComponent(VideoPlayerView videoPlayerView, RuleComponent.RuleListener listener, int percentage, int duration, boolean continuous, boolean audioRequired, String eventId, Map<String, Object> eventArgs) {
        super((View)videoPlayerView, percentage, duration, continuous);
        this.listener = listener;
        this.eventId = eventId;
        this.eventArgs = eventArgs;
        this.audioRequired = audioRequired;
        this.ruleHasFired = false;
        VideoViewabilityRuleComponent.runOnUiThread(() -> {
            VideoPlayer videoPlayer = videoPlayerView.getVideoPlayer();
            if (videoPlayer != null) {
                this.lastPosition = Math.max(videoPlayer.getCurrentPosition(), 0);
                if (audioRequired) {
                    this.currentVolume = videoPlayer.getVolume();
                }
                videoPlayer.registerListener((VideoPlayer.VideoPlayerListener)this);
            }
        });
    }

    public String getEventId() {
        return this.eventId;
    }

    public Map<String, Object> getEventArgs() {
        return this.eventArgs;
    }

    public void fire() {
        if (!VideoViewabilityRuleComponent.isOnUiThread()) {
            logger.e("Must be on the UI thread to fire rule");
            return;
        }
        if (this.ruleHasFired) {
            logger.d("Rule has already fired");
            return;
        }
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d(String.format("Firing rule: %s", this));
        }
        this.ruleHasFired = true;
        this.stopListening();
        this.stopTracking();
        this.stopWatching();
        if (this.listener != null) {
            this.listener.onRuleFired((RuleComponent)this);
        }
    }

    public boolean hasFired() {
        return this.ruleHasFired;
    }

    public void reset() {
    }

    @Override
    public void release() {
        logger.d("Releasing");
        this.stopTracking();
        this.stopListening();
        this.listener = null;
        super.release();
    }

    void stopListening() {
        VideoPlayer videoPlayer;
        View view = this.getView();
        if (view != null && (videoPlayer = ((VideoPlayerView)view).getVideoPlayer()) != null) {
            videoPlayer.unregisterListener((VideoPlayer.VideoPlayerListener)this);
        }
    }

    @Override
    @SuppressLint(value={"DefaultLocale"})
    @NonNull
    public String toString() {
        return String.format("VideoViewabilityRuleComponent{eventId: %s, audioRequired: %s, %s}", this.eventId, this.audioRequired, super.toString());
    }

    @Override
    protected boolean shouldTrack() {
        return this.isViewable() && (!this.audioRequired || this.isAudioOn()) && !this.playbackComplete;
    }

    @Override
    protected long getCurrentTrackingTime() {
        return this.lastPosition;
    }

    boolean isAudioOn() {
        return this.currentVolume > 0.0f;
    }

    void updateVideoProgress(int position) {
        if (position <= this.lastPosition) {
            return;
        }
        this.lastPosition = Math.max(position, 0);
        if (!this.isTracking()) {
            return;
        }
        if (this.getTimeInView() >= (long)this.getDuration()) {
            VideoViewabilityRuleComponent.runOnUiThread(this::fire);
        }
    }

    public void onLoaded(VideoPlayer videoPlayer) {
    }

    public void onUnloaded(VideoPlayer videoPlayer) {
    }

    public void onReady(VideoPlayer videoPlayer) {
    }

    public void onPlay(VideoPlayer videoPlayer) {
        logger.d("video is playing.");
        VideoViewabilityRuleComponent.runOnUiThread(() -> {
            if (this.playbackComplete) {
                this.lastPosition = 0;
                this.playbackComplete = false;
            } else {
                this.lastPosition = Math.max(videoPlayer.getCurrentPosition(), 0);
            }
            if (!this.paused) {
                this.startTracking();
            } else {
                this.paused = false;
            }
        });
    }

    public void onPaused(VideoPlayer videoPlayer) {
        this.paused = true;
        VideoViewabilityRuleComponent.runOnUiThread(this::stopTracking);
    }

    public void onComplete(VideoPlayer videoPlayer) {
        this.playbackComplete = true;
        VideoViewabilityRuleComponent.runOnUiThread(this::stopTracking);
    }

    public void onProgress(VideoPlayer videoPlayer, int position) {
        this.updateVideoProgress(position);
    }

    public void onSeekCompleted(VideoPlayer videoPlayer) {
    }

    public void onError(VideoPlayer videoPlayer) {
    }

    public void onVolumeChanged(VideoPlayer videoPlayer, float volume) {
        if (!this.audioRequired) {
            return;
        }
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d(String.format("video player volume changed to <%f>", Float.valueOf(volume)));
        }
        boolean previouslyOn = this.isAudioOn();
        this.currentVolume = volume;
        boolean currentlyOn = this.isAudioOn();
        if (previouslyOn != currentlyOn) {
            VideoViewabilityRuleComponent.runOnUiThread(() -> {
                if (currentlyOn) {
                    this.startTracking();
                } else {
                    this.stopTracking();
                }
            });
        }
    }

    public void onClick(VideoPlayer videoPlayer) {
    }

    public void onVideoSizeChanged(int width, int height) {
    }

    static boolean isOnUiThread() {
        return ThreadUtils.isUiThread();
    }

    static void runOnUiThread(Runnable runnable) {
        ThreadUtils.runOnUiThread((Runnable)runnable);
    }

    public static class Factory
    implements ComponentFactory {
        public Component newInstance(Context context, JSONObject ruleInfo, Object ... args) {
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d(String.format("Creating VideoViewabilityRuleComponent with ruleInfo: %s", ruleInfo));
            }
            if (ruleInfo == null) {
                logger.e("ruleInfo cannot be null.");
                return null;
            }
            if (args == null || args.length < 2 || !(args[0] instanceof VideoPlayerView) || !(args[1] instanceof RuleComponent.RuleListener)) {
                logger.e("Call to newInstance requires VideoPlayerView and RuleListener");
                return null;
            }
            VideoPlayerView videoPlayerView = (VideoPlayerView)args[0];
            RuleComponent.RuleListener listener = (RuleComponent.RuleListener)args[1];
            JSONObject data = ruleInfo.optJSONObject("data");
            if (data == null) {
                logger.e("data in ruleInfo is either missing or not a dictionary");
                return null;
            }
            try {
                String eventId = data.getString("eventId");
                int percentage = data.getInt("percentage");
                int duration = data.getInt("duration");
                boolean continuous = data.getBoolean("continuous");
                boolean audioRequired = data.getBoolean("audio");
                if (percentage < 0 || percentage > 100) {
                    throw new Exception("Percentage must be >= 0 and <= 100");
                }
                if (duration < 0 || duration > 15000) {
                    throw new Exception("Duration must be >= 0 and <= 15000");
                }
                Map<String, Object> eventArgs = null;
                if (data.has("eventArgs")) {
                    eventArgs = ViewabilityWatcherRule.convertJSONToMap(data.getJSONObject("eventArgs"));
                }
                return this.createVideoViewabilityRule(videoPlayerView, listener, percentage, duration, continuous, audioRequired, eventId, eventArgs);
            }
            catch (Exception e) {
                logger.e(String.format("Error creating VideoViewabilityRuleComponent with ruleInfo: %s", ruleInfo), (Throwable)e);
                return null;
            }
        }

        @NonNull
        VideoViewabilityRuleComponent createVideoViewabilityRule(VideoPlayerView videoPlayerView, RuleComponent.RuleListener listener, int percent, int duration, boolean continuous, boolean audioRequired, String eventId, Map<String, Object> eventArgs) {
            VideoViewabilityRuleComponent viewabilityRule = new VideoViewabilityRuleComponent(videoPlayerView, listener, percent, duration, continuous, audioRequired, eventId, eventArgs);
            if (Logger.isLogLevelEnabled((int)3)) {
                logger.d(String.format("Rule created %s", viewabilityRule));
            }
            return viewabilityRule;
        }
    }
}

