/*
 * Decompiled with CFR 0.152.
 */
package com.verizon.ads.support;

import android.annotation.SuppressLint;
import android.view.View;
import androidx.annotation.NonNull;
import com.verizon.ads.Logger;
import com.verizon.ads.support.utils.ViewabilityWatcher;
import com.verizon.ads.utils.ThreadUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@SuppressLint(value={"DefaultLocale"})
public class ViewabilityWatcherRule
implements ViewabilityWatcher.ViewabilityListener {
    private static final Logger logger = Logger.getInstance(ViewabilityWatcherRule.class);
    private boolean tracking;
    private final boolean continuous;
    private volatile long timeViewable;
    private volatile long trackingStartTime;
    private ViewabilityWatcher viewabilityWatcher;
    final int duration;

    protected ViewabilityWatcherRule(View view, int percentage, int duration, boolean continuous) {
        this.duration = duration;
        this.continuous = continuous;
        this.tracking = false;
        this.timeViewable = 0L;
        this.startWatching(view, percentage);
    }

    @Override
    public void onViewableChanged(boolean viewable) {
        if (Logger.isLogLevelEnabled((int)3)) {
            logger.d(String.format("onViewableChanged: %s, %s", viewable, this));
        }
        if (viewable) {
            this.startTracking();
        } else {
            this.stopTracking();
        }
    }

    View getView() {
        return this.viewabilityWatcher != null ? this.viewabilityWatcher.getView() : null;
    }

    boolean isViewable() {
        return this.viewabilityWatcher != null && this.viewabilityWatcher.viewable;
    }

    public void release() {
        logger.d("Releasing");
        this.stopWatching();
    }

    private void startWatching(View view, int percentage) {
        this.viewabilityWatcher = new ViewabilityWatcher(view, this);
        this.viewabilityWatcher.setMinViewabilityPercent(percentage);
        this.viewabilityWatcher.startWatching();
    }

    void stopWatching() {
        if (this.viewabilityWatcher != null) {
            this.viewabilityWatcher.stopWatching();
            this.viewabilityWatcher = null;
        }
    }

    @NonNull
    public String toString() {
        if (this.viewabilityWatcher == null) {
            return "ViewabilityWatcherRule";
        }
        return String.format("ViewabilityWatcherRule{view: %s, percentage: %d, duration: %d, continuous: %s, time in view: %d}", this.viewabilityWatcher.getView(), this.viewabilityWatcher.getMinViewabilityPercent(), this.duration, this.continuous, this.getTimeInView());
    }

    protected boolean shouldTrack() {
        return true;
    }

    protected long getCurrentTrackingTime() {
        return 0L;
    }

    protected void onStartTracking() {
    }

    protected void onStopTracking() {
    }

    void startTracking() {
        if (this.tracking) {
            logger.d("Already tracking");
            return;
        }
        if (!this.shouldTrack()) {
            logger.d("Tracking criteria not satisifed -- not tracking");
            return;
        }
        logger.d("Starting tracking");
        this.tracking = true;
        this.trackingStartTime = this.getCurrentTrackingTime();
        this.onStartTracking();
    }

    void stopTracking() {
        if (!this.tracking) {
            return;
        }
        logger.d("Stopping tracking");
        this.timeViewable = this.continuous ? 0L : this.getTimeInView();
        this.trackingStartTime = 0L;
        this.tracking = false;
        this.onStopTracking();
    }

    boolean isTracking() {
        return this.tracking;
    }

    long getCurrentTimeInView() {
        return this.isTracking() ? this.getCurrentTrackingTime() - this.trackingStartTime : 0L;
    }

    long getTimeInView() {
        return this.timeViewable + this.getCurrentTimeInView();
    }

    static ThreadUtils.ScheduledRunnable runOnUiThreadDelayed(Runnable runnable, long delay) {
        return ThreadUtils.runOnUiThreadDelayed((Runnable)runnable, (long)delay);
    }

    static boolean isOnUiThread() {
        return ThreadUtils.isUiThread();
    }

    static Map<String, Object> convertJSONToMap(JSONObject json) {
        if (json == null) {
            return null;
        }
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Iterator iterator = json.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                map.put(key, json.get(key));
            }
            return map;
        }
        catch (JSONException e) {
            logger.e("Error converting JSON to map", (Throwable)e);
            return null;
        }
    }
}

